#
# Copyright 2024 XEBIALABS
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

from dynatrace.DynatraceServer import DynatraceServer
from dynatrace.util import *

url=dynatraceServer['url']
url = url.strip("/")
dynatraceServer = DynatraceServer(dynatraceServer)

responseBatch = dynatraceServer.getBatchStatus(str(batchId))
batchStatus = responseBatch["batchStatus"]
currentRetryCount = currentRetryCount + 1

for failedExecution in responseBatch.get("failedExecutions", []):
    executionIds[failedExecution["executionId"]] = failedExecution["failureMessage"]

if batchStatus == "SUCCESS":
    task.setStatusLine("Status: %s"% (batchStatus))
    for executionId in executionIds:
        if executionIds[executionId] == "RUNNING":
            executionIds[executionId] = "SUCCESS"
    url=url.replace('.live', '.apps')
    print("[Execution Link](" + url + "/ui/apps/dynatrace.classic.synthetic/ui/" + monitorType.lower() + "-monitor/" + monitorId + "/ondemand" + ")")

elif batchStatus == "FAILED":
    task.setStatusLine("Status: %s"%(batchStatus))
    errorDetails = "\n".join(
    ["Execution ID: {}, Failure Message: {}".format(executionId, failureMessage) 
     for executionId, failureMessage in executionIds.items()]
)       
    error("Failed to execute batch: %s\nDetails:\n%s" % (batchId, errorDetails))    

else:
    if currentRetryCount < maxRetries:
        task.setStatusLine("Status: %s, Retry #%d" % (batchStatus, currentRetryCount))
        task.schedule("dynatrace/triggerOnDemandExecutions-waitForSuccessfulRun.py", waitTime)
    else:
        error("Status retry check exhausted")


