#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import json

from fortifyOnDemand.client.FortifyOnDemandClientUtil import FortifyOnDemandClientUtil
from fortifyOnDemand.task import add_comment

API_BASE = "/api/v3"
ERROR_RESPONSE_MESSAGE = "Failed to get application data. Server return [%s], with content [%s]"


class FortifyOnDemandService(object):

    @staticmethod
    def get_application_data(fortify_server, application_name):
        fortify_on_demand_client = FortifyOnDemandClientUtil.get_fortify_on_demand_client(fortify_server)
        fortify_response = fortify_on_demand_client.http_request.get(
            "{}/applications?filters=applicationName:{}".format(API_BASE, application_name))
        error_message = ERROR_RESPONSE_MESSAGE % (fortify_response.status, fortify_response.response)
        FortifyOnDemandService.validate_response(error_message, fortify_response)
        return json.loads(fortify_response.getResponse())

    @staticmethod
    def get_release_ratings(fortify_server, application_id, release_name):
        fortify_on_demand_client = FortifyOnDemandClientUtil.get_fortify_on_demand_client(fortify_server)
        fortify_response = fortify_on_demand_client.http_request.get(
            "{}/applications/{}/releases?filters=releaseName:{}".format(API_BASE, application_id, release_name))
        error_message = ERROR_RESPONSE_MESSAGE % (fortify_response.status, fortify_response.response)
        FortifyOnDemandService.validate_response(error_message, fortify_response)
        return json.loads(fortify_response.getResponse())

    @staticmethod
    def get_releases_by_application_name(fortify_server, application_name, offset=0, limit=50):
        fortify_on_demand_client = FortifyOnDemandClientUtil.get_fortify_on_demand_client(fortify_server)
        fortify_response = fortify_on_demand_client.http_request.get(
            "{}/releases?filters=applicationName:{}&fields=releaseId,releaseName,releaseCreatedDate&offset={}&limit={}".format(API_BASE, application_name,
                                                                                                                               offset, limit))
        error_message = ERROR_RESPONSE_MESSAGE % (fortify_response.status, fortify_response.response)
        FortifyOnDemandService.validate_response(error_message, fortify_response)
        return json.loads(fortify_response.getResponse())

    @staticmethod
    def get_release_vulnerability_filters(fortify_server, release_id):
        fortify_on_demand_client = FortifyOnDemandClientUtil.get_fortify_on_demand_client(fortify_server)
        fortify_response = fortify_on_demand_client.http_request.get("{}/releases/{}/vulnerability-filters".format(API_BASE, release_id))
        error_message = ERROR_RESPONSE_MESSAGE % (fortify_response.status, fortify_response.response)
        FortifyOnDemandService.validate_response(error_message, fortify_response)
        return json.loads(fortify_response.getResponse())

    @staticmethod
    def validate_response(error_message, fortify_response):
        if not fortify_response.isSuccessful():
            raise Exception(error_message)
