#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

from java.lang import InterruptedException, Thread
from java.util.concurrent import Executors, TimeUnit

MAX_CONCURRENT = 10


class FortifyConcurrentExecutorService:
    def __init__(self, max_concurrent=MAX_CONCURRENT):
        self._max_concurrent = max_concurrent
        self._tasks = []
        self._executor_service = Executors.newFixedThreadPool(max_concurrent)

    def add(self, task):
        self._tasks.append(task)

    def set_tasks(self, tasks):
        self._tasks = tasks

    def execute(self, timeout=120):
        futures = self._executor_service.invokeAll(self._tasks)
        self._shutdown_and_await_termination(timeout)
        return futures

    def _shutdown_and_await_termination(self, timeout):
        self._executor_service.shutdown()
        try:
            if not self._executor_service.awaitTermination(timeout, TimeUnit.SECONDS):
                self._executor_service.shutdownNow()
        except InterruptedException as ex:
            self._executor_service.shutdownNow()
            Thread.currentThread().interrupt()
