#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

from org.apache.http.client import ClientProtocolException
from xlrelease.HttpRequest import HttpRequest

params = {'url': configuration.url, 'username': configuration.username, 'password': configuration.password,
          'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort,
          'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword, 'proxyDomain': configuration.proxyDomain}

path = "api/v1/projectVersions?fields=id&limit=1"

headers_fortify_token = {}

if configuration.password:
    headers_fortify_token = {
        "Authorization": "FortifyToken {}".format(configuration.password),
        "Content-Type": "application/json",
        "Accept": "application/json"
    }
else:
    raise Exception("Token Not given, Please enter the Token.")

params.pop('username')
params.pop('password')

http_request = HttpRequest(params)
response = http_request.get(path, headers=headers_fortify_token)

if not response.isSuccessful():
    error_message = "Connection to Fortify SSC server failed. Server returned [%s], with content [%s]" % (
        response.status, response.response)
    raise Exception(error_message)


