#
# Copyright 2020 XEBIALABS
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

import os
import urlparse


def get_proxy():
    proxyHost, proxyPort, proxyUsername, proxyPassword = None, None, None, None
    http_proxy = os.getenv('HTTP_PROXY') or os.getenv('http_proxy')
    if not http_proxy:
        return proxyHost, proxyPort, proxyUsername, proxyPassword
    parsed = urlparse.urlparse(http_proxy)
    proxyHost = parsed.hostname if parsed.hostname else None
    proxyPort = str(parsed.port) if parsed.port else None
    proxyUsername = parsed.username if parsed.username else None
    proxyPassword = parsed.password if parsed.password else None
    return proxyHost, proxyPort, proxyUsername, proxyPassword
