# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

from gitlab.Client import Client

import json

if gitlab_server is None:
    raise Exception("No GitLab server provided.")

client = Client()
latestTags = client.gitlab_tag_statuses(locals())
if latestTags:
    latestTag = latestTags[0]
    newTriggerState = json.dumps(latestTag)
    if triggerState and triggerState != newTriggerState:
        tagName = latestTag["name"]
        tagMessage = latestTag["message"]
        commitId = latestTag["commit"]["id"]
        commitTitle = latestTag["commit"]["title"]
        commitMessage = latestTag["commit"]["message"]
        commitAuthor = latestTag["commit"]["author_name"]
        commitCommitter = latestTag["commit"]["committer_name"]
        commitCreationDatetime = latestTag["commit"]["created_at"]
        commitAuthoredDatetime = latestTag["commit"]["authored_date"]
        commitCommittedDatetime = latestTag["commit"]["committed_date"]
        triggerState = newTriggerState
        print("GitLab triggered release for commit %s tagged as %s" % (commitId, tagName))
    elif not triggerState:
        triggerState = newTriggerState
elif not triggerState:
    triggerState = "InitialState"
