/*
 * Decompiled with CFR 0.152.
 */
package com.dai.gitlab;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;

public class JGitClient {
    public static void cloneRepository(String repoName, String repoUrl, String localPath, String branch, boolean removeExisitingFolder, String password) throws GitAPIException, IllegalArgumentException, IOException {
        File localDir = new File((String)(localPath = (String)localPath + File.separator + repoName));
        if (!localDir.exists()) {
            localDir.mkdirs();
        } else if (localDir.exists() && localDir.isDirectory() && localDir.list().length > 0) {
            if (removeExisitingFolder) {
                JGitClient.deleteDirectory(localDir);
            } else {
                throw new IllegalArgumentException("Target directory not empty");
            }
        }
        CloneCommand cloneCommand = Git.cloneRepository().setURI(repoUrl).setDirectory(localDir);
        if (branch != null && !branch.equals("")) {
            cloneCommand.setBranch("refs/heads/" + branch);
        }
        try (Git result = cloneCommand.call();){
            System.out.println("Repository created: " + result.getRepository().getDirectory());
        }
    }

    public static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                JGitClient.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public static String stageAndCommitFiles(String localPath, List<String> files, String commitMessage, Boolean pushToRemote, String password) throws IOException, GitAPIException {
        Object message = "status::FAILED";
        for (String filePath : files) {
            File fileItem = new File(localPath + File.separator + filePath);
            if (fileItem.exists()) continue;
            throw new IllegalArgumentException("Input file does not exist::" + filePath);
        }
        try (Git git = Git.open((File)new File(localPath + File.separator + ".git"));){
            String branch = git.getRepository().getFullBranch();
            for (String file : files) {
                git.add().addFilepattern(file).call();
            }
            git.commit().setMessage(commitMessage).call();
            Pattern p = Pattern.compile("\\[(.*?)\\]");
            if (pushToRemote.booleanValue()) {
                Iterable pushResults = git.push().call();
                for (PushResult result : pushResults) {
                    Collection remoteUpdates = result.getRemoteUpdates();
                    for (RemoteRefUpdate update : remoteUpdates) {
                        message = "status::" + update.getStatus();
                        Matcher m = p.matcher(update.getNewObjectId().toString());
                        if (m.find()) {
                            message = (String)message + " CommitId::" + m.group();
                        }
                        System.out.println("RemoteRefUpdate - " + (String)message);
                    }
                }
            }
        }
        return message;
    }
}

