# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

import json
from gitlab.Client import Client
from java.time import LocalDate, ZonedDateTime


def convertRFC3339ToDate(timestamp):
    zonedDateTime = ZonedDateTime.parse(timestamp)
    return zonedDateTime.toLocalDate()

if gitlab_server is None or project_id is None or results_limit is None:
    data = {}
else:
    client = Client()
    commits = json.loads(client.gitlab_querycommits(locals())["commits"])

    # Compile data for summary view
    commitsByDay = {}
    for commit in commits:
        commitDate = convertRFC3339ToDate(commit["committed_date"])
        if commitDate in commitsByDay.keys():
            commitsByDay[commitDate] += 1
        else:
            commitsByDay[commitDate] = 1

    dates = [date for date in commitsByDay.keys()]
    dates.sort()
    startDate = dates[0]
    endDate = dates[-1]
    days = []
    commitsEachDay = []
    daysWithCommits = [dayCommits.toString() for dayCommits in commitsByDay.keys()]
    while startDate.isBefore(endDate.plusDays(1)):
        days.append(startDate.toString())
        if startDate.toString() in daysWithCommits:
            commitsEachDay.append(commitsByDay[startDate])
        else:
            commitsEachDay.append(0)
        startDate = startDate.plusDays(1)

    data = {"dates": days, "commitsEachDay": commitsEachDay, "commits": commits}
