# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

from gitlab.Client import Client

client=Client()
response = client.gitlab_runjob(locals())
if response is not None:
    for key, value in response.items():
        locals()[key] = value
task.setStatusLine("Job run triggered")
if waitForCompletion:
    task.schedule("gitlab/runJob-wait.py")
else:
    jobStatus = response["status"].title()
    task.setStatusLine("Status: {0}".format(jobStatus))
    if jobStatus == "Failed":
        raise Exception("Job ended with status: {0} due to {1}".format(response["status"], response.get("failure_reason", "unknown reason")))
    print(response["web_url"])