#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import logging
import sys
import yaml
import logging

from kubernetes.api_client import APIClient
from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement

from os.path import exists

global configPath, connectionConfig, kubectlPath, _ci

logger = logging.getLogger("KubeContextList")
logger.addHandler(logging.StreamHandler(sys.stdout))

resultType = []
remoteError = None
localError = None
fileContent = None
host = _ci.getProperty("host")

if configPath:
    try:
        logger.error("Trying to read from remote machine")
        client = APIClient(host, kubectlPath)
        response = client.readRemoteFile(configPath)
        if response.rc == 0:
            fileContent = yaml.safe_load(response.stdout)
            logger.error("File read from remote machine successfully")
        else:
            logger.error("Failed to read file from remote machine")
    except Exception as e:
        remoteError = e.message
        logger.error("Failed to read file from remote machine")

    if not fileContent:
        try:
            if exists(configPath):
                logger.error("File exists locally(Release) machine")
                with open(configPath) as f:
                    fileContent = yaml.load(f, Loader=yaml.FullLoader)
            else:
                logger.error("File does not exist locally(Release) machine")
                localError = "File does not exist locally(Release) machine"
        except Exception as e:
            localError = e.message
            logger.error("Failed to read file from local machine")

    if fileContent:
        for yamlContext in fileContent['contexts']:
            resultType.append(LookupResultElement(yamlContext['name'], yamlContext['name']))
        result = resultType
    else:
        parseError = 'Failed to load and parse KubeConfig, LocalError: ' + localError if localError else ''  + ' , RemoteError ' + remoteError if remoteError else ''
        logger.error(parseError)
else:
    logger.error('Specify the path of KubeConfig file')
