from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement
from managedApplications import DEFAULT_PAGE, MAX_RESULTS_PER_PAGE, MAX_DEPTH

global _ci

folder_input = _ci.getProperty("folderId")
if not folder_input:
    folder_input = ""

def extract_ids_and_titles(folder, filter, parent_title=""):
    full_title = parent_title + "/" + folder.getTitle() if parent_title else folder.getTitle()
    ids_and_titles = []

    if filter.lower() in full_title.lower():
        ids_and_titles = [{"id": folder.getId(), "title": full_title}]

    for child in folder.getChildren():
        ids_and_titles.extend(extract_ids_and_titles(child, filter, full_title))

    return ids_and_titles


ids_with_titles = []
folders = folderApi.listRoot(DEFAULT_PAGE, MAX_RESULTS_PER_PAGE, MAX_DEPTH, False)
for folder in folders:
    ids_with_titles.extend(extract_ids_and_titles(folder, folder_input))

result = list(
    map(lambda (id_with_title): LookupResultElement(id_with_title["title"], id_with_title["id"]), ids_with_titles))
