import sys
from org.apache.http.client import ClientProtocolException

global configuration

params = {'url': configuration.url, 'username': configuration.username, 'password': configuration.password,
          'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort,
          'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword,
          'proxyDomain': configuration.proxyDomain}

if (configuration.serverVersion == "Nexus v3+"):
    nexusVersionNum = 3
    path = configuration.checkConfigurationPathNexus3
else:
    #default nexus version 2
    path = configuration.checkConfigurationPathNexus2
    nexusVersionNum = 2

response = None
try:
    response = HttpRequest(params).head(path, contentType='*/*')
except ClientProtocolException:
    raise Exception("URL is not valid")

if not response.isSuccessful():
    reason = "Unknown"
    if response.status == 400:
        reason = "Bad request"
    elif response.status == 401:
        reason = "Unauthorized"
    elif response.status == 403:
        reason = "Forbidden"
    raise Exception("HTTP response code %s (%s)" % (response.status, reason))
