import sys
import urllib2
import base64
import com.xebialabs.xlrelease.plugin.openshift.RemoteScript as RemoteScript

class APIClient:

    def __init__(self, host,oc_path):
        self.remote = RemoteScript(host)
        self.oc_path = oc_path


    def execute_openshift_spec(self, spec, command ,cmd_params = None):
        response = self.remote.executeOpenshiftSpec(spec,'%s %s %s -f ' % (self.oc_path, command, cmd_params if cmd_params else ''))
        APIClient.print_logs(response)
        return response

    def execute_openshift_command (self, command ,cmd_params = None, process_exit = True):
        response = self.remote.executeScript('%s %s %s' % (self.oc_path, command, cmd_params if cmd_params else ''))
        APIClient.print_logs(response, process_exit)
        return response

    def execute_openshift_command_only (self, command ,cmd_params = None):
        response = self.remote.executeScript('%s %s %s' % (self.oc_path, command, cmd_params if cmd_params else ''))
        return response

    def execute_command(self,command):
        response = self.remote.executeScript(command)
        APIClient.print_logs(response)
        return response

    @staticmethod
    def download_file(url, username, password):
        request=urllib2.Request(url)
        if (username is not None) and (password is not None):
            base64string = base64.encodestring('%s:%s' % (username, password))[:-1]
            auth_header =  "Basic %s" % base64string
            request.add_header("Authorization", auth_header)

        return urllib2.urlopen(request).read()

    @staticmethod
    def add_comment(comment):
        print "```"
        print comment
        print "```"

    @staticmethod
    def print_logs(response, process_exit = True):
        output = response.stdout
        error = response.stderr
        if response.rc == 0:
            print "```"
            print output
            print "```"
        else:
            print "Exit code: "
            print response.rc
            print
            print "#### Output:"
            print "```"
            print output
            print "```"

            print "----"
            print "#### Error stream:"
            print "```"
            print error
            print "```"
            print

            if process_exit:
                sys.exit(response.rc)