'use strict';

angular.module('xlrelease').directive('donutChart', ['reportConfigurationService', 'Events', function (reportConfigurationService, Events) {
    return {
        scope: {
            data: '=',
            options: '=' /*
                         topTitleText: Text/Function(scope.data)
                         bottomTitleText: Text/Function(scope.data)
                         series: Function(scope.data) => [{name: 'Tasks', data: [...]}]
                         showLegend: true/false
                         donutThickness: 70%
                         */
        },

        link: function link(scope, element) {

            var chart = [];

            function addTitle() {
                if (this.title) {
                    this.title.destroy();
                }

                // store chart so we can trigger when draw when the file finished resizing
                chart = this;
                var r = this.renderer,
                    x = this.series[0].center[0] + this.plotLeft,
                    y = this.series[0].center[1] + this.plotTop;

                var topTitleText = applyOrGet(scope.options.topTitleText, scope.data);
                var bottomTitleText = applyOrGet(scope.options.bottomTitleText, scope.data);

                var titleHtml = "<div><span>" + topTitleText + "</span><br><span>" + bottomTitleText + "</span></div>";
                this.title = r.label(titleHtml, x - 53, y - 12, 'rect', 0, 0, true, true, 'two-part-title').add();

                chart.container.onclick = null;
            }

            function applyOrGet(textOrFunction, args) {
                if (_.isFunction(textOrFunction)) {
                    return textOrFunction(args);
                }
                return "" + textOrFunction;
            }

            var series = scope.options.series(scope.data);
            _.forEach(series, function (serie) {
                serie.type = 'pie';
                serie.dataLabels = {
                    enabled: false
                };
            });

            element.highcharts(reportConfigurationService.getHighchartsOptions({
                tooltip: {
                    hideDelay: 0
                },
                chart: {
                    events: {
                        load: addTitle,
                        redraw: addTitle
                    }
                },
                plotOptions: {
                    pie: {
                        showInLegend: scope.options.showLegend,
                        allowPointSelect: false,
                        innerSize: scope.options.donutThickness,
                        borderWidth: 0,
                        point: {
                            events: {
                                legendItemClick: function legendItemClick(e) {
                                    e.preventDefault();
                                }
                            }
                        }
                    }
                },
                title: {
                    text: "",
                    floating: true
                },
                series: series
            }));

            scope.$on(Events.tile.resized, function () {
                chart.reflow();
            });
        }
    };
}]);