'use strict';

(function () {

    var TasksOverviewTileController = function TasksOverviewTileController($scope, ReleasesService, TasksService, FlagService) {
        var vm = this;
        var UNASSIGNED_USER = null;

        vm.showTeams = true;
        vm.showOwners = false;
        vm.teams = [];
        vm.owners = [];
        vm.selectTeams = selectTeams;
        vm.selectOwners = selectOwners;

        vm.isTaskInProgress = TasksService.isTaskInProgress;
        vm.isTaskFailed = TasksService.isTaskFailed;
        vm.isTaskFailing = TasksService.isTaskFailing;
        vm.isTaskWaitingForInput = TasksService.isTaskWaitingForInput;
        vm.isTaskFlagged = FlagService.isTaskFlagged;
        vm.isTaskDelayed = TasksService.isTaskDelayed;
        vm.isAssignedToTeam = TasksService.isAssignedToTeam;
        vm.isAssignedToUser = isAssignedToUser;
        vm.isCurrentTask = isCurrentTask;
        vm.isCurrentTeamTask = isCurrentTeamTask;
        vm.isCurrentTaskForUser = isCurrentTaskForUser;

        vm.release = $scope.release;
        vm.flattenedTasks = ReleasesService.getLeafTasks(vm.release);
        vm.teams = _.chain(vm.flattenedTasks).filter(TasksService.hasTeam).pluck('team').uniq().value();
        vm.owners = _.chain(vm.flattenedTasks).filter(TasksService.hasOwner).pluck('owner').uniq('username').value();
        vm.owners.push(UNASSIGNED_USER);

        ///

        function selectTeams() {
            vm.showTeams = true;
            vm.showOwners = false;
        }

        function selectOwners() {
            vm.showTeams = false;
            vm.showOwners = true;
        }

        function isCurrentTask(task) {
            return vm.isTaskInProgress(task) || vm.isTaskFailed(task) || vm.isTaskWaitingForInput(task) || vm.isTaskFailing(task);
        }

        function isCurrentTeamTask(task, team) {
            return vm.isAssignedToTeam(task, team) && vm.isCurrentTask(task);
        }

        function isCurrentTaskForUser(task, user) {
            return vm.isAssignedToUser(task, user) && vm.isCurrentTask(task);
        }

        function isAssignedToUser(task, user) {
            return TasksService.isAssignedToUser(task, user) || !TasksService.hasOwner(task) && user === UNASSIGNED_USER;
        }
    };

    TasksOverviewTileController.$inject = ['$scope', 'ReleasesService', 'TasksService', 'FlagService'];

    angular.module('xlrelease').controller('summary.TasksOverviewTileController', TasksOverviewTileController);
})();