'use strict';

angular.module('xlrelease').directive('statusBadge', function () {
    return {
        restrict: 'E',
        scope: {
            status: '='
        },
        template: '<span class="label {{badge.style}}">{{ badge.message }}</span>',
        link: function link($scope) {
            var badgesStyle = [];
            badgesStyle['IN_PROGRESS'] = { style: 'label label-active', message: 'In progress' };
            badgesStyle['COMPLETED'] = { style: 'label label-completed', message: 'Completed' };
            badgesStyle['FAILED'] = { style: 'label label-warning-failed', message: 'Failed' };
            badgesStyle['FAILING'] = { style: 'label label-warning-failing', message: 'Failing' };
            badgesStyle['WAITING_FOR_INPUT'] = { style: 'label label-waiting', message: 'Waiting for input' };
            badgesStyle['PLANNED'] = { style: 'label label-planned', message: 'Planned' };
            badgesStyle['PENDING'] = { style: 'label label-pending', message: 'Pending' };
            badgesStyle['SKIPPED'] = { style: 'label label-default', message: 'Skipped' };
            $scope.badge = badgesStyle[$scope.status];
        }
    };
});