/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDumpEditor
implements ISVNEditor {
    private FSRoot myRoot;
    private FSFS myFSFS;
    private long myTargetRevision;
    private long myOldestDumpedRevision;
    private String myRootPath;
    private OutputStream myDumpStream;
    private boolean myUseDeltas;
    private boolean myIsVerify;
    private DirectoryInfo myCurrentDirInfo;
    private SVNDeltaCombiner myDeltaCombiner;
    private SVNDeltaGenerator myDeltaGenerator;

    public SVNDumpEditor(FSFS fsfs, FSRoot root, long toRevision, long oldestDumpedRevision, String rootPath, OutputStream dumpStream, boolean useDeltas, boolean isVerify) {
        this.myRoot = root;
        this.myFSFS = fsfs;
        this.myTargetRevision = toRevision;
        this.myOldestDumpedRevision = oldestDumpedRevision;
        this.myRootPath = rootPath;
        this.myDumpStream = dumpStream;
        this.myUseDeltas = useDeltas;
        this.myIsVerify = isVerify;
    }

    public void reset(FSFS fsfs, FSRoot root, long toRevision, long oldestDumpedRevision, String rootPath, OutputStream dumpStream, boolean useDeltas, boolean isVerify) {
        this.myRoot = root;
        this.myFSFS = fsfs;
        this.myTargetRevision = toRevision;
        this.myOldestDumpedRevision = oldestDumpedRevision;
        this.myRootPath = rootPath;
        this.myDumpStream = dumpStream;
        this.myUseDeltas = useDeltas;
        this.myIsVerify = isVerify;
        this.myCurrentDirInfo = null;
    }

    @Override
    public void abortEdit() throws SVNException {
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirectoryInfo parent = this.myCurrentDirInfo;
        this.myCurrentDirInfo = this.createDirectoryInfo(path, copyFromPath, copyFromRevision, parent);
        boolean isDeleted = parent.myDeletedEntries.containsKey(path);
        boolean isCopy = copyFromPath != null && SVNRevision.isValidRevisionNumber(copyFromRevision);
        this.dumpNode(path, SVNNodeKind.DIR, isDeleted ? 3 : 1, isCopy, isCopy ? copyFromPath : null, isCopy ? copyFromRevision : -1L);
        if (isDeleted) {
            parent.myDeletedEntries.remove(path);
        }
        this.myCurrentDirInfo.myIsWrittenOut = true;
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        boolean isCopy = copyFromPath != null && SVNRevision.isValidRevisionNumber(copyFromRevision);
        boolean isDeleted = this.myCurrentDirInfo.myDeletedEntries.containsKey(path);
        this.dumpNode(path, SVNNodeKind.FILE, isDeleted ? 3 : 1, isCopy, isCopy ? copyFromPath : null, isCopy ? copyFromRevision : -1L);
        if (isDeleted) {
            this.myCurrentDirInfo.myDeletedEntries.remove(path);
        }
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (!this.myCurrentDirInfo.myIsWrittenOut) {
            this.dumpNode(this.myCurrentDirInfo.myFullPath, SVNNodeKind.DIR, 0, false, this.myCurrentDirInfo.myComparePath, this.myCurrentDirInfo.myCompareRevision);
            this.myCurrentDirInfo.myIsWrittenOut = true;
        }
    }

    @Override
    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
    }

    @Override
    public void closeDir() throws SVNException {
        if (this.myIsVerify) {
            FSRevisionNode node = this.myRoot.getRevisionNode(this.myCurrentDirInfo.myFullPath);
            Map entries = node.getDirEntries(this.myFSFS);
            for (String entryName : entries.keySet()) {
                String entryPath = SVNPathUtil.append(this.myCurrentDirInfo.myFullPath, entryName);
                SVNNodeKind kind = this.myRoot.checkNodeKind(entryPath);
                FSRevisionNode entryNode = this.myRoot.getRevisionNode(entryPath);
                if (kind == SVNNodeKind.DIR) {
                    entryNode.getDirEntries(this.myFSFS);
                    continue;
                }
                if (kind == SVNNodeKind.FILE) {
                    entryNode.getFileLength();
                    continue;
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Unexpected node kind {0} for ''{1}''", kind, entryPath);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
        for (String path : this.myCurrentDirInfo.myDeletedEntries.keySet()) {
            this.dumpNode(path, SVNNodeKind.UNKNOWN, 2, false, null, -1L);
        }
        this.myCurrentDirInfo = this.myCurrentDirInfo.myParentInfo;
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        this.myCurrentDirInfo.myDeletedEntries.put(path, path);
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        DirectoryInfo parent = this.myCurrentDirInfo;
        String cmpPath = null;
        long cmpRev = -1L;
        if (parent != null && parent.myComparePath != null && SVNRevision.isValidRevisionNumber(parent.myCompareRevision)) {
            cmpPath = SVNPathUtil.append(parent.myComparePath, SVNPathUtil.tail(path));
            cmpRev = parent.myCompareRevision;
        }
        this.myCurrentDirInfo = this.createDirectoryInfo(path, cmpPath, cmpRev, parent);
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        String cmpPath = null;
        long cmpRev = -1L;
        if (this.myCurrentDirInfo != null && this.myCurrentDirInfo.myComparePath != null && SVNRevision.isValidRevisionNumber(this.myCurrentDirInfo.myCompareRevision)) {
            cmpPath = SVNPathUtil.append(this.myCurrentDirInfo.myComparePath, SVNPathUtil.tail(path));
            cmpRev = this.myCurrentDirInfo.myCompareRevision;
        }
        this.dumpNode(path, SVNNodeKind.FILE, 0, false, cmpPath, cmpRev);
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.myCurrentDirInfo = this.createDirectoryInfo(null, null, -1L, null);
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return null;
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpNode(String path, SVNNodeKind kind, int nodeAction, boolean isCopy, String cmpPath, long cmpRev) throws SVNException {
        File tmpFile = null;
        try {
            this.writeDumpData("Node-path: " + (path.startsWith("/") ? path.substring(1) : path) + "\n");
            if (kind == SVNNodeKind.FILE) {
                this.writeDumpData("Node-kind: file\n");
            } else if (kind == SVNNodeKind.DIR) {
                this.writeDumpData("Node-kind: dir\n");
            }
            if (cmpPath != null) {
                cmpPath = cmpPath.startsWith("/") ? cmpPath.substring(1) : cmpPath;
            }
            String comparePath = path;
            long compareRevision = this.myTargetRevision - 1L;
            if (cmpPath != null && SVNRevision.isValidRevisionNumber(cmpRev)) {
                comparePath = cmpPath;
                compareRevision = cmpRev;
            }
            comparePath = SVNPathUtil.canonicalizePath(comparePath);
            comparePath = SVNPathUtil.getAbsolutePath(comparePath);
            FSRevisionRoot compareRoot = null;
            boolean mustDumpProps = false;
            boolean mustDumpText = false;
            String canonicalPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.canonicalizePath(path));
            switch (nodeAction) {
                case 0: {
                    this.writeDumpData("Node-action: change\n");
                    compareRoot = this.myFSFS.createRevisionRoot(compareRevision);
                    mustDumpProps = FSRepositoryUtil.arePropertiesChanged(compareRoot, comparePath, this.myRoot, canonicalPath);
                    if (kind != SVNNodeKind.FILE) break;
                    mustDumpText = FSRepositoryUtil.areFileContentsChanged(compareRoot, comparePath, this.myRoot, canonicalPath);
                    break;
                }
                case 3: {
                    if (!isCopy) {
                        this.writeDumpData("Node-action: replace\n");
                        if (kind == SVNNodeKind.FILE) {
                            mustDumpText = true;
                        }
                        mustDumpProps = true;
                        break;
                    }
                    this.writeDumpData("Node-action: delete\n\n");
                    this.dumpNode(path, kind, 1, isCopy, comparePath, compareRevision);
                    mustDumpText = false;
                    mustDumpProps = false;
                    break;
                }
                case 2: {
                    this.writeDumpData("Node-action: delete\n");
                    mustDumpText = false;
                    mustDumpProps = false;
                    break;
                }
                case 1: {
                    this.writeDumpData("Node-action: add\n");
                    if (!isCopy) {
                        if (kind == SVNNodeKind.FILE) {
                            mustDumpText = true;
                        }
                        mustDumpProps = true;
                        break;
                    }
                    if (!this.myIsVerify && cmpRev < this.myOldestDumpedRevision) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "WARNING: Referencing data in revision " + cmpRev + ", which is older than the oldest\nWARNING: dumped revision (" + this.myOldestDumpedRevision + ").  Loading this dump into an empty repository\nWARNING: will fail.\n");
                    }
                    this.writeDumpData("Node-copyfrom-rev: " + cmpRev + "\n");
                    this.writeDumpData("Node-copyfrom-path: " + cmpPath + "\n");
                    compareRoot = this.myFSFS.createRevisionRoot(compareRevision);
                    mustDumpProps = FSRepositoryUtil.arePropertiesChanged(compareRoot, comparePath, this.myRoot, canonicalPath);
                    if (kind != SVNNodeKind.FILE) break;
                    mustDumpText = FSRepositoryUtil.areFileContentsChanged(compareRoot, comparePath, this.myRoot, canonicalPath);
                    FSRevisionNode revNode = compareRoot.getRevisionNode(comparePath);
                    String checkSum = revNode.getFileMD5Checksum();
                    if (checkSum != null && checkSum.length() > 0) {
                        this.writeDumpData("Text-copy-source-md5: " + checkSum + "\n");
                    }
                    if ((checkSum = revNode.getFileSHA1Checksum()) == null || checkSum.length() <= 0) break;
                    this.writeDumpData("Text-copy-source-sha1: " + checkSum + "\n");
                }
            }
            if (!mustDumpProps && !mustDumpText) {
                this.writeDumpData("\n\n");
                return;
            }
            long contentLength = 0L;
            String propContents = null;
            if (mustDumpProps) {
                FSRevisionNode node = this.myRoot.getRevisionNode(canonicalPath);
                SVNProperties props = node.getProperties(this.myFSFS);
                SVNProperties oldProps = null;
                if (this.myUseDeltas && compareRoot != null) {
                    FSRevisionNode cmpNode = compareRoot.getRevisionNode(comparePath);
                    oldProps = cmpNode.getProperties(this.myFSFS);
                    this.writeDumpData("Prop-delta: true\n");
                }
                ByteArrayOutputStream encodedProps = new ByteArrayOutputStream();
                SVNAdminHelper.writeProperties(props, oldProps, encodedProps);
                propContents = new String(encodedProps.toByteArray(), "UTF-8");
                contentLength += (long)propContents.length();
                this.writeDumpData("Prop-content-length: " + propContents.length() + "\n");
            }
            if (mustDumpText && kind == SVNNodeKind.FILE) {
                long txtLength = 0L;
                FSRevisionNode node = this.myRoot.getRevisionNode(canonicalPath);
                if (this.myUseDeltas) {
                    OutputStream tmpStream;
                    InputStream targetStream;
                    InputStream sourceStream;
                    block41: {
                        tmpFile = SVNFileUtil.createTempFile("dump", ".tmp");
                        sourceStream = null;
                        targetStream = null;
                        tmpStream = null;
                        SVNDeltaCombiner deltaCombiner = this.getDeltaCombiner();
                        SVNDeltaGenerator deltaGenerator = this.getDeltaGenerator();
                        try {
                            sourceStream = compareRoot != null && comparePath != null ? compareRoot.getFileStreamForPath(deltaCombiner, comparePath) : SVNFileUtil.DUMMY_IN;
                            targetStream = this.myRoot.getFileStreamForPath(deltaCombiner, canonicalPath);
                            tmpStream = SVNFileUtil.openFileForWriting(tmpFile);
                            final CountingOutputStream countingStream = new CountingOutputStream(tmpStream, 0L);
                            ISVNDeltaConsumer consumer = new ISVNDeltaConsumer(){
                                private boolean isHeaderWritten = false;

                                @Override
                                public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
                                    try {
                                        if (diffWindow != null) {
                                            diffWindow.writeTo(countingStream, !this.isHeaderWritten);
                                        } else {
                                            SVNDiffWindow.EMPTY.writeTo(countingStream, !this.isHeaderWritten);
                                        }
                                    }
                                    catch (IOException ioe) {
                                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                                        SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
                                    }
                                    this.isHeaderWritten = true;
                                    return SVNFileUtil.DUMMY_OUT;
                                }

                                @Override
                                public void applyTextDelta(String path, String baseChecksum) throws SVNException {
                                }

                                @Override
                                public void textDeltaEnd(String path) throws SVNException {
                                }
                            };
                            deltaGenerator.sendDelta(null, sourceStream, 0L, targetStream, consumer, false);
                            txtLength = countingStream.getPosition();
                            if (compareRoot == null) break block41;
                            FSRevisionNode revNode = compareRoot.getRevisionNode(comparePath);
                            String hexDigest = revNode.getFileMD5Checksum();
                            if (hexDigest != null && hexDigest.length() > 0) {
                                this.writeDumpData("Text-delta-base-md5: " + hexDigest + "\n");
                            }
                            if ((hexDigest = revNode.getFileSHA1Checksum()) == null) {
                                hexDigest = this.computeSHA1Checksum(compareRoot, comparePath);
                            }
                            if (hexDigest != null && hexDigest.length() > 0) {
                                this.writeDumpData("Text-delta-base-sha1: " + hexDigest + "\n");
                            }
                        }
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile(sourceStream);
                            SVNFileUtil.closeFile(targetStream);
                            SVNFileUtil.closeFile(tmpStream);
                            throw throwable;
                        }
                    }
                    SVNFileUtil.closeFile(sourceStream);
                    SVNFileUtil.closeFile(targetStream);
                    SVNFileUtil.closeFile(tmpStream);
                    this.writeDumpData("Text-delta: true\n");
                } else {
                    txtLength = node.getFileLength();
                }
                contentLength += txtLength;
                this.writeDumpData("Text-content-length: " + txtLength + "\n");
                String checksum = node.getFileMD5Checksum();
                if (checksum != null && checksum.length() > 0) {
                    this.writeDumpData("Text-content-md5: " + checksum + "\n");
                }
                if ((checksum = node.getFileSHA1Checksum()) == null) {
                    checksum = this.computeSHA1Checksum(this.myRoot, canonicalPath);
                }
                if (checksum != null && checksum.length() > 0) {
                    this.writeDumpData("Text-content-sha1: " + checksum + "\n");
                }
            }
            this.writeDumpData("Content-length: " + contentLength + "\n\n");
            if (mustDumpProps) {
                this.writeDumpData(propContents);
            }
            if (mustDumpText && kind == SVNNodeKind.FILE) {
                InputStream source = null;
                try {
                    source = tmpFile != null ? SVNFileUtil.openFileForReading(tmpFile, SVNLogType.WC) : this.myRoot.getFileStreamForPath(this.getDeltaCombiner(), canonicalPath);
                    FSRepositoryUtil.copy(source, this.myDumpStream, null);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(source);
                    throw throwable;
                }
                SVNFileUtil.closeFile(source);
            }
            this.writeDumpData("\n\n");
            SVNFileUtil.deleteFile(tmpFile);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.deleteFile(tmpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeSHA1Checksum(FSRoot revision, String filePath) throws SVNException {
        InputStream is = revision.getFileStreamForPath(this.getDeltaCombiner(), filePath);
        SVNChecksumInputStream checksum = null;
        try {
            checksum = new SVNChecksumInputStream(is, "SHA1");
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(checksum);
            throw throwable;
        }
        SVNFileUtil.closeFile(checksum);
        return checksum != null ? checksum.getDigest() : null;
    }

    private SVNDeltaGenerator getDeltaGenerator() {
        if (this.myDeltaGenerator == null) {
            this.myDeltaGenerator = new SVNDeltaGenerator();
        }
        return this.myDeltaGenerator;
    }

    private SVNDeltaCombiner getDeltaCombiner() {
        if (this.myDeltaCombiner == null) {
            this.myDeltaCombiner = new SVNDeltaCombiner();
        } else {
            this.myDeltaCombiner.reset();
        }
        return this.myDeltaCombiner;
    }

    private DirectoryInfo createDirectoryInfo(String path, String copyFromPath, long copyFromRev, DirectoryInfo parent) {
        String fullPath = null;
        fullPath = parent != null ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myRootPath, path)) : this.myRootPath;
        String cmpPath = null;
        if (copyFromPath != null) {
            cmpPath = copyFromPath.startsWith("/") ? copyFromPath.substring(1) : copyFromPath;
        }
        return new DirectoryInfo(fullPath, cmpPath, copyFromRev, parent);
    }

    private void writeDumpData(String data) throws IOException {
        this.myDumpStream.write(data.getBytes("UTF-8"));
    }

    private class DirectoryInfo {
        String myFullPath;
        String myComparePath;
        long myCompareRevision;
        boolean myIsWrittenOut;
        Map myDeletedEntries;
        DirectoryInfo myParentInfo;

        public DirectoryInfo(String path, String cmpPath, long cmpRev, DirectoryInfo parent) {
            this.myFullPath = path;
            this.myParentInfo = parent;
            this.myComparePath = cmpPath;
            this.myCompareRevision = cmpRev;
            this.myDeletedEntries = new SVNHashMap();
            this.myIsWrittenOut = false;
        }
    }
}

