/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient.filters;

import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.filters.IFilterTerm;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.apiclient.interfaces.IValueProvider;
import com.versionone.apiclient.services.ValueProvider;

public class FilterTerm
implements IFilterTerm {
    private IAttributeDefinition def;
    private Operator operator = Operator.None;
    private IValueProvider valueProvider = new ValueProvider(new Object[0]);

    public FilterTerm(IAttributeDefinition def) {
        this.def = def;
    }

    @Override
    public String getShortToken() throws APIException {
        return this.makeToken(false);
    }

    @Override
    public String getToken() throws APIException {
        return this.makeToken(true);
    }

    private String makeToken(boolean full) throws APIException {
        if (this.operator == Operator.Exists) {
            if (!this.valueProvider.getValues().isEmpty()) {
                throw new APIException("Exists operator may not take values");
            }
            return "%2B" + this.def.getToken();
        }
        if (this.operator == Operator.NotExists) {
            if (!this.valueProvider.getValues().isEmpty()) {
                throw new APIException("NotExists operator may not take values");
            }
            return "-" + this.def.getToken();
        }
        if (this.valueProvider.getValues().isEmpty()) {
            return null;
        }
        String prefix = full ? this.def.getToken() : this.def.getName();
        return prefix + FilterTerm.operatorToken(this.operator) + this.valueProvider.stringize();
    }

    public void equal(Object ... value) {
        this.operate(Operator.Equal, value);
    }

    public void notEqual(Object ... value) {
        this.operate(Operator.NotEqual, value);
    }

    public void greater(Object ... value) {
        this.operate(Operator.GreaterThan, value);
    }

    public void less(Object ... value) {
        this.operate(Operator.LessThan, value);
    }

    public void lessOrEqual(Object ... value) {
        this.operate(Operator.LessThanOrEqual, value);
    }

    public void greaterOrEqual(Object ... value) {
        this.operate(Operator.GreaterThanOrEqual, value);
    }

    public void exists() {
        this.operate(Operator.Exists, new Object[0]);
    }

    public void notExists() {
        this.operate(Operator.NotExists, new Object[0]);
    }

    public void operate(Operator newop, IValueProvider provider) {
        IAttributeDefinition.AttributeType deftype;
        if ((newop == Operator.GreaterThan || newop == Operator.GreaterThanOrEqual || newop == Operator.LessThan || newop == Operator.LessThanOrEqual) && (deftype = this.def.getAttributeType()) != IAttributeDefinition.AttributeType.Date && deftype != IAttributeDefinition.AttributeType.Numeric && deftype != IAttributeDefinition.AttributeType.Opaque) {
            throw new RuntimeException("Inequality Operation Not Valid For " + deftype.toString() + " AttributeType.");
        }
        if (newop != this.operator) {
            this.operator = newop;
            this.valueProvider = provider != null ? provider : new ValueProvider(new Object[0]);
            return;
        }
        if (provider != null && this.valueProvider.canMerge().booleanValue() && provider.canMerge().booleanValue()) {
            this.valueProvider.merge(provider);
        }
    }

    public void operate(Operator newop, Object ... value) {
        this.operate(newop, new ValueProvider(value));
    }

    private static String operatorToken(Operator op) {
        switch (op) {
            case Equal: {
                return "=";
            }
            case NotEqual: {
                return "!=";
            }
            case GreaterThan: {
                return ">";
            }
            case GreaterThanOrEqual: {
                return ">=";
            }
            case LessThan: {
                return "<";
            }
            case LessThanOrEqual: {
                return "<=";
            }
        }
        return null;
    }

    public static enum Operator {
        None,
        Equal,
        NotEqual,
        GreaterThan,
        LessThan,
        GreaterThanOrEqual,
        LessThanOrEqual,
        Exists,
        NotExists;

    }
}

