#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import java

def convert_to_datetime(from_date):
    # https://docs.python.org/2/library/datetime.html#strftime-strptime-behavior
    # return datetime.strptime(from_date, '%Y-%m-%dT%H:%M:%S%Z')
    sdf = java.text.SimpleDateFormat("EEE MMM dd kk:mm:ss zzz yyyy")
    return sdf.parse(from_date)

def add_plan_record(task_reporting_api, task, versionOneServer, ticket=None, title=None,
                    ticketType=None, ticketUrl=None, status=None, updatedDate=None, updatedBy=None):
    try:
        record = task_reporting_api.newPlanRecord()
        record.targetId = task.id
        record.serverUrl = versionOneServer['url']
        record.ticket = ticket
        record.title = title
        record.ticketType = ticketType
        record.ticket_url = ticketUrl
        record.status = status
        record.updatedDate = updatedDate
        record.updatedBy = updatedBy

        task_reporting_api.addRecord(record, True)
    except:
        exctype, value = sys.exc_info()[:2]
        print("{} occurred while creating `udm.PlanRecord` - {}".format(exctype, value))
