/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import wiremock.com.google.common.base.Charsets;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ResponseDefinition {
    private int status;
    private byte[] body;
    private boolean isBinaryBody = false;
    private String bodyFileName;
    private HttpHeaders headers;
    private HttpHeaders additionalProxyRequestHeaders;
    private Integer fixedDelayMilliseconds;
    private String proxyBaseUrl;
    private String browserProxyUrl;
    private Fault fault;
    private boolean wasConfigured = true;
    private Request originalRequest;
    private List<String> transformers;

    public static ResponseDefinition copyOf(ResponseDefinition original) {
        ResponseDefinition newResponseDef = new ResponseDefinition();
        newResponseDef.status = original.status;
        newResponseDef.body = original.body;
        newResponseDef.isBinaryBody = original.isBinaryBody;
        newResponseDef.bodyFileName = original.bodyFileName;
        newResponseDef.headers = original.headers;
        newResponseDef.additionalProxyRequestHeaders = original.additionalProxyRequestHeaders;
        newResponseDef.fixedDelayMilliseconds = original.fixedDelayMilliseconds;
        newResponseDef.proxyBaseUrl = original.proxyBaseUrl;
        newResponseDef.fault = original.fault;
        newResponseDef.wasConfigured = original.wasConfigured;
        newResponseDef.transformers = original.transformers;
        return newResponseDef;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public HttpHeaders getAdditionalProxyRequestHeaders() {
        return this.additionalProxyRequestHeaders;
    }

    public void setAdditionalProxyRequestHeaders(HttpHeaders additionalProxyRequestHeaders) {
        this.additionalProxyRequestHeaders = additionalProxyRequestHeaders;
    }

    public ResponseDefinition(int statusCode, String bodyContent) {
        this.status = statusCode;
        this.body = bodyContent == null ? null : bodyContent.getBytes(Charset.forName(Charsets.UTF_8.name()));
    }

    public ResponseDefinition(int statusCode, byte[] bodyContent) {
        this.status = statusCode;
        this.body = bodyContent;
        this.isBinaryBody = true;
    }

    public ResponseDefinition() {
        this.status = 200;
    }

    public static ResponseDefinition notFound() {
        return new ResponseDefinition(404, (byte[])null);
    }

    public static ResponseDefinition ok() {
        return new ResponseDefinition(200, (byte[])null);
    }

    public static ResponseDefinition created() {
        return new ResponseDefinition(201, (byte[])null);
    }

    public static ResponseDefinition redirectTo(String path) {
        return new ResponseDefinitionBuilder().withHeader("Location", path).withStatus(302).build();
    }

    public static ResponseDefinition notConfigured() {
        ResponseDefinition response = new ResponseDefinition(404, (byte[])null);
        response.wasConfigured = false;
        return response;
    }

    public static ResponseDefinition browserProxy(Request originalRequest) {
        ResponseDefinition response = new ResponseDefinition();
        response.browserProxyUrl = originalRequest.getAbsoluteUrl();
        return response;
    }

    public int getStatus() {
        return this.status;
    }

    public String getBody() {
        return !this.isBinaryBody && this.body != null ? new String(this.body, Charset.forName(Charsets.UTF_8.name())) : null;
    }

    @JsonIgnore
    public byte[] getByteBody() {
        return this.body;
    }

    public String getBase64Body() {
        if (this.isBinaryBody && this.body != null) {
            return DatatypeConverter.printBase64Binary((byte[])this.body);
        }
        return null;
    }

    public void setBase64Body(String base64Body) {
        this.isBinaryBody = true;
        this.body = DatatypeConverter.parseBase64Binary((String)base64Body);
    }

    public void setJsonBody(JsonNode jsonBody) {
        this.isBinaryBody = false;
        this.body = Json.toByteArray(jsonBody);
    }

    @JsonProperty
    public void setBody(String body) {
        this.body = body != null ? body.getBytes(Charset.forName(Charsets.UTF_8.name())) : null;
        this.isBinaryBody = false;
    }

    @JsonIgnore
    public void setBody(byte[] body) {
        this.body = body;
        this.isBinaryBody = true;
    }

    public void setStatus(int status) {
        this.status = status == 0 ? 200 : status;
    }

    public void setFixedDelayMilliseconds(Integer fixedDelayMilliseconds) {
        this.fixedDelayMilliseconds = fixedDelayMilliseconds;
    }

    public String getBodyFileName() {
        return this.bodyFileName;
    }

    public void setBodyFileName(String bodyFileName) {
        this.bodyFileName = bodyFileName;
    }

    public boolean wasConfigured() {
        return this.wasConfigured;
    }

    public Integer getFixedDelayMilliseconds() {
        return this.fixedDelayMilliseconds;
    }

    @JsonIgnore
    public String getProxyUrl() {
        if (this.browserProxyUrl != null) {
            return this.browserProxyUrl;
        }
        return this.proxyBaseUrl + this.originalRequest.getUrl();
    }

    public String getProxyBaseUrl() {
        return this.proxyBaseUrl;
    }

    public void setProxyBaseUrl(String proxyBaseUrl) {
        this.proxyBaseUrl = proxyBaseUrl;
    }

    @JsonIgnore
    public boolean specifiesBodyFile() {
        return this.bodyFileName != null && this.body == null;
    }

    @JsonIgnore
    public boolean specifiesBodyContent() {
        return this.body != null;
    }

    @JsonIgnore
    public boolean specifiesBinaryBodyContent() {
        return this.body != null && this.isBinaryBody;
    }

    @JsonIgnore
    public boolean isProxyResponse() {
        return this.browserProxyUrl != null || this.proxyBaseUrl != null;
    }

    public Request getOriginalRequest() {
        return this.originalRequest;
    }

    public void setOriginalRequest(Request originalRequest) {
        this.originalRequest = originalRequest;
    }

    public Fault getFault() {
        return this.fault;
    }

    public void setFault(Fault fault) {
        this.fault = fault;
    }

    public List<String> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<String> transformers) {
        this.transformers = transformers;
    }

    public boolean hasTransformer(ResponseTransformer transformer) {
        return this.transformers != null && this.transformers.contains(transformer.name());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseDefinition that = (ResponseDefinition)o;
        if (this.isBinaryBody != that.isBinaryBody) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.wasConfigured != that.wasConfigured) {
            return false;
        }
        if (this.additionalProxyRequestHeaders != null ? !this.additionalProxyRequestHeaders.equals(that.additionalProxyRequestHeaders) : that.additionalProxyRequestHeaders != null) {
            return false;
        }
        if (!Arrays.equals(this.body, that.body)) {
            return false;
        }
        if (this.bodyFileName != null ? !this.bodyFileName.equals(that.bodyFileName) : that.bodyFileName != null) {
            return false;
        }
        if (this.browserProxyUrl != null ? !this.browserProxyUrl.equals(that.browserProxyUrl) : that.browserProxyUrl != null) {
            return false;
        }
        if (this.fault != that.fault) {
            return false;
        }
        if (this.fixedDelayMilliseconds != null ? !this.fixedDelayMilliseconds.equals(that.fixedDelayMilliseconds) : that.fixedDelayMilliseconds != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.originalRequest != null ? !this.originalRequest.equals(that.originalRequest) : that.originalRequest != null) {
            return false;
        }
        if (this.proxyBaseUrl != null ? !this.proxyBaseUrl.equals(that.proxyBaseUrl) : that.proxyBaseUrl != null) {
            return false;
        }
        return !(this.transformers != null ? !this.transformers.equals(that.transformers) : that.transformers != null);
    }

    public int hashCode() {
        int result = this.status;
        result = 31 * result + (this.body != null ? Arrays.hashCode(this.body) : 0);
        result = 31 * result + (this.isBinaryBody ? 1 : 0);
        result = 31 * result + (this.bodyFileName != null ? this.bodyFileName.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.additionalProxyRequestHeaders != null ? this.additionalProxyRequestHeaders.hashCode() : 0);
        result = 31 * result + (this.fixedDelayMilliseconds != null ? this.fixedDelayMilliseconds.hashCode() : 0);
        result = 31 * result + (this.proxyBaseUrl != null ? this.proxyBaseUrl.hashCode() : 0);
        result = 31 * result + (this.browserProxyUrl != null ? this.browserProxyUrl.hashCode() : 0);
        result = 31 * result + (this.fault != null ? this.fault.hashCode() : 0);
        result = 31 * result + (this.wasConfigured ? 1 : 0);
        result = 31 * result + (this.originalRequest != null ? this.originalRequest.hashCode() : 0);
        result = 31 * result + (this.transformers != null ? this.transformers.hashCode() : 0);
        return result;
    }

    private static boolean byteBodyEquals(byte[] expecteds, byte[] actuals) {
        if (expecteds == actuals) {
            return true;
        }
        if (expecteds == null) {
            return false;
        }
        if (actuals == null) {
            return false;
        }
        int actualsLength = actuals.length;
        int expectedsLength = expecteds.length;
        if (actualsLength != expectedsLength) {
            return false;
        }
        for (int i = 0; i < expectedsLength; ++i) {
            byte expected = expecteds[i];
            byte actual = actuals[i];
            if (expected == actual) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Json.write(this);
    }
}

