/*
 * Decompiled with CFR 0.152.
 */
package com.versionone;

import com.versionone.DB;
import com.versionone.apiclient.exceptions.OidException;
import com.versionone.apiclient.interfaces.IAssetType;
import com.versionone.apiclient.interfaces.IMetaModel;
import com.versionone.utils.HashCode;

public class Oid {
    protected static final String NullOidToken = "NULL";
    public static final Oid Null = new Oid();
    private IAssetType _type;
    private int _id;
    private Integer _moment;
    private static final String SEPARATOR = ":";

    private Oid() {
    }

    public Oid(IAssetType assetType, DB.Int id, DB.Int moment) {
        if (assetType == null) {
            throw new IllegalArgumentException("assetType");
        }
        if (id.isNull()) {
            throw new IllegalArgumentException("id cannot be DB.Null");
        }
        if (moment == null) {
            moment = new DB.Int(DB.Null);
        }
        this._type = assetType;
        this._id = id.getValue();
        this._moment = moment.getValue();
    }

    public Oid(IAssetType assetType, int id, DB.Int moment) {
        this(assetType, new DB.Int(id), moment);
    }

    public Oid(IAssetType assetType, int id, int moment) {
        this(assetType, id);
        this._moment = moment;
    }

    public Oid(IAssetType assetType, int id) {
        if (assetType == null) {
            throw new IllegalArgumentException("assetType");
        }
        this._type = assetType;
        this._id = id;
    }

    public Oid(IAssetType assetType) {
        this(assetType, new DB.Int(0), new DB.Int(DB.Null));
    }

    public IAssetType getAssetType() {
        return this._type;
    }

    public Object getKey() {
        return this._id;
    }

    public Object getMoment() {
        return this._moment;
    }

    public boolean isNull() {
        return this.equals(Null);
    }

    private String BuildToken() {
        if (this._type == null) {
            return NullOidToken;
        }
        String typeToken = this._type.getToken();
        StringBuilder res = new StringBuilder();
        res.append(typeToken).append(SEPARATOR).append(this._id);
        if (this.hasMoment()) {
            res.append(SEPARATOR).append(this._moment);
        }
        return res.toString();
    }

    public String getToken() {
        if (this.isNull()) {
            return NullOidToken;
        }
        return this.BuildToken();
    }

    public String toString() {
        return this.getToken();
    }

    public static Oid fromToken(String oidtoken, IMetaModel meta) throws OidException {
        try {
            if (oidtoken.equals(NullOidToken)) {
                return Null;
            }
            String[] parts = oidtoken.split(SEPARATOR);
            IAssetType type = meta.getAssetType(parts[0]);
            int id = Integer.parseInt(parts[1]);
            if (parts.length > 2) {
                int moment = Integer.parseInt(parts[2]);
                return new Oid(type, id, moment);
            }
            return new Oid(type, id);
        }
        catch (Exception e) {
            throw new OidException("Invalid OID token", oidtoken, e);
        }
    }

    public Oid getMomentless() {
        return this.hasMoment() ? new Oid(this._type, this._id) : this;
    }

    public boolean hasMoment() {
        return this._moment != null;
    }

    public boolean equals(Object obj) {
        Oid other;
        if (!(obj instanceof Oid)) {
            return false;
        }
        if (null == this._type ^ null == (other = (Oid)obj).getAssetType()) {
            return false;
        }
        if (null == this._type && null == other.getAssetType()) {
            return true;
        }
        if (!this._type.getToken().equals(other._type.getToken())) {
            return false;
        }
        if (this._id != other._id) {
            return false;
        }
        if (this.hasMoment() ^ other.hasMoment()) {
            return false;
        }
        if (null == this.getMoment() && null == other.getMoment()) {
            return true;
        }
        return this.getMoment().equals(other.getMoment());
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        if (this._moment == null) {
            return HashCode.Hash(this._type.getToken().hashCode(), this._id);
        }
        return HashCode.Hash(this._type.getToken().hashCode(), this._id, this._moment.hashCode());
    }

    public static boolean compare(Oid lhs, Oid rhs) {
        if (lhs == null || rhs == null) {
            return lhs == rhs;
        }
        return lhs.equals(rhs);
    }
}

