/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.DB;

public class Rank
extends Number
implements Comparable<Rank> {
    private final int _rankNumber;
    private final int _offset;

    private Rank(int rankNumber, int offset) {
        this._rankNumber = rankNumber;
        this._offset = offset;
    }

    public Rank(Object o) {
        if (o instanceof Rank) {
            Rank other = (Rank)o;
            this._rankNumber = other._rankNumber;
            this._offset = other._offset;
        } else if (o == DB.Null || o == null) {
            this._rankNumber = Integer.MAX_VALUE;
            this._offset = 0;
        } else if (o instanceof String) {
            String s = (String)o;
            if (s.endsWith("+")) {
                this._rankNumber = Integer.parseInt(s.substring(0, s.length() - 1));
                this._offset = 1;
            } else if (s.endsWith("-")) {
                this._rankNumber = Integer.parseInt(s.substring(0, s.length() - 1));
                this._offset = -1;
            } else {
                this._rankNumber = Integer.parseInt(s);
                this._offset = 0;
            }
        } else if (o instanceof Number) {
            this._rankNumber = ((Number)o).intValue();
            this._offset = 0;
        } else {
            this._rankNumber = 0;
            this._offset = 0;
        }
    }

    public Rank before() {
        return new Rank(this._rankNumber, this._offset - 1);
    }

    public Rank after() {
        return new Rank(this._rankNumber, this._offset + 1);
    }

    public boolean isBefore() {
        return this._offset < 0;
    }

    public boolean isAfter() {
        return this._offset > 0;
    }

    public String toString() {
        return this._rankNumber + (this.isAfter() ? "+" : (this.isBefore() ? "-" : ""));
    }

    @Override
    public int intValue() {
        return this._rankNumber;
    }

    @Override
    public long longValue() {
        return this._rankNumber;
    }

    @Override
    public float floatValue() {
        return this._rankNumber;
    }

    @Override
    public double doubleValue() {
        return this._rankNumber;
    }

    public boolean equals(Object obj) throws IllegalArgumentException {
        try {
            return obj instanceof Rank && this.compareTo((Rank)obj) == 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public int hashCode() {
        return this._rankNumber;
    }

    @Override
    public int compareTo(Rank other) throws IllegalArgumentException {
        assert (other != null);
        if (this.isAfter() || this.isBefore() || other.isBefore() || other.isAfter()) {
            throw new IllegalArgumentException("Transient ranks are not comparable");
        }
        return this._rankNumber - other._rankNumber;
    }
}

