/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.DB;
import com.versionone.Oid;
import com.versionone.apiclient.Asset;
import com.versionone.apiclient.Attribute;
import com.versionone.apiclient.XMLHandler;
import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.interfaces.IAssetType;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.utils.V1Util;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlApiWriter {
    private static final String ELEMENT_NAME_ASSET = "Asset";
    private static final String ELEMENT_NAME_ATTRIBUTE = "Attribute";
    private static final String ELEMENT_NAME_RELATION = "Relation";
    private static final String ELEMENT_NAME_VALUE = "Value";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_ACTION = "act";
    private static final String ATTRIBUTE_NAME_IDREF = "idref";
    private static final String ATTRIBUTE_NAME_NAME = "name";
    private static final String ACTION_NAME_ADD = "add";
    private static final String ACTION_NAME_REMOVE = "remove";
    private static final String ACTION_NAME_SET = "set";
    private Document doc = null;
    private boolean _changesOnly = false;

    public XmlApiWriter(boolean changesOnly) {
        this._changesOnly = changesOnly;
    }

    public void write(Asset asset, Writer destination) throws APIException {
        this.buildDocument(asset);
        DOMSource xmlSource = new DOMSource(this.doc);
        StreamResult outputTarget = new StreamResult(destination);
        try {
            Transformer xform = TransformerFactory.newInstance().newTransformer();
            xform.transform(xmlSource, outputTarget);
        }
        catch (TransformerException e) {
            throw new APIException("Error creating XML", e);
        }
    }

    private void buildDocument(Asset asset) throws APIException {
        DocumentBuilder builder;
        try {
            builder = XMLHandler.createDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new APIException("Parser Configuration Error ", e);
        }
        this.doc = builder.newDocument();
        Element root = this.doc.createElement(ELEMENT_NAME_ASSET);
        if (!asset.getOid().isNull()) {
            root.setAttribute(ATTRIBUTE_NAME_ID, asset.getOid().getToken());
        }
        Collection<Attribute> attributes = asset.getAttributes().values();
        Iterator<Attribute> iter = attributes.iterator();
        while (iter.hasNext()) {
            this.addAttribute(iter.next(), root);
        }
        this.doc.appendChild(root);
    }

    private void addAttribute(Attribute attribute, Element parent) throws APIException {
        if (this._changesOnly && !attribute.hasChanged()) {
            return;
        }
        Element element = this.createAttributeElement(attribute.getDefinition().getAttributeType());
        element.setAttribute(ATTRIBUTE_NAME_NAME, attribute.getDefinition().getName());
        if (IAttributeDefinition.AttributeType.Relation == attribute.getDefinition().getAttributeType()) {
            this.populateRelationElement(element, attribute);
        } else if (attribute.getDefinition().isMultiValue()) {
            this.populateMultiValueAttributeElement(element, attribute);
        } else {
            this.populateAttributeElement(element, attribute);
        }
        parent.appendChild(element);
    }

    private Element createAttributeElement(IAttributeDefinition.AttributeType attributeType) {
        String tagName = IAttributeDefinition.AttributeType.Relation == attributeType ? ELEMENT_NAME_RELATION : ELEMENT_NAME_ATTRIBUTE;
        return this.doc.createElement(tagName);
    }

    private void populateRelationElement(Element element, Attribute attribute) {
        if (attribute.hasChanged() && attribute.getDefinition().isMultiValue()) {
            this.writeAttributeValues(attribute.getAddedValues(), ACTION_NAME_ADD, element);
            this.writeAttributeValues(attribute.getRemovedValues(), ACTION_NAME_REMOVE, element);
        } else {
            if (attribute.hasChanged()) {
                element.setAttribute(ATTRIBUTE_NAME_ACTION, ACTION_NAME_SET);
            }
            this.writeAttributeValues(attribute.getValues(), null, element);
        }
    }

    private void populateMultiValueAttributeElement(Element element, Attribute attribute) {
        if (!attribute.hasChanged() || !attribute.getDefinition().isMultiValue()) {
            return;
        }
        this.writeMultiValueAttributeValues(attribute.getAddedValues(), ACTION_NAME_ADD, element);
        this.writeMultiValueAttributeValues(attribute.getRemovedValues(), ACTION_NAME_REMOVE, element);
    }

    private void populateAttributeElement(Element element, Attribute attribute) throws APIException {
        try {
            if (attribute.getDefinition().isMultiValue()) {
                this.valuesToXml(attribute.getDefinition(), attribute.getValues(), ELEMENT_NAME_VALUE, element);
            } else {
                if (attribute.hasChanged()) {
                    element.setAttribute(ATTRIBUTE_NAME_ACTION, ACTION_NAME_SET);
                }
                element.setTextContent(this.valueToXmlString(attribute.getDefinition().getAttributeType(), attribute.getValue()));
            }
        }
        catch (Exception e) {
            throw new APIException("Error populating Attribute element", e);
        }
    }

    private void valuesToXml(IAttributeDefinition attribdef, Object[] values, String elementName, Element parent) throws Exception {
        if (values != null) {
            for (Object val : values) {
                this.valueToXml(attribdef, val, elementName, parent);
            }
        }
    }

    private void valueToXml(IAttributeDefinition attribdef, Object val, String elementName, Element parent) throws APIException {
        Element element = this.doc.createElement(elementName);
        element.setTextContent(this.valueToXmlString(attribdef.getAttributeType(), val));
        parent.appendChild(element);
    }

    private void writeAttributeValues(Object[] list, String action, Element parent) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            Oid oid = (Oid)list[i];
            if (oid.isNull()) continue;
            Element element = this.doc.createElement(ELEMENT_NAME_ASSET);
            element.setAttribute(ATTRIBUTE_NAME_IDREF, oid.getToken());
            if (action != null) {
                element.setAttribute(ATTRIBUTE_NAME_ACTION, action);
            }
            parent.appendChild(element);
        }
    }

    private void writeMultiValueAttributeValues(Object[] list, String action, Element parent) {
        if (list == null) {
            return;
        }
        for (Object obj : list) {
            String value = (String)obj;
            if (V1Util.isNullOrEmpty(value)) continue;
            Element element = this.doc.createElement(ELEMENT_NAME_VALUE);
            element.setAttribute(ATTRIBUTE_NAME_ACTION, action);
            element.setTextContent(V1Util.convertSystemCrToXmlCr(value));
            parent.appendChild(element);
        }
    }

    private String valueToXmlString(IAttributeDefinition.AttributeType type, Object value) throws APIException {
        if (value == null) {
            return "";
        }
        switch (type) {
            case Boolean: 
            case LongText: 
            case Text: 
            case LocalizerTag: 
            case Duration: 
            case Rank: 
            case Opaque: 
            case State: 
            case Password: 
            case LongInt: {
                return V1Util.convertSystemCrToXmlCr(value.toString());
            }
            case Numeric: {
                NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
                return nf.format(value);
            }
            case Date: {
                Date datetimevalue = (Date)value;
                SimpleDateFormat formatter = this.getSecondOfDay(datetimevalue) == 0 ? DB.DateTime.DAY_FORMAT : DB.DateTime.DAY_N_TIME_FORMAT;
                return formatter.format(value);
            }
            case Relation: {
                if (((Oid)value).isNull()) {
                    return "";
                }
                return ((Oid)value).getToken();
            }
            case AssetType: {
                return ((IAssetType)value).getToken();
            }
            case Blob: {
                return "";
            }
        }
        throw new APIException("Unsupported AttributeType ", type.toString());
    }

    private int getSecondOfDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        return (hour * 60 + min) * 60 + sec;
    }
}

