/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.gpg.AbstractGpgMojo;
import org.apache.maven.plugin.gpg.AbstractGpgSigner;
import org.apache.maven.plugin.gpg.AscArtifactMetadata;
import org.apache.maven.plugin.gpg.AttachedSignedArtifact;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="sign-and-deploy-file", requiresProject=false, threadSafe=true)
public class SignAndDeployFileMojo
extends AbstractGpgMojo {
    @Parameter(property="gpg.ascDirectory")
    private File ascDirectory;
    @Parameter(defaultValue="${settings.offline}", readonly=true)
    private boolean offline;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="generatePom.description")
    private String description;
    @Parameter(property="file", required=true)
    private File file;
    @Parameter(property="pomFile")
    private File pomFile;
    @Parameter(property="generatePom", defaultValue="true")
    private boolean generatePom;
    @Parameter(property="uniqueVersion", defaultValue="true")
    private boolean uniqueVersion;
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="repositoryId", defaultValue="remote-repository", required=true)
    private String repositoryId;
    @Parameter(property="repositoryLayout", defaultValue="default")
    private String repositoryLayout;
    @Component
    private ArtifactDeployer deployer;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map repositoryLayouts;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactRepositoryFactory repositoryFactory;
    @Component
    private ModelValidator modelValidator;
    @Component
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="javadoc")
    private File javadoc;
    @Parameter(property="sources")
    private File sources;
    @Parameter(property="retryFailedDeploymentCount", defaultValue="1")
    private int retryFailedDeploymentCount;
    @Parameter(property="updateReleaseInfo", defaultValue="false")
    protected boolean updateReleaseInfo;
    @Parameter(property="types")
    private String types;
    @Parameter(property="classifiers")
    private String classifiers;
    @Parameter(property="files")
    private String files;

    private void initProperties() throws MojoExecutionException {
        if (this.pomFile != null) {
            this.generatePom = false;
            Model model = this.readModel(this.pomFile);
            this.processModel(model);
        }
        if (this.packaging == null && this.file != null) {
            this.packaging = FileUtils.getExtension(this.file.getName());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        AbstractGpgSigner signer = this.newSigner(null);
        signer.setOutputDirectory(this.ascDirectory);
        signer.setBaseDirectory(new File("").getAbsoluteFile());
        if (this.offline) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
        this.initProperties();
        this.validateArtifactInformation();
        if (!this.file.exists()) {
            throw new MojoFailureException(this.file.getPath() + " not found.");
        }
        ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)this.repositoryLayouts.get(this.repositoryLayout);
        if (layout == null) {
            throw new MojoFailureException("Invalid repository layout: " + this.repositoryLayout);
        }
        ArtifactRepository deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository(this.repositoryId, this.url, layout, this.uniqueVersion);
        if (StringUtils.isEmpty(deploymentRepository.getProtocol())) {
            throw new MojoFailureException("No transfer protocol found.");
        }
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        if (this.file.equals(this.getLocalRepoFile(artifact))) {
            throw new MojoFailureException("Cannot deploy artifact from the local repository: " + this.file);
        }
        File fileSig = signer.generateSignatureForArtifact(this.file);
        AbstractArtifactMetadata metadata = new AscArtifactMetadata(artifact, fileSig, false);
        artifact.addMetadata(metadata);
        if (!"pom".equals(this.packaging)) {
            if (this.pomFile == null && this.generatePom) {
                this.pomFile = this.generatePomFile();
            }
            if (this.pomFile != null) {
                metadata = new ProjectArtifactMetadata(artifact, this.pomFile);
                artifact.addMetadata(metadata);
                fileSig = signer.generateSignatureForArtifact(this.pomFile);
                metadata = new AscArtifactMetadata(artifact, fileSig, true);
                artifact.addMetadata(metadata);
            }
        }
        if (this.updateReleaseInfo) {
            artifact.setRelease(true);
        }
        this.project.setArtifact(artifact);
        try {
            this.deploy(this.file, artifact, deploymentRepository, this.localRepository);
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.sources != null) {
            this.projectHelper.attachArtifact(this.project, "jar", "sources", this.sources);
        }
        if (this.javadoc != null) {
            this.projectHelper.attachArtifact(this.project, "jar", "javadoc", this.javadoc);
        }
        if (this.files != null) {
            if (this.types == null) {
                throw new MojoExecutionException("You must specify 'types' if you specify 'files'");
            }
            if (this.classifiers == null) {
                throw new MojoExecutionException("You must specify 'classifiers' if you specify 'files'");
            }
            int filesLength = StringUtils.countMatches(this.files, ",");
            int typesLength = StringUtils.countMatches(this.types, ",");
            int classifiersLength = StringUtils.countMatches(this.classifiers, ",");
            if (typesLength != filesLength) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'types' (respectively " + filesLength + " and " + typesLength + " entries )");
            }
            if (classifiersLength != filesLength) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'classifiers' (respectively " + filesLength + " and " + classifiersLength + " entries )");
            }
            int fi = 0;
            int ti = 0;
            int ci = 0;
            for (int i = 0; i <= filesLength; ++i) {
                File file;
                int nci;
                int nti;
                int nfi = this.files.indexOf(44, fi);
                if (nfi == -1) {
                    nfi = this.files.length();
                }
                if ((nti = this.types.indexOf(44, ti)) == -1) {
                    nti = this.types.length();
                }
                if ((nci = this.classifiers.indexOf(44, ci)) == -1) {
                    nci = this.classifiers.length();
                }
                if (!(file = new File(this.files.substring(fi, nfi))).isFile()) {
                    file = new File(this.project.getBasedir(), this.files.substring(fi, nfi));
                }
                if (file.isFile()) {
                    if (StringUtils.isWhitespace(this.classifiers.substring(ci, nci))) {
                        this.projectHelper.attachArtifact(this.project, this.types.substring(ti, nti).trim(), file);
                    } else {
                        this.projectHelper.attachArtifact(this.project, this.types.substring(ti, nti).trim(), this.classifiers.substring(ci, nci).trim(), file);
                    }
                } else {
                    throw new MojoExecutionException("Specified side artifact " + file + " does not exist");
                }
                fi = nfi + 1;
                ti = nti + 1;
                ci = nci + 1;
            }
        } else {
            if (this.types != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'types'");
            }
            if (this.classifiers != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'classifiers'");
            }
        }
        List attachedArtifacts = this.project.getAttachedArtifacts();
        for (Object attachedArtifact : attachedArtifacts) {
            Artifact attached = (Artifact)attachedArtifact;
            fileSig = signer.generateSignatureForArtifact(attached.getFile());
            attached = new AttachedSignedArtifact(attached, new AscArtifactMetadata(attached, fileSig, false));
            try {
                this.deploy(attached.getFile(), attached, deploymentRepository, this.localRepository);
            }
            catch (ArtifactDeploymentException e) {
                throw new MojoExecutionException("Error deploying attached artifact " + attached.getFile() + ": " + e.getMessage(), e);
            }
        }
    }

    private File getLocalRepoFile(Artifact artifact) {
        String path = this.localRepository.pathOf(artifact);
        return new File(this.localRepository.getBasedir(), path);
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    private Model readModel(File pomFile) throws MojoExecutionException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(pomFile);
            Model model = new MavenXpp3Reader().read(reader);
            return model;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("POM not found " + pomFile, e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading POM " + pomFile, e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing POM " + pomFile, e);
        }
        finally {
            IOUtil.close(reader);
        }
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        Model model = this.generateModel();
        XmlStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvndeploy", ".pom");
            tempFile.deleteOnExit();
            fw = WriterFactory.newXmlWriter(tempFile);
            new MavenXpp3Writer().write(fw, model);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close(fw);
        return file;
    }

    private void validateArtifactInformation() throws MojoFailureException {
        Model model = this.generateModel();
        ModelValidationResult result = this.modelValidator.validate(model);
        if (result.getMessageCount() > 0) {
            throw new MojoFailureException("The artifact information is incomplete or not valid:\n" + result.render("  "));
        }
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription(this.description);
        return model;
    }

    protected void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        int retryFailedDeploymentCount = Math.max(1, Math.min(10, this.retryFailedDeploymentCount));
        ArtifactDeploymentException exception = null;
        for (int count = 0; count < retryFailedDeploymentCount; ++count) {
            try {
                if (count > 0) {
                    this.getLog().info("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCount);
                }
                this.deployer.deploy(source, artifact, deploymentRepository, localRepository);
                for (Object o : artifact.getMetadataList()) {
                    ArtifactMetadata metadata = (ArtifactMetadata)o;
                    this.getLog().info("Metadata[" + metadata.getKey() + "].filename = " + metadata.getRemoteFilename());
                }
                exception = null;
                break;
            }
            catch (ArtifactDeploymentException e) {
                if (count + 1 < retryFailedDeploymentCount) {
                    this.getLog().warn("Encountered issue during deployment: " + e.getLocalizedMessage());
                    this.getLog().debug(e);
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

