#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import com.xhaus.jyson.JysonCodec as json
from xlrelease.HttpRequest import HttpRequest

STATUS_OK = 200


class VersionOneClient(object):

    def __init__(self, v1CI):
        self.Token = v1CI['accessToken']
        self.uriBase = v1CI['uriBase']
        self.httpConnection = v1CI
        self.httpRequest = HttpRequest(v1CI)
        self.optionHeader = {"Accept": "application/json",
                             "Authorization": "Bearer %s" % self.Token}

    # End def

    @staticmethod
    def create_v1Client(v1CI):
        return VersionOneClient(v1CI)

    # End def

    def getAssetByName(self, assetType, assetName):
        uri = "%s/rest-1.v1/Data/%s?find='%s'&findin=Name" % (self.uriBase, assetType, assetname)
        
        # End if
        print("getAssetByName uri = %s" % uri)
        print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting stories', reqStatus)

    # End def

    def getStories(self, whereClause=None):
        uri = "%s/rest-1.v1/Data/Story" % self.uriBase
        if whereClause is not None:
            uri = "%s?where=%s" % (uri, whereClause)
        # End if
        print("getStories uri = %s" % uri)
        print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting stories', reqStatus)

    # End def


    def getAssets(self, assetType=None, whereClause=None):
        uri = "%s/rest-1.v1/Data/%s" % (self.uriBase, assetType)
        if whereClause is not None:
            uri = "%s?where=%s" % (uri, whereClause)
        # End if
        print("getAssets uri = %s" % uri)
        print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting stories', reqStatus)

    # End def

    def getMember(self, whereClause=None):
        uri = "%s/rest-1.v1/Data/Member" % self.uriBase
        if whereClause is not None:
            uri = "%s?where=%s" % (uri, whereClause)
        # End if
        print("getMember uri = %s" % uri)
        print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting stories', reqStatus)

    # End def

    def updateStoryStatus(self, ticket, status):
        
        whereClause = "Number='%s'" % ticket
        data = self.getStories(whereClause)
        uri = data['Assets'][0]['href']
        print("story status %s" % status)

        #xml = "<Asset> <Relation name=\"Status\" act=\"set\"> <Asset idref=\"StoryStatus:%s\" /> </Relation> </Asset>" % self.create_story_status()[status]
        xml = "<Asset> <Relation name=\"Status\" act=\"set\"> <Asset idref=\"StoryStatus:%s\" /> </Relation> </Asset>" % self.get_story_status_list_by_teamprocess(ticket)[status]
        print("Update Status uri = %s" % uri)
        print("Update Status XML ~%s~" % xml)
        #Update Status XML ~<Asset> <Relation name="Status" act="set"> <Asset idref="StoryStatus:137" /> </Relation> </Asset>~
        print("Update Status Headers = %s" % self.optionHeader)
        response = self.httpRequest.post(uri, xml, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return
        # End if
        raise ValueError('Error getting stories', reqStatus)

    # End def

    def get_story_status_list(self):
        uri = "%s/rest-1.v1/Data/StoryStatus?sel=Name,RollupState,Team.Name&where=Team.Name=\"\"" % self.uriBase
        print("getStoryStatus uri = %s" % uri)
        print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)

        results = json.loads(response.getResponse())
        data = {}
        assets = results['Assets']
        for asset in assets:
            key = asset['Attributes']['Name']['value']
            value = asset['id'].split(":")[1]
            data[key] = value
        
        print("data=%s" % data)

        req_status = response.getStatus()
        print("Request Status %s" % req_status)
        if req_status == STATUS_OK:
            #return json.loads(response.getResponse())
            return data
        # End if
        raise ValueError('Error getting story statuese', req_status)
    # End def

    def get_story_status_list_by_team(self, teamName=None):
        if(teamName is not None and teamName and teamName.strip()):
            uri = "%s/rest-1.v1/Data/StoryStatus?sel=Name,RollupState,Team.Name&where=Team.Name=\"%s\"" % (self.uriBase, teamName)
        else:
            uri = "%s/rest-1.v1/Data/StoryStatus?sel=Name,RollupState,Team.Name&where=Team.Name=\"\"" % self.uriBase
        print("getStoryStatus uri = %s" % uri)
        print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)

        results = json.loads(response.getResponse())
        data = {}
        assets = results['Assets']
        for asset in assets:
            key = asset['Attributes']['Name']['value']
            value = asset['id'].split(":")[1]
            data[key] = value

        print("data=%s" % data)

        req_status = response.getStatus()
        print("Request Status %s" % req_status)
        if req_status == STATUS_OK:
            #return json.loads(response.getResponse())
            return data
        # End if
        raise ValueError('Error getting story status', req_status)
    # End def

    def get_story_status_list_by_teamprocess(self, ticket):

        results = self.getStories("Number='%s'" % ticket)
        asset = results['Assets'][0]
        teamName = asset['Attributes']['Team.Name']['value']
        print("team name=%s" % teamName)
        statuses = self.get_story_status_list_by_team(teamName)
        if teamName and teamName.strip() and len(statuses)>0:
            print("Story %s under team '%s' has team process set with %s statuses."% (ticket, teamName, len(statuses)))
            return self.get_story_status_list_by_team(teamName)
        else:
            print("Story %s under team '%s' has no team process set."% (ticket, teamName))
            return self.get_story_status_list_by_team()

    # End def

# End class
