/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.xlinsight.service;

import com.typesafe.config.Config;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.TemplateApi;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.xlinsight.dto.ArtefactDTO;
import com.xebialabs.xlrelease.plugins.xlinsight.dto.ArtefactsDTO;
import com.xebialabs.xlrelease.plugins.xlinsight.dto.ArtefactsDTO$;
import com.xebialabs.xlrelease.plugins.xlinsight.dto.ArtefactsResponseDTO;
import com.xebialabs.xlrelease.plugins.xlinsight.dto.CrawlerData;
import com.xebialabs.xlrelease.plugins.xlinsight.dto.DedupeMetadata;
import com.xebialabs.xlrelease.plugins.xlinsight.dto.ReleaseDataDTO;
import com.xebialabs.xlrelease.plugins.xlinsight.repository.XlrArchiveRepository;
import com.xebialabs.xlrelease.plugins.xlinsight.service.AuthUtil$;
import com.xebialabs.xlrelease.plugins.xlinsight.service.PluginProperties;
import com.xebialabs.xlrelease.plugins.xlinsight.service.XLIInstance;
import com.xebialabs.xlrelease.plugins.xlinsight.service.XLIInstance$;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0001\r\u0015g\u0001B\u0001\u0003\u0001=\u0011q\u0003\u00177s\t\u0006$\u0018-\u0012=ue\u0006\u001cGo\u001c:TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002\u001f7j]NLw\r\u001b;\u000b\u0005\u001dA\u0011a\u00029mk\u001eLgn\u001d\u0006\u0003\u0013)\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005-a\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001BC\u0002\u0013\u0005\u0001$\u0001\u000byYJ\f%o\u00195jm\u0016\u0014V\r]8tSR|'/_\u000b\u00023A\u0011!$H\u0007\u00027)\u0011A\u0004B\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u0010\u001c\u0005QAFN]!sG\"Lg/\u001a*fa>\u001c\u0018\u000e^8ss\"A\u0001\u0005\u0001B\u0001B\u0003%\u0011$A\u000byYJ\f%o\u00195jm\u0016\u0014V\r]8tSR|'/\u001f\u0011\t\u0011\t\u0002!Q1A\u0005\u0002\r\nQ\u0001\u001d:paN,\u0012\u0001\n\t\u0003K\u0019j\u0011AA\u0005\u0003O\t\u0011\u0001\u0003\u00157vO&t\u0007K]8qKJ$\u0018.Z:\t\u0011%\u0002!\u0011!Q\u0001\n\u0011\na\u0001\u001d:paN\u0004\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\u0002\u0017Q,W\u000e\u001d7bi\u0016\f\u0005/[\u000b\u0002[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0003mFR!A\r\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u00025_\tYA+Z7qY\u0006$X-\u00119j\u0011!1\u0004A!A!\u0002\u0013i\u0013\u0001\u0004;f[Bd\u0017\r^3Ba&\u0004\u0003\"\u0002\u001d\u0001\t\u0003I\u0014A\u0002\u001fj]&$h\b\u0006\u0003;wqj\u0004CA\u0013\u0001\u0011\u00159r\u00071\u0001\u001a\u0011\u0015\u0011s\u00071\u0001%\u0011\u0015Ys\u00071\u0001.Q\t9t\b\u0005\u0002A\u00176\t\u0011I\u0003\u0002C\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0011+\u0015a\u00024bGR|'/\u001f\u0006\u0003\r\u001e\u000bQAY3b]NT!\u0001S%\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AS\u0001\u0004_J<\u0017B\u0001'B\u0005%\tU\u000f^8xSJ,G-\u0002\u0003O\u0001\u0001y%a\u0003*fgB|gn]3NCB\u0004B\u0001U,[;:\u0011\u0011+\u0016\t\u0003%Ji\u0011a\u0015\u0006\u0003):\ta\u0001\u0010:p_Rt\u0014B\u0001,\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0004\u001b\u0006\u0004(B\u0001,\u0013!\t\u00016,\u0003\u0002]3\n11\u000b\u001e:j]\u001e\u0004\"!\u00050\n\u0005}\u0013\"a\u0002\"p_2,\u0017M\u001c\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0003\u0019!xn[3ogV\t1\r\u0005\u0003eW6\u0004X\"A3\u000b\u0005\u0019<\u0017AC2p]\u000e,(O]3oi*\u0011\u0001.[\u0001\u0005kRLGNC\u0001k\u0003\u0011Q\u0017M^1\n\u00051,'!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011QE\\\u0005\u0003_\n\u00111\u0002\u0017'J\u0013:\u001cH/\u00198dKB\u0019\u0011#\u001d.\n\u0005I\u0014\"AB(qi&|g\u000e\u0003\u0004u\u0001\u0001\u0006IaY\u0001\bi>\\WM\\:!\u0011\u001d1\bA1A\u0005\u0002]\fq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002qB\u0011A-_\u0005\u0003u\u0016\u0014\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u0019a\b\u0001)A\u0005q\u0006\u0001R\r_3dkR|'oU3sm&\u001cW\r\t\u0005\b}\u0002\u0011\r\u0011\"\u0001\u0000\u0003\u0019awnZ4feV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA%\u0002\u000bMdg\r\u000e6\n\t\u0005-\u0011Q\u0001\u0002\u0007\u0019><w-\u001a:\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u0003\tq\u0001\\8hO\u0016\u0014\b\u0005C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0001\u0002\u0016\u0005\u0001R*\u0013(V)\u0016{FkT0N\u00132c\u0015jU\u000b\u0003\u0003/\u00012!EA\r\u0013\r\tYB\u0005\u0002\u0004\u0013:$\b\u0002CA\u0010\u0001\u0001\u0006I!a\u0006\u0002#5Ke*\u0016+F?R{u,T%M\u0019&\u001b\u0006\u0005C\u0005\u0002$\u0001\u0011\r\u0011\"\u0001\u0002\u0016\u0005a1\u000bT#F!~k5kX'J\u001d\"A\u0011q\u0005\u0001!\u0002\u0013\t9\"A\u0007T\u0019\u0016+\u0005kX'T?6Ke\n\t\u0005\n\u0003W\u0001!\u0019!C\u0001\u0003+\tAb\u0015'F\u000bB{VjU0N\u0003bC\u0001\"a\f\u0001A\u0003%\u0011qC\u0001\u000e'2+U\tU0N'~k\u0015\t\u0017\u0011\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u0005!\u0011N\\5u)\t\t9\u0004E\u0002\u0012\u0003sI1!a\u000f\u0013\u0005\u0011)f.\u001b;)\t\u0005E\u0012q\b\t\u0005\u0003\u0003\nI%\u0004\u0002\u0002D)\u0019!)!\u0012\u000b\u0005\u0005\u001d\u0013!\u00026bm\u0006D\u0018\u0002BA&\u0003\u0007\u0012Q\u0002U8ti\u000e{gn\u001d;sk\u000e$\bbBA(\u0001\u0011\u0005\u0011\u0011K\u0001\u0014O\u0016$H\u000b\u001b:piRd\u0017N\\4NS2d\u0017n]\u000b\u0003\u0003'\u00022!EA+\u0013\r\t9F\u0005\u0002\u0005\u0019>tw\rC\u0004\u0002\\\u0001!\t!!\u0018\u0002#\u001d,GOU3uef\u001cF.Z3q)&lW\r\u0006\u0003\u0002T\u0005}\u0003\u0002CA1\u00033\u0002\r!a\u0006\u0002\u0019I,GO]=D_VtG/\u001a:\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h\u00059q-\u001a;ICNDG#\u0002.\u0002j\u00055\u0004bBA6\u0003G\u0002\rAW\u0001\u0003S\u0012D\u0001\"a\u001c\u0002d\u0001\u0007\u0011\u0011O\u0001\u0005I\u0006$X\r\u0005\u0003\u0002t\u0005UT\"A4\n\u0007\u0005]tM\u0001\u0003ECR,\u0007bBA3\u0001\u0011%\u00111\u0010\u000b\u00065\u0006u\u0014q\u0010\u0005\b\u0003W\nI\b1\u0001[\u0011\u001d\t\t)!\u001fA\u0002i\u000bAA\\1nK\"9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0015!B:mK\u0016\u0004H\u0003BA\u001c\u0003\u0013C\u0001\"a#\u0002\u0004\u0002\u0007\u00111K\u0001\u0007[&dG.[:\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\u0006)An\\4j]R\u0011\u00111\u0013\u000b\u0004a\u0006U\u0005bBAL\u0003\u001b\u0003\u001d!\\\u0001\tS:\u001cH/\u00198dK\"9\u00111\u0014\u0001\u0005\n\u0005u\u0015aD3yiJ\f7\r\u001e&xiR{7.\u001a8\u0015\t\u0005}\u00151\u0015\u000b\u0004a\u0006\u0005\u0006bBAL\u00033\u0003\u001d!\u001c\u0005\t\u0003K\u000bI\n1\u0001\u0002(\u0006Y\u0001\u0010\\5SKN\u0004xN\\:f!\u0015\tI+a,[\u001b\t\tYKC\u0002\u0002.\u001e\u000bA\u0001\u001b;ua&!\u0011\u0011WAV\u00059\u0011Vm\u001d9p]N,WI\u001c;jifDq!!.\u0001\t\u0013\t9,\u0001\u0006dC2d7+\u001a:wKJ,b!!/\u0002n\u0006%GCCA^\u0003G\f9/!=\u0002|R!\u0011QXAq!\u001d\t\u0012qXAb\u00037L1!!1\u0013\u0005\u0019!V\u000f\u001d7feA!\u0011#]Ac!\u0011\t9-!3\r\u0001\u0011A\u00111ZAZ\u0005\u0004\tiMA\u0001T#\u0011\ty-!6\u0011\u0007E\t\t.C\u0002\u0002TJ\u0011qAT8uQ&tw\rE\u0002\u0012\u0003/L1!!7\u0013\u0005\r\te.\u001f\t\u0005\u0003S\u000bi.\u0003\u0003\u0002`\u0006-&A\u0003%uiB\u001cF/\u0019;vg\"9\u0011qSAZ\u0001\bi\u0007bBAs\u0003g\u0003\rAW\u0001\u0004kJd\u0007\u0002CAu\u0003g\u0003\r!a;\u0002\t\u0011\fG/\u0019\t\u0005\u0003\u000f\fi\u000f\u0002\u0005\u0002p\u0006M&\u0019AAg\u0005\u0005!\u0006\u0002CAz\u0003g\u0003\r!!>\u0002\u0019I,7\u000f]8og\u0016$\u0016\u0010]3\u0011\u000bA\u000b90!2\n\u0007\u0005e\u0018LA\u0003DY\u0006\u001c8\u000fC\u0004\u0002~\u0006M\u0006\u0019\u0001.\u0002\u000bQ|7.\u001a8\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\u0005QAO]=U_NcW-\u001a9\u0015\t\u0005]\"Q\u0001\u0005\t\u0003C\ny\u00101\u0001\u0002\u0018!9!\u0011\u0002\u0001\u0005\n\t-\u0011a\u00043p!>\u001cHoV5uQJ+GO]=\u0016\r\t5!q\u0004B\u000b))\u0011yA!\u0007\u0003\u001c\t\u0005\"Q\u0005\u000b\u0005\u0005#\u00119\u0002\u0005\u0003\u0012c\nM\u0001\u0003BAd\u0005+!\u0001\"a3\u0003\b\t\u0007\u0011Q\u001a\u0005\b\u0003/\u00139\u0001q\u0001n\u0011\u001d\t)Oa\u0002A\u0002iC\u0001\"!;\u0003\b\u0001\u0007!Q\u0004\t\u0005\u0003\u000f\u0014y\u0002\u0002\u0005\u0002p\n\u001d!\u0019AAg\u0011!\t\u0019Pa\u0002A\u0002\t\r\u0002#\u0002)\u0002x\nM\u0001BCA1\u0005\u000f\u0001\n\u00111\u0001\u0002\u0018!\"!q\u0001B\u0015!\u0011\u0011YCa\f\u000e\u0005\t5\"B\u0001\"\u0013\u0013\u0011\u0011\tD!\f\u0003\u000fQ\f\u0017\u000e\u001c:fG\"9!Q\u0007\u0001\u0005\u0002\t]\u0012A\n4fi\u000eDGk\u001c9N_N$(+\u001a7fCN,7/\u00133t'>\u0014H/\u001a3Cs\u0016sG\rR1uKR!!\u0011\bB,!\u0019\u0011YD!\u0012\u0003L9!!Q\bB!\u001d\r\u0011&qH\u0005\u0002'%\u0019!1\t\n\u0002\u000fA\f7m[1hK&!!q\tB%\u0005\r\u0019V-\u001d\u0006\u0004\u0005\u0007\u0012\u0002CB\t\u0002@j\u0013i\u0005\u0005\u0003\u0003P\tUSB\u0001B)\u0015\r\u0011\u0019&[\u0001\u0004gFd\u0017\u0002BA<\u0005#B\u0001B!\u0017\u00034\u0001\u0007\u00111K\u0001\u0007_\u001a47/\u001a;\t\u000f\tu\u0003\u0001\"\u0001\u0003`\u0005)b-\u001a;dQR{\u0007/T8tiR+W\u000e\u001d7bi\u0016\u001cH\u0003\u0002B1\u0005_\u0002bAa\u000f\u0003F\t\r\u0004\u0003\u0002B3\u0005Wj!Aa\u001a\u000b\u0007\t%\u0004\"\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0005[\u00129GA\u0004SK2,\u0017m]3\t\u0011\tE$1\fa\u0001\u0003'\nA\u0001]1hK\"9!Q\u000f\u0001\u0005\u0002\t]\u0014!I2iK\u000e\\\u0017JZ!me\u0016\fG-_&o_^t')_%oO\u0016\u001cH/[8o\u0003BLG\u0003\u0002B=\u0005\u0003#BAa\u001f\u0003\u0000A\u0019!QP'\u000e\u0003\u0001Aq!a&\u0003t\u0001\u000fQ\u000e\u0003\u0005\u0003\u0004\nM\u0004\u0019\u0001BC\u0003%\t'\u000f^5gC\u000e$8\u000f\u0005\u0004\u0003<\t\u0015#q\u0011\t\u0005\u0005\u0013\u0013y)\u0004\u0002\u0003\f*\u0019!Q\u0012\u0003\u0002\u0007\u0011$x.\u0003\u0003\u0003\u0012\n-%aC!si\u00164\u0017m\u0019;E)>CqA!&\u0001\t\u0003\u00119*A\u0011tK:$WK\\&o_^t\u0017I\u001d;jM\u0006\u001cG\u000fV8J]\u001e,7\u000f^5p]\u0006\u0003\u0018\u000e\u0006\u0005\u0003\u001a\nu%\u0011\u0015BR)\u0011\t9Da'\t\u000f\u0005]%1\u0013a\u0002[\"9!q\u0014BJ\u0001\u0004Q\u0016\u0001\u00026t_:Dq!a\u001b\u0003\u0014\u0002\u0007!\fC\u0004\u0003&\nM\u0005\u0019\u0001.\u0002\t!\f7\u000f[\u0003\u0007\u0005S\u0003AAa+\u0003'I+G.Z1tK&#\u0017I\u001c3F]\u0012$\u0015\r^3\u0011\rE\tyLWA9\u0011\u001d\u0011y\u000b\u0001C\u0005\u0005c\u000bQ\u0003Z3uK\u000e$XK\\6o_^t'+\u001a7fCN,7\u000f\u0006\u0005\u00034\n}&1\u0019Bc)\u0011\u0011)L!0\u0011\r\tm\"q\u0017B^\u0013\u0011\u0011IL!\u0013\u0003\t1K7\u000f\u001e\t\u0005\u0005{\u00129\u000bC\u0004\u0002\u0018\n5\u00069A7\t\u0011\t\u0005'Q\u0016a\u0001\u0005k\u000b!#\u001e8l]><hNU3mK\u0006\u001cXm]!dG\"A!\u0011\fBW\u0001\u0004\t\u0019\u0006\u0003\u0005\u0003H\n5\u0006\u0019AA*\u0003\u0015!W\r\\1zQ\u0011\u0011iK!\u000b\t\u000f\t5\u0007\u0001\"\u0001\u0003P\u0006)\u0012N\\5u\u0003J\u001c\u0007.\u001b<f\u000bb$(/Y2uS>tG\u0003BA\u001c\u0005#Dq!a&\u0003L\u0002\u000fQ\u000eC\u0004\u0003V\u0002!IAa6\u0002-\u0011,G/Z2u+:\\gn\\<o)\u0016l\u0007\u000f\\1uKN$bA!7\u0003^\n}G\u0003BA\u001c\u00057Dq!a&\u0003T\u0002\u000fQ\u000e\u0003\u0005\u0003r\tM\u0007\u0019AA*\u0011!\u00119Ma5A\u0002\u0005M\u0003\u0006\u0002Bj\u0005SAqA!:\u0001\t\u0003\u00119/\u0001\fj]&$H+Z7qY\u0006$X-\u0012=ue\u0006\u001cG/[8o)\u0011\t9D!;\t\u000f\u0005]%1\u001da\u0002[\"9!Q\u001e\u0001\u0005\n\t=\u0018!\u00052vS2$'+Z:u)\u0016l\u0007\u000f\\1uKR1!\u0011_B\u0001\u0007\u000b\u0001BAa=\u0003~6\u0011!Q\u001f\u0006\u0005\u0005o\u0014I0\u0001\u0004dY&,g\u000e\u001e\u0006\u0004\u0005w<\u0015aA<fE&!!q B{\u00051\u0011Vm\u001d;UK6\u0004H.\u0019;f\u0011\u001d\u0019\u0019Aa;A\u0002u\u000bA#Y2dKB$8+\u001a7g'&<g.\u001a3DKJ$\bbBB\u0004\u0005W\u0004\rAW\u0001\bE\u0006\u001cX-\u0016:m\u0011\u001d\u0019Y\u0001\u0001C\u0001\u0007\u001b\t1\u0003Z8Q_N$x+\u001b;i%\u0016$(/\u001f+fgR,baa\u0004\u0004 \rUA\u0003DB\t\u0007/\u0019Iba\u0007\u0004\"\r\u0015\u0002\u0003B\tr\u0007'\u0001B!a2\u0004\u0016\u0011A\u00111ZB\u0005\u0005\u0004\ti\rC\u0004\u0002\u0018\u000e%\u00019A7\t\u000f\u0005\u00158\u0011\u0002a\u00025\"A\u0011\u0011^B\u0005\u0001\b\u0019i\u0002\u0005\u0003\u0002H\u000e}A\u0001CAx\u0007\u0013\u0011\r!!4\t\u0011\u0005M8\u0011\u0002a\u0002\u0007G\u0001R\u0001UA|\u0007'A!\"!\u0019\u0004\nA\u0005\t9AA\f\u0011\u001d\u0019I\u0003\u0001C\u0001\u0007W\tabY1mGVd\u0017\r^3EK2\f\u0017\u0010\u0006\u0004\u0004.\rE2Q\u0007\u000b\u0005\u0003'\u001ay\u0003C\u0004\u0002\u0018\u000e\u001d\u00029A7\t\u0011\rM2q\u0005a\u0001\u0003'\nq\u0001\\1uK:\u001c\u0017\u0010\u0003\u0005\u00048\r\u001d\u0002\u0019AA*\u00035\u0001(/\u001a<j_V\u001cH)\u001a7bs\"911\b\u0001\u0005\n\ru\u0012aE1qa2LH\u000b\u001b:piRdWMR1di>\u0014H\u0003BB \u0007\u0013\"Ba!\u0011\u0004HA\u0019\u0011ca\u0011\n\u0007\r\u0015#C\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003/\u001bI\u0004q\u0001n\u0011!\u0019Ye!\u000fA\u0002\r\u0005\u0013\u0001\u0002;j[\u0016Dqaa\u0014\u0001\t\u0013\u0019\t&A\ffq\u0016\u001cW\u000f^3JM:{G/\u00138uKJ\u0014X\u000f\u001d;fIV!11KB-)\u0011\u0019)f!\u001a\u0015\t\r]31\f\t\u0005\u0003\u000f\u001cI\u0006\u0002\u0005\u0002p\u000e5#\u0019AAg\u0011%\u0019if!\u0014\u0005\u0002\u0004\u0019y&\u0001\u0002g]B)\u0011c!\u0019\u0004X%\u001911\r\n\u0003\u0011q\u0012\u0017P\\1nKzB\u0001ba\u001a\u0004N\u0001\u00071qK\u0001\u0013m\u0006dW/Z%g\u0013:$XM\u001d:vaR,G\rC\u0004\u0004l\u0001!Ia!\u001c\u0002A\u0015DXmY;uK^KG\u000f\u001b#fY\u0006L\u0018J\u001a(pi&sG/\u001a:skB$X\rZ\u000b\u0005\u0007_\u001aI\b\u0006\u0004\u0004r\r\u000551\u0011\u000b\u0005\u0007g\u001ai\b\u0006\u0003\u0004v\rm\u0004cB\t\u0002@\u000e]\u00141\u000b\t\u0005\u0003\u000f\u001cI\b\u0002\u0005\u0002p\u000e%$\u0019AAg\u0011\u001d\t9j!\u001bA\u00045D\u0011b!\u0018\u0004j\u0011\u0005\raa \u0011\u000bE\u0019\tga\u001e\t\u0011\r\u001d4\u0011\u000ea\u0001\u0007oB\u0001Ba2\u0004j\u0001\u0007\u00111\u000b\u0005\b\u0007\u000f\u0003A\u0011AA\u001b\u0003\u001d!Wm\u001d;s_fDCa!\"\u0004\fB!\u0011\u0011IBG\u0013\u0011\u0019y)a\u0011\u0003\u0015A\u0013X\rR3tiJ|\u0017\u0010C\u0005\u0004\u0014\u0002\t\n\u0011\"\u0003\u0004\u0016\u0006IBm\u001c)pgR<\u0016\u000e\u001e5SKR\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\u0019\u00199j!+\u0004,V\u00111\u0011\u0014\u0016\u0005\u0003/\u0019Yj\u000b\u0002\u0004\u001eB!1qTBS\u001b\t\u0019\tK\u0003\u0003\u0004$\n5\u0012!C;oG\",7m[3e\u0013\u0011\u00199k!)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0005\u0002p\u000eE%\u0019AAg\t!\tYm!%C\u0002\u00055\u0007\"CBX\u0001E\u0005I\u0011ABY\u0003u!w\u000eU8ti^KG\u000f\u001b*fiJLH+Z:uI\u0011,g-Y;mi\u0012*TCBBL\u0007g\u001b)\f\u0002\u0005\u0002p\u000e5&\u0019AAg\t!\tYm!,C\u0002\u00055\u0007f\u0001\u0001\u0004:B!11XBa\u001b\t\u0019iLC\u0002\u0004@\u001e\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0019\u0019m!0\u0003\u000fM+'O^5dK\u0002")
public class XlrDataExtractorService {
    private final XlrArchiveRepository xlrArchiveRepository;
    private final PluginProperties props;
    private final TemplateApi templateApi;
    private final ConcurrentHashMap<XLIInstance, Option<String>> tokens;
    private final ScheduledExecutorService executorService;
    private final Logger logger;
    private final int MINUTE_TO_MILLIS;
    private final int SLEEP_MS_MIN;
    private final int SLEEP_MS_MAX;

    public XlrArchiveRepository xlrArchiveRepository() {
        return this.xlrArchiveRepository;
    }

    public PluginProperties props() {
        return this.props;
    }

    public TemplateApi templateApi() {
        return this.templateApi;
    }

    public ConcurrentHashMap<XLIInstance, Option<String>> tokens() {
        return this.tokens;
    }

    public ScheduledExecutorService executorService() {
        return this.executorService;
    }

    public Logger logger() {
        return this.logger;
    }

    public int MINUTE_TO_MILLIS() {
        return this.MINUTE_TO_MILLIS;
    }

    public int SLEEP_MS_MIN() {
        return this.SLEEP_MS_MIN;
    }

    public int SLEEP_MS_MAX() {
        return this.SLEEP_MS_MAX;
    }

    @PostConstruct
    public void init() {
        Instant delay = Instant.now().plus((long)this.MINUTE_TO_MILLIS(), ChronoUnit.MILLIS);
        this.props().xliDestinationInstances().forEach(config -> {
            ConcurrentTaskScheduler taskScheduler = new ConcurrentTaskScheduler(this.executorService());
            XLIInstance xlrInstance = XLIInstance$.MODULE$.configToXLIInstance((Config)config, (Function2<Object, String, RestTemplate>)(Function2 & Serializable & scala.Serializable)(acceptSelfSignedCert, baseUrl) -> this.buildRestTemplate(BoxesRunTime.unboxToBoolean((Object)acceptSelfSignedCert), baseUrl));
            this.tokens().put(xlrInstance, this.login(xlrInstance));
            taskScheduler.schedule(() -> this.initArchiveExtraction(xlrInstance), Date.from(delay));
            taskScheduler.schedule(() -> this.initArchiveExtraction(xlrInstance), (Trigger)new CronTrigger(xlrInstance.cronExpression()));
            taskScheduler.schedule(() -> this.initTemplateExtraction(xlrInstance), Date.from(delay));
            taskScheduler.schedule(() -> this.initTemplateExtraction(xlrInstance), (Trigger)new CronTrigger(xlrInstance.cronExpression()));
        });
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"XLI: Data extraction jobs scheduled with delay ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{delay})));
    }

    public long getThrottlingMillis() {
        return this.props().throttlingMinutes() * (long)this.MINUTE_TO_MILLIS();
    }

    public long getRetrySleepTime(int retryCounter) {
        return (long)this.MINUTE_TO_MILLIS() * RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(Math.pow(2.0, Math.min(retryCounter, this.props().maxNormalRetry()))));
    }

    private String getHash(String id, Date date) {
        return id + date.getTime();
    }

    private String getHash(String id, String name) {
        return id + "@" + name;
    }

    private void sleep(long millis) {
        block2: {
            Failure failure;
            if (Thread.currentThread().isInterrupted()) break block2;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(millis));
            if (try_ instanceof Failure && (failure = (Failure)try_).exception() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                this.logger().info("Received interruption signal");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private Option<String> login(XLIInstance instance) {
        None$ none$;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        JSONObject authBody = new JSONObject();
        authBody.put("username", (Object)instance.username());
        authBody.put("password", (Object)instance.password());
        authBody.put("rememberMe", true);
        HttpEntity entity = new HttpEntity((Object)authBody.toString(), (MultiValueMap)headers);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> instance.client().exchange(instance.authenticateUrl(), HttpMethod.POST, entity, String.class, new Object[0]));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ResponseEntity xliResponse = (ResponseEntity)success.value();
            none$ = this.extractJwtToken((ResponseEntity<String>)xliResponse, instance);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error("Error during a call for JWT token: {}", e);
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    private Option<String> extractJwtToken(ResponseEntity<String> xliResponse, XLIInstance instance) {
        None$ none$;
        JSONObject jsonBody = new JSONObject((String)xliResponse.getBody());
        if (jsonBody.has("id_token")) {
            String jwtToken = jsonBody.getString("id_token");
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Logged in to XLI(", "). Token={}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instance.xliBaseUrl()})), new Object[]{jwtToken});
            none$ = new Some((Object)jwtToken);
        } else {
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not login XLR XLI user to ", "! Cause: {}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instance.authenticateUrl()})), new Object[]{jsonBody.toString()});
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private <T, S> Tuple2<Option<S>, HttpStatus> callServer(String url, T data, Class<S> responseType, String token, XLIInstance instance) {
        Tuple2 tuple2;
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bearer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{token})));
        HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> instance.client().exchange(url, HttpMethod.POST, httpEntity, responseType, new Object[0]));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ResponseEntity rs = (ResponseEntity)success.value();
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response received: ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rs.toString(), url})));
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Option$.MODULE$.apply(rs.getBody())), (Object)rs.getStatusCode());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"XLI: Error posting data for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})), e);
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)HttpStatus.I_AM_A_TEAPOT);
        } else {
            throw new MatchError((Object)try_);
        }
        return tuple2;
    }

    private void tryToSleep(int retryCounter) {
        block0: {
            if (retryCounter <= 0) break block0;
            long retrySleepTime = this.getRetrySleepTime(retryCounter);
            this.logger().info("XLI: Tried {} times. Increasing timeout exponentially to {}", (Object)BoxesRunTime.boxToInteger((int)retryCounter), (Object)BoxesRunTime.boxToLong((long)retrySleepTime));
            this.sleep(retrySleepTime);
        }
    }

    private <T, S> Option<S> doPostWithRetry(String url, T data, Class<S> responseType, int retryCounter, XLIInstance instance) {
        Option response;
        block2: {
            Tuple3 tuple3;
            while (true) {
                Tuple3 result;
                Tuple3 RETRY_WITH_DELAY = new Tuple3((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)(retryCounter + 1)), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                Tuple3 RETRY_WITHOUT_DELAY = new Tuple3((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                this.tryToSleep(retryCounter);
                tuple3 = result = this.executeIfNotInterrupted(new Tuple3((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToInteger((int)retryCounter), (Object)BoxesRunTime.boxToBoolean((boolean)true)), () -> XlrDataExtractorService.$anonfun$doPostWithRetry$1(this, url, data, responseType, retryCounter, instance, RETRY_WITH_DELAY, RETRY_WITHOUT_DELAY));
                if (tuple3 != null) {
                    response = (Option)tuple3._1();
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                    if (bl) break block2;
                }
                if (tuple3 == null) break;
                int retry = BoxesRunTime.unboxToInt((Object)tuple3._2());
                boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                if (bl) break;
                retryCounter = retry;
            }
            throw new MatchError((Object)tuple3);
        }
        Option option = response;
        return option;
    }

    private <T, S> int doPostWithRetry$default$4() {
        return 0;
    }

    public Seq<Tuple2<String, java.sql.Date>> fetchTopMostReleasesIdsSortedByEndDate(long offset) {
        Seq result = this.xlrArchiveRepository().getAllReleasesIds(this.props().chunkLimit(), offset);
        return result != null ? result : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Seq<Release> fetchTopMostTemplates(long page) {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.templateApi().getTemplates(null, null, Predef$.MODULE$.long2Long(page), Predef$.MODULE$.long2Long(this.props().chunkLimit()), Predef$.MODULE$.int2Integer(1))).asScala();
    }

    public Map<String, Object> checkIfAlreadyKnownByIngestionApi(Seq<ArtefactDTO> artifacts, XLIInstance instance) {
        Map map;
        ArtefactsDTO artifactsDTO = new ArtefactsDTO((ArtefactDTO[])artifacts.toArray(ClassTag$.MODULE$.apply(ArtefactDTO.class)), instance.tenantId(), instance.dataSourceId(), ArtefactsDTO$.MODULE$.apply$default$4());
        this.logger().debug("XLI: check if the artifacts are already known");
        Option<ArtefactsResponseDTO> option = this.doPostWithRetry(instance.fetchMetadataUrl(), artifactsDTO, ArtefactsResponseDTO.class, this.doPostWithRetry$default$4(), instance);
        if (option instanceof Some) {
            Some some = (Some)option;
            ArtefactsResponseDTO resp = (ArtefactsResponseDTO)some.value();
            map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resp.artefacts())).map((Function1 & Serializable & scala.Serializable)artifact -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)artifact.getArtefactId()), (Object)BoxesRunTime.boxToBoolean((boolean)artifact.getIsKnown())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    public void sendUnKnownArtifactToIngestionApi(String json, String id, String hash, XLIInstance instance) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"XLI: Send XLR data over to XLI for id: ", ", hash: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, hash})));
        String x$7 = instance.tenantId();
        int x$8 = ArtefactsDTO$.MODULE$.XLR_DATA_SOURCE_TYPE();
        String x$9 = instance.dataSourceId();
        String x$10 = "OK";
        String x$4 = json;
        String x$5 = hash;
        DedupeMetadata x$6 = new DedupeMetadata(id, hash, 0L);
        CrawlerData x$11 = new CrawlerData(x$6, x$4, x$5);
        ReleaseDataDTO releaseDataDTO = new ReleaseDataDTO(x$11, x$10, x$7, x$8, x$9);
        this.doPostWithRetry(instance.postDataUrl(), releaseDataDTO, String.class, this.doPostWithRetry$default$4(), instance);
    }

    private List<Tuple2<String, Date>> detectUnknownReleases(List<Tuple2<String, Date>> unknownReleasesAcc, long offset, long delay, XLIInstance instance) {
        List list;
        block3: {
            block2: {
                List updatedAcc;
                while (true) {
                    Tuple2<GenTraversable, Object> rs;
                    Tuple2<GenTraversable, Object> tuple2;
                    if ((tuple2 = (rs = this.executeWithDelayIfNotInterrupted(Seq$.MODULE$.apply((Seq)Nil$.MODULE$), delay, (Function0 & Serializable & scala.Serializable)() -> this.fetchTopMostReleasesIdsSortedByEndDate(offset), instance))) == null) {
                        throw new MatchError(tuple2);
                    }
                    Seq releases = (Seq)tuple2._1();
                    long nextDelay = tuple2._2$mcJ$sp();
                    Tuple2 tuple22 = new Tuple2((Object)releases, (Object)BoxesRunTime.boxToLong((long)nextDelay));
                    Tuple2 tuple23 = tuple22;
                    Seq releases2 = (Seq)tuple23._1();
                    long nextDelay2 = tuple23._2$mcJ$sp();
                    if (!releases2.nonEmpty()) break block2;
                    Seq artifacts = (Seq)releases2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String relId = (String)tuple2._1();
                        java.sql.Date endDate = (java.sql.Date)tuple2._2();
                        ArtefactDTO artefactDTO = new ArtefactDTO(relId, this.getHash(relId, endDate));
                        return artefactDTO;
                    }, Seq$.MODULE$.canBuildFrom());
                    Map responseMap = (Map)this.executeIfNotInterrupted(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function0 & Serializable & scala.Serializable)() -> this.checkIfAlreadyKnownByIngestionApi((Seq<ArtefactDTO>)artifacts, instance));
                    Seq unknownReleases = (Seq)releases2.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)XlrDataExtractorService.$anonfun$detectUnknownReleases$4(responseMap, x0$2)));
                    updatedAcc = (List)unknownReleasesAcc.$plus$plus((GenTraversableOnce)unknownReleases, List$.MODULE$.canBuildFrom());
                    if (unknownReleases.size() != releases2.size()) break;
                    long currentOffset = offset + this.props().chunkLimit();
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"XLI: Next offset for unknown releases will be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)currentOffset)})));
                    delay = nextDelay2;
                    offset = currentOffset;
                    unknownReleasesAcc = updatedAcc;
                }
                list = updatedAcc;
                break block3;
            }
            list = unknownReleasesAcc;
        }
        return list;
    }

    public void initArchiveExtraction(XLIInstance instance) {
        this.logger().info("XLI: Starting XLR Archive extraction");
        List<Tuple2<String, Date>> unknownReleases = this.detectUnknownReleases((List<Tuple2<String, Date>>)Nil$.MODULE$, 0L, 0L, instance);
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"XLI: Found ", " unknown archive releases"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)unknownReleases.size())})));
        int amountOfReleasesPushedToIngestionApi = BoxesRunTime.unboxToInt((Object)unknownReleases.foldRight((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(releaseIdWithEndDate, counter) -> BoxesRunTime.boxToInteger((int)XlrDataExtractorService.$anonfun$initArchiveExtraction$1(this, instance, releaseIdWithEndDate, BoxesRunTime.unboxToInt((Object)counter)))));
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"XLI: ", " releases pushed to XLI"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)amountOfReleasesPushedToIngestionApi)})));
    }

    private void detectUnknownTemplates(long page, long delay, XLIInstance instance) {
        while (true) {
            Tuple2<GenTraversable, Object> rs;
            Tuple2<GenTraversable, Object> tuple2;
            if ((tuple2 = (rs = this.executeWithDelayIfNotInterrupted(Seq$.MODULE$.apply((Seq)Nil$.MODULE$), delay, (Function0 & Serializable & scala.Serializable)() -> this.fetchTopMostTemplates(page), instance))) == null) {
                throw new MatchError(tuple2);
            }
            Seq templates = (Seq)tuple2._1();
            long nextDelay = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)templates, (Object)BoxesRunTime.boxToLong((long)nextDelay));
            Tuple2 tuple23 = tuple22;
            Seq templates2 = (Seq)tuple23._1();
            long nextDelay2 = tuple23._2$mcJ$sp();
            if (!templates2.nonEmpty()) break;
            Seq artifacts = (Seq)templates2.map((Function1 & Serializable & scala.Serializable)tpl -> new ArtefactDTO(tpl.getId(), this.getHash(tpl.getId(), tpl.get$token())), Seq$.MODULE$.canBuildFrom());
            Map<String, Object> responseMap = this.checkIfAlreadyKnownByIngestionApi((Seq<ArtefactDTO>)artifacts, instance);
            Seq unknownTemplates = (Seq)templates2.filter((Function1 & Serializable & scala.Serializable)tpl -> BoxesRunTime.boxToBoolean((boolean)XlrDataExtractorService.$anonfun$detectUnknownTemplates$3(responseMap, tpl)));
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"XLI: Found ", " unknown templates for page: ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)unknownTemplates.size()), BoxesRunTime.boxToLong((long)page)})));
            int successfullySend = BoxesRunTime.unboxToInt((Object)unknownTemplates.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(counter, tpl) -> BoxesRunTime.boxToInteger((int)XlrDataExtractorService.$anonfun$detectUnknownTemplates$5(this, instance, BoxesRunTime.unboxToInt((Object)counter), tpl))));
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"XLI: ", " templates successfully send to XLI for page ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)successfullySend), BoxesRunTime.boxToLong((long)page)})));
            delay = nextDelay2;
            ++page;
        }
    }

    public void initTemplateExtraction(XLIInstance instance) {
        this.logger().info("XLI: Starting XLR Template extraction");
        AuthUtil$.MODULE$.pretendAsAdmin();
        this.detectUnknownTemplates(0L, 0L, instance);
    }

    /*
     * WARNING - void declaration
     */
    private RestTemplate buildRestTemplate(boolean acceptSelfSignedCert, String baseUrl) {
        void var3_3;
        BoxedUnit boxedUnit;
        RestTemplate rt = new RestTemplate();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (acceptSelfSignedCert) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"XLI: !!!!!!!!!POSSIBLE SECURITY ISSUE!!!!!!!!!: accepting self-signed certificates.. for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            boxedUnit = httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)csf);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        rt.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)httpClientBuilder.build()));
        return var3_3;
    }

    public <T, S> Option<S> doPostWithRetryTest(XLIInstance instance, String url, T data, Class<S> responseType, int retryCounter) {
        return this.doPostWithRetry(url, data, responseType, retryCounter, instance);
    }

    public <T, S> int doPostWithRetryTest$default$5() {
        return 0;
    }

    public long calculateDelay(long latency, long previousDelay, XLIInstance instance) {
        double newDelay = (double)(previousDelay + latency) / 2.0;
        newDelay = Math.max((double)latency, newDelay);
        newDelay = Math.min(Math.max((double)this.SLEEP_MS_MIN(), newDelay), (double)this.SLEEP_MS_MAX());
        return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.applyThrottleFactor(newDelay, instance)));
    }

    private double applyThrottleFactor(double time, XLIInstance instance) {
        return time * instance.throttleFactor();
    }

    private <T> T executeIfNotInterrupted(T valueIfInterrupted, Function0<T> fn) {
        return (T)(!Thread.currentThread().isInterrupted() ? fn.apply() : valueIfInterrupted);
    }

    private <T> Tuple2<T, Object> executeWithDelayIfNotInterrupted(T valueIfInterrupted, long delay, Function0<T> fn, XLIInstance instance) {
        this.sleep(delay);
        Instant startDate = Instant.now();
        T result = this.executeIfNotInterrupted(valueIfInterrupted, fn);
        Instant latency = Instant.now().minusMillis(startDate.toEpochMilli());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToLong((long)this.calculateDelay(latency.toEpochMilli(), delay, instance)));
    }

    @PreDestroy
    public void destroy() {
        block0: {
            this.logger().info("XLI: Kill signal received stopping all processes, please wait...");
            this.executorService().shutdownNow();
            this.logger().warn("XLI: Waiting 30 seconds for executor service to shutdown...");
            boolean terminated = this.executorService().awaitTermination(30L, TimeUnit.SECONDS);
            if (terminated) break block0;
            this.logger().warn("XLI: Could not finish termination of executorService. There are still active threads.");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple3 $anonfun$doPostWithRetry$1(XlrDataExtractorService $this, String url$2, Object data$1, Class responseType$2, int retryCounter$1, XLIInstance instance$4, Tuple3 RETRY_WITH_DELAY$1, Tuple3 RETRY_WITHOUT_DELAY$1) {
        block13: {
            block12: {
                $this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"XLI: Post operation for url: ", " retry counter = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url$2, BoxesRunTime.boxToInteger((int)retryCounter$1)})));
                var11_8 = $this.tokens().get(instance$4);
                if (!(var11_8 instanceof Some)) break block12;
                var12_9 = (Some)var11_8;
                token = (String)var12_9.value();
                var14_11 = $this.callServer(url$2, data$1, responseType$2, token, instance$4);
                if (var14_11 == null) ** GOTO lbl-1000
                resp = (Option)var14_11._1();
                var16_13 = (HttpStatus)var14_11._2();
                if (HttpStatus.OK.equals(var16_13)) {
                    var10_14 = new Tuple3((Object)resp, (Object)BoxesRunTime.boxToInteger((int)retryCounter$1), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                } else if (var14_11 != null && HttpStatus.I_AM_A_TEAPOT.equals(var17_15 = (HttpStatus)var14_11._2())) {
                    var10_14 = RETRY_WITH_DELAY$1;
                } else if (var14_11 != null) {
                    status = (HttpStatus)var14_11._2();
                    $this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server returned code: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{status})));
                    var10_14 = RETRY_WITH_DELAY$1;
                } else {
                    throw new MatchError(var14_11);
                }
                var8_17 = var10_14;
                break block13;
            }
            if (None$.MODULE$.equals(var11_8)) {
                loginResult = $this.login(instance$4);
                $this.tokens().put(instance$4, loginResult);
                var20_19 = loginResult;
                if (var20_19 instanceof Some) {
                    var9_20 = RETRY_WITHOUT_DELAY$1;
                } else if (None$.MODULE$.equals(var20_19)) {
                    var9_20 = RETRY_WITH_DELAY$1;
                } else {
                    throw new MatchError(var20_19);
                }
                var8_17 = var9_20;
            } else {
                throw new MatchError(var11_8);
            }
        }
        return var8_17;
    }

    public static final /* synthetic */ boolean $anonfun$detectUnknownReleases$4(Map responseMap$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        boolean bl = !BoxesRunTime.unboxToBoolean((Object)responseMap$1.getOrElse((Object)id, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        return bl;
    }

    public static final /* synthetic */ int $anonfun$initArchiveExtraction$1(XlrDataExtractorService $this, XLIInstance instance$2, Tuple2 releaseIdWithEndDate, int counter) {
        return BoxesRunTime.unboxToInt((Object)$this.executeIfNotInterrupted((Object)BoxesRunTime.boxToInteger((int)counter), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            int updatedCounter;
            block1: {
                Tuple2 tuple2 = releaseIdWithEndDate;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String id = (String)tuple2._1();
                Date date = (Date)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)id, (Object)date);
                Tuple2 tuple23 = tuple22;
                String id2 = (String)tuple23._1();
                Date date2 = (Date)tuple23._2();
                $this.xlrArchiveRepository().getReleaseJson(id2).foreach((Function1 & Serializable & scala.Serializable)json -> {
                    $this.sendUnKnownArtifactToIngestionApi(json, id2, $this.getHash(id2, date2), instance$2);
                    return BoxedUnit.UNIT;
                });
                updatedCounter = counter + 1;
                if ((long)updatedCounter % $this.props().chunkLimit() != 0L) break block1;
                long millis = $this.getThrottlingMillis();
                $this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Throttling applied with ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)millis)})));
                $this.sleep(millis);
            }
            return updatedCounter;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$detectUnknownTemplates$3(Map responseMap$2, Release tpl) {
        return !BoxesRunTime.unboxToBoolean((Object)responseMap$2.getOrElse((Object)tpl.getId(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public static final /* synthetic */ int $anonfun$detectUnknownTemplates$5(XlrDataExtractorService $this, XLIInstance instance$6, int counter, Release tpl) {
        return BoxesRunTime.unboxToInt((Object)$this.executeIfNotInterrupted((Object)BoxesRunTime.boxToInteger((int)counter), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            String json = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)tpl);
            $this.sendUnKnownArtifactToIngestionApi(json, tpl.getId(), $this.getHash(tpl.getId(), tpl.get$token()), instance$6);
            return counter + 1;
        }));
    }

    @Autowired
    public XlrDataExtractorService(XlrArchiveRepository xlrArchiveRepository, PluginProperties props, TemplateApi templateApi) {
        this.xlrArchiveRepository = xlrArchiveRepository;
        this.props = props;
        this.templateApi = templateApi;
        this.tokens = new ConcurrentHashMap();
        this.executorService = Executors.newScheduledThreadPool(props.xliDestinationInstances().size() * 2);
        this.logger = LoggerFactory.getLogger(XlrDataExtractorService.class);
        this.MINUTE_TO_MILLIS = 60000;
        this.SLEEP_MS_MIN = 5;
        this.SLEEP_MS_MAX = 10000;
    }
}

