import hashlib
import hmac
import sys
from com.xebialabs.deployit.util import PasswordEncrypter
from java.lang import Exception

global endpoint
global config
global headers
global params
global payload

def constant_time_strcmp(a, b):
    if len(a) == len(b):
        difference = 0
        for x, y in zip(a, b):
            difference |= ord(x) ^ ord(y)
        if difference == 0:
            return True
    return False

def get_signature():
    raw_signature = headers.get('X-Hub-Signature')
    if not raw_signature.startswith('sha1='):
        return None
    signature = raw_signature[5:]
    return signature.encode('utf-8')

def get_key():
    key = PasswordEncrypter.getInstance().decrypt(config.githubSecret)
    return key.encode('utf-8')

def compute_digest(key):
    h = hmac.new(key, payload.encode('utf-8'), hashlib.sha1)
    return h.hexdigest()

def authenticate():
    try:
        key = get_key()
        digest = compute_digest(key)
        signature = get_signature()
        okay = constant_time_strcmp(signature, digest)
        return okay
    except Exception as e:
        print >> sys.stderr, e.getMessage()
        return False

authenticated = authenticate()
