import com.xhaus.jyson.JysonCodec as Json
from xlrelease.HttpRequest import HttpRequest
from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement

global jiraServer, issueType

def _createRequest():
    return HttpRequest(jiraServer)

def getIssueTypes():
    request = _createRequest()
    response = request.get('/rest/api/latest/issuetype', contentType='application/json')
    issueTypes = set()
    resultTypes = []
    if response.status == 200:
        data = Json.loads(response.response)
        for item in data:
            issueTypes.add(item['name'])
    else:
        raise Exception("Failed to execute Jira Query")

    for x in issueTypes:
        resultTypes.append(LookupResultElement(x, x))

    return resultTypes

result = getIssueTypes()
