/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl;

import akka.actor.ActorSystem;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.stream.TLSClientAuth;
import com.typesafe.sslconfig.akka.AkkaSSLConfig;
import com.typesafe.sslconfig.akka.util.AkkaLoggerFactory;
import com.typesafe.sslconfig.ssl.ClientAuth;
import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import com.typesafe.sslconfig.util.LoggerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d3q!\u0003\u0006\u0011\u0002\u0007\u0005\u0011\u0003C\u0003\u0019\u0001\u0011\u0005\u0011\u0004C\u0003\u001e\u0001\u0019Ea\u0004C\u0003&\u0001\u0019Ea\u0005\u0003\u00043\u0001\u0001&Ia\r\u0005\u0006u\u0001!\t!\u0007\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006\t\u0002!\t!\u0012\u0002\u001a\t\u00164\u0017-\u001e7u'Nc5i\u001c8uKb$8I]3bi&|gN\u0003\u0002\f\u0019\u0005A1oY1mC\u0012\u001cHN\u0003\u0002\u000e\u001d\u0005!\u0001\u000e\u001e;q\u0015\u0005y\u0011\u0001B1lW\u0006\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#\u0001\u000e\u0011\u0005MY\u0012B\u0001\u000f\u0015\u0005\u0011)f.\u001b;\u0002\rML8\u000f^3n+\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u000f\u0003\u0015\t7\r^8s\u0013\t!\u0013EA\u0006BGR|'oU=ti\u0016l\u0017!C:tY\u000e{gNZ5h+\u00059\u0003C\u0001\u00151\u001b\u0005I#BA\b+\u0015\tYC&A\u0005tg2\u001cwN\u001c4jO*\u0011QFL\u0001\tif\u0004Xm]1gK*\tq&A\u0002d_6L!!M\u0015\u0003\u001b\u0005[7.Y*T\u0019\u000e{gNZ5h\u0003\rawnZ\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\u0011qGD\u0001\u0006KZ,g\u000e^\u0005\u0003sY\u0012a\u0002T8hO&tw-\u00113baR,'/A\u0011wC2LG-\u0019;f\u0003:$w+\u0019:o\u0003\n|W\u000f\u001e'p_N,7+\u001a;uS:<7/A\u0010de\u0016\fG/\u001a#fM\u0006,H\u000e^\"mS\u0016tG\u000f\u0013;uaN\u001cuN\u001c;fqR$\u0012!\u0010\t\u0003}}j\u0011AC\u0005\u0003\u0001*\u0011a\u0003\u0013;uaN\u001cuN\u001c8fGRLwN\\\"p]R,\u0007\u0010^\u0001\u0019GJ,\u0017\r^3TKJ4XM\u001d%uiB\u001c8i\u001c8uKb$HCA\u001fD\u0011\u0015)s\u00011\u0001(\u0003a\u0019'/Z1uK\u000ec\u0017.\u001a8u\u0011R$\bo]\"p]R,\u0007\u0010\u001e\u000b\u0003{\u0019CQ!\n\u0005A\u0002\u001d\u0002")
public interface DefaultSSLContextCreation {
    public ActorSystem system();

    public AkkaSSLConfig sslConfig();

    private LoggingAdapter log() {
        return this.system().log();
    }

    public static /* synthetic */ void validateAndWarnAboutLooseSettings$(DefaultSSLContextCreation $this) {
        $this.validateAndWarnAboutLooseSettings();
    }

    default public void validateAndWarnAboutLooseSettings() {
        block1: {
            String WarningAboutGlobalLoose = "This is very dangerous and may expose you to man-in-the-middle attacks. If you are forced to interact with a server that is behaving such that you must disable this setting, please disable it for a given connection instead, by configuring a specific HttpsConnectionContext for use only for the trusted target that hostname verification would have blocked.";
            if (this.sslConfig().config().loose().disableHostnameVerification()) {
                this.log().warning(new StringBuilder(150).append("Detected that Hostname Verification is disabled globally (via ssl-config's akka.ssl-config.loose.disableHostnameVerification) for the Http extension! ").append(WarningAboutGlobalLoose).toString());
            }
            if (!this.sslConfig().config().loose().disableSNI()) break block1;
            this.log().warning(new StringBuilder(140).append("Detected that Server Name Indication (SNI) is disabled globally (via ssl-config's akka.ssl-config.loose.disableSNI) for the Http extension! ").append(WarningAboutGlobalLoose).toString());
        }
    }

    public static /* synthetic */ HttpsConnectionContext createDefaultClientHttpsContext$(DefaultSSLContextCreation $this) {
        return $this.createDefaultClientHttpsContext();
    }

    default public HttpsConnectionContext createDefaultClientHttpsContext() {
        return this.createClientHttpsContext(this.sslConfig());
    }

    public static /* synthetic */ HttpsConnectionContext createServerHttpsContext$(DefaultSSLContextCreation $this, AkkaSSLConfig sslConfig) {
        return $this.createServerHttpsContext(sslConfig);
    }

    default public HttpsConnectionContext createServerHttpsContext(AkkaSSLConfig sslConfig) {
        this.log().warning("Automatic server-side configuration is not supported yet, will attempt to use client-side settings. Instead it is recommended to construct the Servers HttpsConnectionContext manually (via SSLContext).");
        return this.createClientHttpsContext(sslConfig);
    }

    public static /* synthetic */ HttpsConnectionContext createClientHttpsContext$(DefaultSSLContextCreation $this, AkkaSSLConfig sslConfig) {
        return $this.createClientHttpsContext(sslConfig);
    }

    default public HttpsConnectionContext createClientHttpsContext(AkkaSSLConfig sslConfig) {
        None$ none$;
        SSLContext sSLContext;
        SSLConfigSettings config = sslConfig.config();
        LoggingAdapter log = Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromAnyClass());
        AkkaLoggerFactory mkLogger = new AkkaLoggerFactory(this.system());
        if (sslConfig.config().default()) {
            log.debug("buildSSLContext: ssl-config.default is true, using default SSLContext");
            sslConfig.validateDefaultTrustManager(config);
            sSLContext = SSLContext.getDefault();
        } else {
            KeyManagerFactoryWrapper keyManagerFactory = sslConfig.buildKeyManagerFactory(config);
            TrustManagerFactoryWrapper trustManagerFactory = sslConfig.buildTrustManagerFactory(config);
            sSLContext = new ConfigSSLContextBuilder((LoggerFactory)mkLogger, config, keyManagerFactory, trustManagerFactory).build();
        }
        SSLContext sslContext = sSLContext;
        SSLParameters defaultParams = sslContext.getDefaultSSLParameters();
        String[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = sslConfig.configureProtocols(defaultProtocols, config);
        defaultParams.setProtocols(protocols);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        String[] cipherSuites = sslConfig.configureCipherSuites(defaultCiphers, config);
        defaultParams.setCipherSuites(cipherSuites);
        ClientAuth clientAuth = config.sslParametersConfig().clientAuth();
        if (ClientAuth.Default$.MODULE$.equals(clientAuth)) {
            none$ = None$.MODULE$;
        } else if (ClientAuth.Want$.MODULE$.equals(clientAuth)) {
            none$ = new Some((Object)TLSClientAuth.Want$.MODULE$);
        } else if (ClientAuth.Need$.MODULE$.equals(clientAuth)) {
            none$ = new Some((Object)TLSClientAuth.Need$.MODULE$);
        } else if (ClientAuth.None$.MODULE$.equals(clientAuth)) {
            none$ = new Some((Object)TLSClientAuth.None$.MODULE$);
        } else {
            throw new MatchError((Object)clientAuth);
        }
        None$ clientAuth2 = none$;
        if (!sslConfig.config().loose().disableHostnameVerification()) {
            defaultParams.setEndpointIdentificationAlgorithm("https");
        }
        return new HttpsConnectionContext(sslContext, (Option<AkkaSSLConfig>)new Some((Object)sslConfig), (Option<Seq<String>>)new Some((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cipherSuites)).toList()), (Option<Seq<String>>)new Some((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])defaultProtocols)).toList()), (Option<TLSClientAuth>)clientAuth2, (Option<SSLParameters>)new Some((Object)defaultParams));
    }

    public static void $init$(DefaultSSLContextCreation $this) {
    }
}

