/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.xltype.serialization.json.CiListJson2Reader;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001y4A\u0001C\u0005\u0001%!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u00151\u0007\u0001\"\u0003h\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015\u0019\b\u0001\"\u0011u\u0005m\t%o\u00195jm\u0016$\u0017i\u0019;jm&$\u0018\u0010T8hgN+'O^5dK*\u0011!bC\u0001\bg\u0016\u0014h/[2f\u0015\taQ\"A\u0005yYJ,G.Z1tK*\u0011abD\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001E\u0001\u0004G>l7\u0001A\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b75\t\u0011\"\u0003\u0002\u001d\u0013\tq\u0012I]2iSZ,G-Q2uSZLG/\u001f'pON\u001cVM]5bY&TXM]\u0001\u0016C\u000e$\u0018N^5us2{wMU3q_NLGo\u001c:z!\ty\"%D\u0001!\u0015\t\t3\"\u0001\u0006sKB|7/\u001b;pefL!a\t\u0011\u0003+\u0005\u001bG/\u001b<jifdun\u001a*fa>\u001c\u0018\u000e^8ss\u0006\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm\u001d\t\u0003M%j\u0011a\n\u0006\u0003Q-\t!\u0001\u001a2\n\u0005):#\u0001E!sG\"Lg/\u001a3SK2,\u0017m]3t\u0003\u0019a\u0014N\\5u}Q\u0019QFL\u0018\u0011\u0005i\u0001\u0001\"B\u000f\u0004\u0001\u0004q\u0002\"\u0002\u0013\u0004\u0001\u0004)\u0003FA\u00022!\t\u0011T(D\u00014\u0015\t!T'\u0001\u0006b]:|G/\u0019;j_:T!AN\u001c\u0002\u000f\u0019\f7\r^8ss*\u0011\u0001(O\u0001\u0006E\u0016\fgn\u001d\u0006\u0003um\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002y\u0005\u0019qN]4\n\u0005y\u001a$!C!vi><\u0018N]3e\u0003=9W\r^!di&4\u0018\u000e^=M_\u001e\u001cHCA!P!\r\u0011u)S\u0007\u0002\u0007*\u0011A)R\u0001\u0005kRLGNC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%\u0001\u0002'jgR\u0004\"AS'\u000e\u0003-S!\u0001T\u0006\u0002\r\u0011|W.Y5o\u0013\tq5J\u0001\tBGRLg/\u001b;z\u0019><WI\u001c;ss\")\u0001\u000b\u0002a\u0001#\u0006I!/\u001a7fCN,\u0017\n\u001a\t\u0003%fs!aU,\u0011\u0005Q+R\"A+\u000b\u0005Y\u000b\u0012A\u0002\u001fs_>$h(\u0003\u0002Y+\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAV\u0003\u000b\u0002\u0005;B\u0011a\fZ\u0007\u0002?*\u0011A\u0007\u0019\u0006\u0003C\n\fq!\\3ue&\u001c7O\u0003\u0002d\u001f\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002f?\n)A+[7fI\u0006)r-\u001a;BGRLg/\u001b;z\u0019><7o\u00149uS>tGC\u00015l!\r!\u0012.Q\u0005\u0003UV\u0011aa\u00149uS>t\u0007\"\u0002)\u0006\u0001\u0004\t\u0016AB3ySN$8\u000f\u0006\u0002ocB\u0011Ac\\\u0005\u0003aV\u0011qAQ8pY\u0016\fg\u000eC\u0003Q\r\u0001\u0007\u0011\u000b\u000b\u0002\u0007;\u000692/\u001a:jC2L'0Z!di&4\u0018\u000e^=M_\u001e\u001cxJ\u001a\u000b\u0003#VDQ\u0001U\u0004A\u0002EC#aB/)\u0005\u0001A\bCA=}\u001b\u0005Q(BA>:\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0003{j\u0014qaU3sm&\u001cW\r")
public class ArchivedActivityLogsService
implements ArchivedActivityLogsSerializer {
    private final ActivityLogRepository activityLogRepository;
    private final ArchivedReleases archivedReleases;

    @Timed
    public List<ActivityLogEntry> getActivityLogs(String releaseId) {
        return (List)this.getActivityLogsOption(releaseId).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(52).append("Could not find activity logs for archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    private Option<List<ActivityLogEntry>> getActivityLogsOption(String releaseId) {
        return this.archivedReleases.getActivityLogs(releaseId, this.archivedReleases.getActivityLogs$default$2()).map((Function1 & java.io.Serializable & Serializable)activityLogsJson -> {
            WriteWithoutPasswordCiConverter ciConverter = new WriteWithoutPasswordCiConverter();
            CiListReader ciReader = CiListJson2Reader.create((String)activityLogsJson);
            return ciConverter.readCis(ciReader);
        });
    }

    @Timed
    public boolean exists(String releaseId) {
        return this.archivedReleases.exists(releaseId);
    }

    @Timed
    public String serializeActivityLogsOf(String releaseId) {
        return CiSerializerHelper$.MODULE$.serialize(this.activityLogRepository.findAllLogsOf(releaseId), (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
    }

    @Autowired
    public ArchivedActivityLogsService(ActivityLogRepository activityLogRepository, ArchivedReleases archivedReleases) {
        this.activityLogRepository = activityLogRepository;
        this.archivedReleases = archivedReleases;
    }
}

