/*
 * Decompiled with CFR 0.152.
 */
package net.conjur.api.clients;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.conjur.api.AuthnProvider;
import net.conjur.api.Endpoints;
import net.conjur.api.Token;
import net.conjur.util.EncodeUriComponent;
import net.conjur.util.rs.HttpBasicAuthFilter;

public class AuthnClient
implements AuthnProvider {
    private WebTarget login;
    private WebTarget authenticate;
    private final Endpoints endpoints;
    private String apiKey;

    public AuthnClient(String username, String password, Endpoints endpoints) {
        this.endpoints = endpoints;
        this.init(username, password);
        this.apiKey = this.login();
    }

    @Override
    public Token authenticate() {
        Response res = (Response)this.authenticate.request(new String[]{"application/json"}).post(Entity.text((Object)this.apiKey), Response.class);
        this.validateResponse(res);
        return Token.fromJson((String)res.readEntity(String.class));
    }

    @Override
    public Token authenticate(boolean useCachedToken) {
        return this.authenticate();
    }

    public String login() {
        Response res = (Response)this.login.request(new String[]{"text/plain"}).get(Response.class);
        this.validateResponse(res);
        return (String)res.readEntity(String.class);
    }

    private void init(String username, String password) {
        ClientBuilder builder = (ClientBuilder)ClientBuilder.newBuilder().register((Object)new HttpBasicAuthFilter(username, password));
        Client client = builder.build();
        WebTarget root = client.target(this.endpoints.getAuthnUri());
        this.login = root.path("login");
        this.authenticate = root.path(EncodeUriComponent.encodeUriComponent(username)).path("authenticate");
    }

    private void validateResponse(Response response) {
        int status = response.getStatus();
        if (status < 200 || status >= 400) {
            String errorMessage = String.format("Error code: %d, Error message: %s", status, response.readEntity(String.class));
            throw new WebApplicationException(errorMessage, status);
        }
    }
}

