/*
 * Decompiled with CFR 0.152.
 */
package net.conjur.api.clients;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.conjur.api.Endpoints;
import net.conjur.api.ResourceProvider;
import net.conjur.api.Token;
import net.conjur.api.clients.AuthnClient;
import net.conjur.api.clients.AuthnTokenClient;
import net.conjur.util.EncodeUriComponent;
import net.conjur.util.rs.TokenAuthFilter;

public class ResourceClient
implements ResourceProvider {
    private WebTarget secrets;
    private final Endpoints endpoints;

    public ResourceClient(String username, String password, Endpoints endpoints) {
        this.endpoints = endpoints;
        this.init(username, password);
    }

    public ResourceClient(Token token, Endpoints endpoints) {
        this.endpoints = endpoints;
        this.init(token);
    }

    @Override
    public String retrieveSecret(String variableId) {
        Response response = (Response)this.secrets.path(variableId).request().get(Response.class);
        this.validateResponse(response);
        return (String)response.readEntity(String.class);
    }

    @Override
    public void addSecret(String variableId, String secret) {
        Response response = (Response)this.secrets.path(EncodeUriComponent.encodeUriComponent(variableId)).request().post(Entity.text((Object)secret), Response.class);
        this.validateResponse(response);
    }

    private Endpoints getEndpoints() {
        return this.endpoints;
    }

    private void init(String username, String password) {
        ClientBuilder builder = (ClientBuilder)ClientBuilder.newBuilder().register((Object)new TokenAuthFilter(new AuthnClient(username, password, this.endpoints)));
        Client client = builder.build();
        this.secrets = client.target(this.getEndpoints().getSecretsUri());
    }

    private void init(Token token) {
        ClientBuilder builder = (ClientBuilder)ClientBuilder.newBuilder().register((Object)new TokenAuthFilter(new AuthnTokenClient(token)));
        Client client = builder.build();
        this.secrets = client.target(this.getEndpoints().getSecretsUri());
    }

    private void validateResponse(Response response) {
        int status = response.getStatus();
        if (status < 200 || status >= 400) {
            String errorMessage = String.format("Error code: %d, Error message: %s", status, response.readEntity(String.class));
            throw new WebApplicationException(errorMessage, status);
        }
    }
}

