/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.actors;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$GetWatchedGates$;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$JobDone$;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$Tick$;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rew\u0001CA\u0001\u0003\u0007A\t!!\u0006\u0007\u0011\u0005e\u00111\u0001E\u0001\u00037Aq!!\u000b\u0002\t\u0003\tY\u0003C\u0004\u0002.\u0005!\t!a\f\t\u000f\u0005=\u0015\u0001\"\u0001\u0002\u0012\"9\u00111U\u0001\u0005\u0002\u0005E\u0005bBAS\u0003\u0011\u0005\u0011\u0011\u0013\u0004\n\u0003O\u000b\u0001\u0013aI\u0011\u0003S3\u0011\"!,\u0002!\u0003\r\n#a,\u0007\r\tU\u0011\u0001\u0011B\f\u0011)\u0011I\"\u0003BK\u0002\u0013\u0005!1\u0004\u0005\u000b\u0005cI!\u0011#Q\u0001\n\tu\u0001B\u0003B\u001a\u0013\tU\r\u0011\"\u0001\u00036!Q!1J\u0005\u0003\u0012\u0003\u0006IAa\u000e\t\u000f\u0005%\u0012\u0002\"\u0001\u0003N!I!QK\u0005\u0002\u0002\u0013\u0005!q\u000b\u0005\n\u0005;J\u0011\u0013!C\u0001\u0005?B\u0011B!\u001e\n#\u0003%\tAa\u001e\t\u0013\u00055\u0017\"!A\u0005B\u0005E\u0005\"CAh\u0013\u0005\u0005I\u0011AAi\u0011%\tI.CA\u0001\n\u0003\u0011Y\bC\u0005\u0002h&\t\t\u0011\"\u0011\u0002j\"I\u0011q_\u0005\u0002\u0002\u0013\u0005!q\u0010\u0005\n\u0005\u0007I\u0011\u0011!C!\u0005\u000bA\u0011Ba\u0002\n\u0003\u0003%\tE!\u0003\t\u0013\t\r\u0015\"!A\u0005B\t\u0015u!\u0003B{\u0003\u0005\u0005\t\u0012\u0001B|\r%\u0011)\"AA\u0001\u0012\u0003\u0011I\u0010C\u0004\u0002*m!\taa\u0002\t\u0013\t\u001d1$!A\u0005F\t%\u0001\"CB\u00057\u0005\u0005I\u0011QB\u0006\u0011%\u0019\tbGA\u0001\n\u0003\u001b\u0019\u0002C\u0005\u0003\fm\t\t\u0011\"\u0003\u0003\u000e\u00191!\u0011R\u0001A\u0005\u0017C!B!\u0007\"\u0005+\u0007I\u0011\u0001B\u000e\u0011)\u0011\t$\tB\tB\u0003%!Q\u0004\u0005\b\u0003S\tC\u0011\u0001BG\u0011%\u0011)&IA\u0001\n\u0003\u0011\u0019\nC\u0005\u0003^\u0005\n\n\u0011\"\u0001\u0003`!I\u0011QZ\u0011\u0002\u0002\u0013\u0005\u0013\u0011\u0013\u0005\n\u0003\u001f\f\u0013\u0011!C\u0001\u0003#D\u0011\"!7\"\u0003\u0003%\tAa&\t\u0013\u0005\u001d\u0018%!A\u0005B\u0005%\b\"CA|C\u0005\u0005I\u0011\u0001BN\u0011%\u0011\u0019!IA\u0001\n\u0003\u0012)\u0001C\u0005\u0003\b\u0005\n\t\u0011\"\u0011\u0003\n!I!1Q\u0011\u0002\u0002\u0013\u0005#qT\u0004\n\u0007C\t\u0011\u0011!E\u0001\u0007G1\u0011B!#\u0002\u0003\u0003E\ta!\n\t\u000f\u0005%\u0002\u0007\"\u0001\u0004.!I!q\u0001\u0019\u0002\u0002\u0013\u0015#\u0011\u0002\u0005\n\u0007\u0013\u0001\u0014\u0011!CA\u0007_A\u0011b!\u00051\u0003\u0003%\tia\r\t\u0013\t-\u0001'!A\u0005\n\t5qaBB\u001d\u0003!\u0005\u00151\u001a\u0004\b\u0003o\u000b\u0001\u0012QA]\u0011\u001d\tIc\u000eC\u0001\u0003\u0013D\u0011\"!48\u0003\u0003%\t%!%\t\u0013\u0005=w'!A\u0005\u0002\u0005E\u0007\"CAmo\u0005\u0005I\u0011AAn\u0011%\t9oNA\u0001\n\u0003\nI\u000fC\u0005\u0002x^\n\t\u0011\"\u0001\u0002z\"I!1A\u001c\u0002\u0002\u0013\u0005#Q\u0001\u0005\n\u0005\u000f9\u0014\u0011!C!\u0005\u0013A\u0011Ba\u00038\u0003\u0003%IA!\u0004\u0007\r\t\r\u0016\u0001\u0011BS\u0011)\u00119+\u0011BK\u0002\u0013\u0005!\u0011\u0016\u0005\u000b\u0005c\u000b%\u0011#Q\u0001\n\t-\u0006bBA\u0015\u0003\u0012\u0005!1\u0017\u0005\n\u0005+\n\u0015\u0011!C\u0001\u0005sC\u0011B!\u0018B#\u0003%\tA!0\t\u0013\u00055\u0017)!A\u0005B\u0005E\u0005\"CAh\u0003\u0006\u0005I\u0011AAi\u0011%\tI.QA\u0001\n\u0003\u0011\t\rC\u0005\u0002h\u0006\u000b\t\u0011\"\u0011\u0002j\"I\u0011q_!\u0002\u0002\u0013\u0005!Q\u0019\u0005\n\u0005\u0007\t\u0015\u0011!C!\u0005\u000bA\u0011Ba\u0002B\u0003\u0003%\tE!\u0003\t\u0013\t\r\u0015)!A\u0005B\t%w!CB\u001e\u0003\u0005\u0005\t\u0012AB\u001f\r%\u0011\u0019+AA\u0001\u0012\u0003\u0019y\u0004C\u0004\u0002*A#\taa\u0011\t\u0013\t\u001d\u0001+!A\u0005F\t%\u0001\"CB\u0005!\u0006\u0005I\u0011QB#\u0011%\u0019\t\u0002UA\u0001\n\u0003\u001bI\u0005C\u0005\u0003\fA\u000b\t\u0011\"\u0003\u0003\u000e\u0019I!QZ\u0001\u0011\u0002G\u0005\"qZ\u0004\b\u0007\u001f\n\u0001\u0012\u0011Bv\r\u001d\u0011)/\u0001EA\u0005ODq!!\u000bY\t\u0003\u0011I\u000fC\u0005\u0002Nb\u000b\t\u0011\"\u0011\u0002\u0012\"I\u0011q\u001a-\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u00033D\u0016\u0011!C\u0001\u0005[D\u0011\"a:Y\u0003\u0003%\t%!;\t\u0013\u0005]\b,!A\u0005\u0002\tE\b\"\u0003B\u00021\u0006\u0005I\u0011\tB\u0003\u0011%\u00119\u0001WA\u0001\n\u0003\u0012I\u0001C\u0005\u0003\fa\u000b\t\u0011\"\u0003\u0003\u000e\u001d91\u0011K\u0001\t\u0002\nmga\u0002Bj\u0003!\u0005%Q\u001b\u0005\b\u0003S\u0019G\u0011\u0001Bm\u0011%\timYA\u0001\n\u0003\n\t\nC\u0005\u0002P\u000e\f\t\u0011\"\u0001\u0002R\"I\u0011\u0011\\2\u0002\u0002\u0013\u0005!Q\u001c\u0005\n\u0003O\u001c\u0017\u0011!C!\u0003SD\u0011\"a>d\u0003\u0003%\tA!9\t\u0013\t\r1-!A\u0005B\t\u0015\u0001\"\u0003B\u0004G\u0006\u0005I\u0011\tB\u0005\u0011%\u0011YaYA\u0001\n\u0013\u0011iAB\u0004\u0002\u001a\u0005\r\u0001aa\u0015\t\u0015\u0005\rSN!A!\u0002\u0013\t)\u0005\u0003\u0006\u0002T5\u0014\t\u0011)A\u0005\u0003+B!\"!\u0018n\u0005\u0003\u0005\u000b\u0011BA0\u0011)\t9'\u001cB\u0001B\u0003%\u0011\u0011\u000e\u0005\u000b\u0003wj'\u0011!Q\u0001\n\u0005u\u0004BCAC[\n\u0005\t\u0015!\u0003\u0002\b\"9\u0011\u0011F7\u0005\u0002\r\u0005\u0004\"CB9[\n\u0007I1BB:\u0011!\u0019Y(\u001cQ\u0001\n\rU\u0004\"CB?[\u0002\u0007I\u0011BB@\u0011%\u0019I)\u001ca\u0001\n\u0013\u0019Y\t\u0003\u0005\u0004\u00166\u0004\u000b\u0015BBA\u0011\u001d\u00199*\u001cC!\u00073Cqaa'n\t\u0003\u001aI\nC\u0004\u0004\u001e6$\taa(\t\u000f\r%V\u000e\"\u0003\u0004,\"911W7\u0005\n\rU\u0006bBB`[\u0012%1\u0011Y\u0001\u0017'R,8m[$bi\u0016$U\r^3di>\u0014\u0018i\u0019;pe*!\u0011QAA\u0004\u0003\u0019\t7\r^8sg*!\u0011\u0011BA\u0006\u0003%AHN]3mK\u0006\u001cXM\u0003\u0003\u0002\u000e\u0005=\u0011!\u0003=fE&\fG.\u00192t\u0015\t\t\t\"A\u0002d_6\u001c\u0001\u0001E\u0002\u0002\u0018\u0005i!!a\u0001\u0003-M#XoY6HCR,G)\u001a;fGR|'/Q2u_J\u001c2!AA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"BAA\u0012\u0003\u0015\u00198-\u00197b\u0013\u0011\t9#!\t\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\u0011\u0011QC\u0001\u0006aJ|\u0007o\u001d\u000b\u000f\u0003c\t\t%!\u0015\u0002\\\u0005\u0015\u0014\u0011PAB!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tQ!Y2u_JT!!a\u000f\u0002\t\u0005\\7.Y\u0005\u0005\u0003\u007f\t)DA\u0003Qe>\u00048\u000fC\u0004\u0002D\r\u0001\r!!\u0012\u0002\u001dI,G.Z1tKN+'O^5dKB!\u0011qIA'\u001b\t\tIE\u0003\u0003\u0002L\u0005\u001d\u0011aB:feZL7-Z\u0005\u0005\u0003\u001f\nIE\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\t\u000f\u0005M3\u00011\u0001\u0002V\u0005YA/Y:l'\u0016\u0014h/[2f!\u0011\t9%a\u0016\n\t\u0005e\u0013\u0011\n\u0002\f)\u0006\u001c8nU3sm&\u001cW\rC\u0004\u0002^\r\u0001\r!a\u0018\u0002'I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0011\t\u0005]\u0011\u0011M\u0005\u0005\u0003G\n\u0019AA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW\rC\u0004\u0002h\r\u0001\r!!\u001b\u0002\u001b\u001d\u0014\u0018mY3EkJ\fG/[8o!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\n\u0001\u0002Z;sCRLwN\u001c\u0006\u0005\u0003g\n\t#\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u001e\u0002n\tqa)\u001b8ji\u0016$UO]1uS>t\u0007bBA>\u0007\u0001\u0007\u0011QP\u0001\u0010k:\u001cH/^2l\u0013:$XM\u001d<bYB1\u0011qDA@\u0003SJA!!!\u0002\"\t1q\n\u001d;j_:Dq!!\"\u0004\u0001\u0004\t9)A\fqe>\u001cWm]:Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB!\u0011\u0011RAF\u001b\t\t\t(\u0003\u0003\u0002\u000e\u0006E$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0011q\u0017-\\3\u0016\u0005\u0005M\u0005\u0003BAK\u0003?k!!a&\u000b\t\u0005e\u00151T\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001e\u0006!!.\u0019<b\u0013\u0011\t\t+a&\u0003\rM#(/\u001b8h\u00031\u00198\r[3ek2,g*Y7f\u0003E\u0019w.\u001c9mKRLwN\\\"p[6,g\u000e\u001e\u0002\u0019'R,8m[$bi\u0016$U\r^3di>\u0014X*Z:tC\u001e,7cA\u0004\u0002\u001e%\u001aq\u0001\u0003,\u00033M#XoY6HCR,G)\u001a;fGR|'/\u0012=uKJt\u0017\r\\\n\u0006\u0011\u0005u\u0011\u0011\u0017\t\u0004\u0003g;Q\"A\u0001*\u000b!9\u0014\"I!\u0003\u001f\u001d+GoV1uG\",GmR1uKN\u001c\u0012bNA\u000f\u0003w\u000bi,a1\u0011\u0007\u0005M\u0006\u0002\u0005\u0003\u0002 \u0005}\u0016\u0002BAa\u0003C\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002 \u0005\u0015\u0017\u0002BAd\u0003C\u0011AbU3sS\u0006d\u0017N_1cY\u0016$\"!a3\u0011\u0007\u0005Mv'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003'\u0004B!a\b\u0002V&!\u0011q[A\u0011\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti.a9\u0011\t\u0005}\u0011q\\\u0005\u0005\u0003C\f\tCA\u0002B]fD\u0011\"!:<\u0003\u0003\u0005\r!a5\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u000f\u0005\u0004\u0002n\u0006M\u0018Q\\\u0007\u0003\u0003_TA!!=\u0002\"\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0018q\u001e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002|\n\u0005\u0001\u0003BA\u0010\u0003{LA!a@\u0002\"\t9!i\\8mK\u0006t\u0007\"CAs{\u0005\u0005\t\u0019AAo\u0003!A\u0017m\u001d5D_\u0012,GCAAj\u0003!!xn\u0015;sS:<GCAAJ\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t=\u0001\u0003BAK\u0005#IAAa\u0005\u0002\u0018\n1qJ\u00196fGR\u0014Qb\u0015;beR<\u0016\r^2iS:<7#C\u0005\u0002\u001e\u0005m\u0016QXAb\u0003\u00199\u0017\r^3JIV\u0011!Q\u0004\t\u0005\u0005?\u0011iC\u0004\u0003\u0003\"\t%\u0002\u0003\u0002B\u0012\u0003Ci!A!\n\u000b\t\t\u001d\u00121C\u0001\u0007yI|w\u000e\u001e \n\t\t-\u0012\u0011E\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005&q\u0006\u0006\u0005\u0005W\t\t#A\u0004hCR,\u0017\n\u001a\u0011\u0002\u0013M$\u0018M\u001d;US6,WC\u0001B\u001c!\u0011\u0011IDa\u0012\u000e\u0005\tm\"\u0002\u0002B\u001f\u0005\u007f\tA\u0001^5nK*!!\u0011\tB\"\u0003\u0011Qw\u000eZ1\u000b\u0005\t\u0015\u0013aA8sO&!!\u0011\nB\u001e\u0005!!\u0015\r^3US6,\u0017AC:uCJ$H+[7fAQ1!q\nB)\u0005'\u00022!a-\n\u0011\u001d\u0011IB\u0004a\u0001\u0005;AqAa\r\u000f\u0001\u0004\u00119$\u0001\u0003d_BLHC\u0002B(\u00053\u0012Y\u0006C\u0005\u0003\u001a=\u0001\n\u00111\u0001\u0003\u001e!I!1G\b\u0011\u0002\u0003\u0007!qG\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tG\u000b\u0003\u0003\u001e\t\r4F\u0001B3!\u0011\u00119G!\u001d\u000e\u0005\t%$\u0002\u0002B6\u0005[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\t=\u0014\u0011E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B:\u0005S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\u001f+\t\t]\"1\r\u000b\u0005\u0003;\u0014i\bC\u0005\u0002fR\t\t\u00111\u0001\u0002TR!\u00111 BA\u0011%\t)OFA\u0001\u0002\u0004\ti.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003w\u00149\tC\u0005\u0002ff\t\t\u00111\u0001\u0002^\na1\u000b^8q/\u0006$8\r[5oONI\u0011%!\b\u0002<\u0006u\u00161\u0019\u000b\u0005\u0005\u001f\u0013\t\nE\u0002\u00024\u0006BqA!\u0007%\u0001\u0004\u0011i\u0002\u0006\u0003\u0003\u0010\nU\u0005\"\u0003B\rKA\u0005\t\u0019\u0001B\u000f)\u0011\tiN!'\t\u0013\u0005\u0015\u0018&!AA\u0002\u0005MG\u0003BA~\u0005;C\u0011\"!:,\u0003\u0003\u0005\r!!8\u0015\t\u0005m(\u0011\u0015\u0005\n\u0003Kt\u0013\u0011!a\u0001\u0003;\u0014AbV1uG\",GmR1uKN\u001c\u0012\"QA\u000f\u0003w\u000bi,a1\u0002\u000b\u001d\fG/Z:\u0016\u0005\t-\u0006\u0003\u0003B\u0010\u0005[\u0013iBa\u000e\n\t\t=&q\u0006\u0002\u0004\u001b\u0006\u0004\u0018AB4bi\u0016\u001c\b\u0005\u0006\u0003\u00036\n]\u0006cAAZ\u0003\"9!q\u0015#A\u0002\t-F\u0003\u0002B[\u0005wC\u0011Ba*F!\u0003\u0005\rAa+\u0016\u0005\t}&\u0006\u0002BV\u0005G\"B!!8\u0003D\"I\u0011Q]%\u0002\u0002\u0003\u0007\u00111\u001b\u000b\u0005\u0003w\u00149\rC\u0005\u0002f.\u000b\t\u00111\u0001\u0002^R!\u00111 Bf\u0011%\t)OTA\u0001\u0002\u0004\tiNA\rTiV\u001c7nR1uK\u0012+G/Z2u_JLe\u000e^3s]\u0006d7#\u0002,\u0002\u001e\u0005E\u0016f\u0001,d1\n9!j\u001c2E_:,7#C2\u0002\u001e\t]\u0017QXAb!\r\t\u0019L\u0016\u000b\u0003\u00057\u00042!a-d)\u0011\tiNa8\t\u0013\u0005\u0015x-!AA\u0002\u0005MG\u0003BA~\u0005GD\u0011\"!:j\u0003\u0003\u0005\r!!8\u0003\tQK7m[\n\n1\u0006u!q[A_\u0003\u0007$\"Aa;\u0011\u0007\u0005M\u0006\f\u0006\u0003\u0002^\n=\b\"CAs9\u0006\u0005\t\u0019AAj)\u0011\tYPa=\t\u0013\u0005\u0015h,!AA\u0002\u0005u\u0017!D*uCJ$x+\u0019;dQ&tw\rE\u0002\u00024n\u0019Ra\u0007B~\u0003\u0007\u0004\"B!@\u0004\u0004\tu!q\u0007B(\u001b\t\u0011yP\u0003\u0003\u0004\u0002\u0005\u0005\u0012a\u0002:v]RLW.Z\u0005\u0005\u0007\u000b\u0011yPA\tBEN$(/Y2u\rVt7\r^5p]J\"\"Aa>\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t=3QBB\b\u0011\u001d\u0011IB\ba\u0001\u0005;AqAa\r\u001f\u0001\u0004\u00119$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\rU1Q\u0004\t\u0007\u0003?\tyha\u0006\u0011\u0011\u0005}1\u0011\u0004B\u000f\u0005oIAaa\u0007\u0002\"\t1A+\u001e9mKJB\u0011ba\b \u0003\u0003\u0005\rAa\u0014\u0002\u0007a$\u0003'\u0001\u0007Ti>\u0004x+\u0019;dQ&tw\rE\u0002\u00024B\u001aR\u0001MB\u0014\u0003\u0007\u0004\u0002B!@\u0004*\tu!qR\u0005\u0005\u0007W\u0011yPA\tBEN$(/Y2u\rVt7\r^5p]F\"\"aa\t\u0015\t\t=5\u0011\u0007\u0005\b\u00053\u0019\u0004\u0019\u0001B\u000f)\u0011\u0019)da\u000e\u0011\r\u0005}\u0011q\u0010B\u000f\u0011%\u0019y\u0002NA\u0001\u0002\u0004\u0011y)A\bHKR<\u0016\r^2iK\u0012<\u0015\r^3t\u000319\u0016\r^2iK\u0012<\u0015\r^3t!\r\t\u0019\fU\n\u0006!\u000e\u0005\u00131\u0019\t\t\u0005{\u001cICa+\u00036R\u00111Q\b\u000b\u0005\u0005k\u001b9\u0005C\u0004\u0003(N\u0003\rAa+\u0015\t\r-3Q\n\t\u0007\u0003?\tyHa+\t\u0013\r}A+!AA\u0002\tU\u0016\u0001\u0002+jG.\fqAS8c\t>tWmE\u0004n\u0003;\u0019)fa\u0017\u0011\t\u0005M2qK\u0005\u0005\u00073\n)DA\u0003BGR|'\u000f\u0005\u0003\u00024\ru\u0013\u0002BB0\u0003k\u0011A\"Q2u_JdunZ4j]\u001e$bba\u0019\u0004f\r\u001d4\u0011NB6\u0007[\u001ay\u0007E\u0002\u0002\u00185Dq!a\u0011u\u0001\u0004\t)\u0005C\u0004\u0002TQ\u0004\r!!\u0016\t\u000f\u0005uC\u000f1\u0001\u0002`!9\u0011q\r;A\u0002\u0005%\u0004bBA>i\u0002\u0007\u0011Q\u0010\u0005\b\u0003\u000b#\b\u0019AAD\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/\u0006\u0002\u0004vA!\u0011\u0011RB<\u0013\u0011\u0019I(!\u001d\u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'/A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002\n1b]2iK\u0012,H.\u001a&pEV\u00111\u0011\u0011\t\u0007\u0003?\tyha!\u0011\t\u0005M2QQ\u0005\u0005\u0007\u000f\u000b)DA\u0006DC:\u001cW\r\u001c7bE2,\u0017aD:dQ\u0016$W\u000f\\3K_\n|F%Z9\u0015\t\r551\u0013\t\u0005\u0003?\u0019y)\u0003\u0003\u0004\u0012\u0006\u0005\"\u0001B+oSRD\u0011\"!:y\u0003\u0003\u0005\ra!!\u0002\u0019M\u001c\u0007.\u001a3vY\u0016TuN\u0019\u0011\u0002\u0011A\u0014Xm\u0015;beR$\"a!$\u0002\u0011A|7\u000f^*u_B\fqA]3dK&4X-\u0006\u0002\u0004\"B!11UBS\u001b\u0005i\u0017\u0002BBT\u0007/\u0012qAU3dK&4X-A\u0005p]6+7o]1hKR11\u0011UBW\u0007_CqAa*~\u0001\u0004\u0011Y\u000bC\u0004\u00042v\u0004\r!a?\u0002\u0015A\u0014xnY3tg&tw-A\u0004qe>\u001cWm]:\u0015\t\r]6Q\u0018\t\u0007\u0003\u0013\u001bIl!$\n\t\rm\u0016\u0011\u000f\u0002\u0007\rV$XO]3\t\u000f\t\u001df\u00101\u0001\u0003,\u0006aQO\\:uk\u000e\\w)\u0019;fgR!1QRBb\u0011\u001d\u00119k a\u0001\u0005WC3a`Bd!\u0011\u0019Im!6\u000e\u0005\r-'\u0002\u0002B8\u0007\u001bTAaa4\u0004R\u00069Q.\u001a;sS\u000e\u001c(\u0002BBj\u0003\u001f\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0007/\u001cYMA\u0003US6,G\r")
public class StuckGateDetectorActor
implements Actor,
ActorLogging {
    private final ReleaseService releaseService;
    private final TaskService taskService;
    private final ReleaseActorService releaseActorService;
    private final FiniteDuration graceDuration;
    private final Option<FiniteDuration> unstuckInterval;
    private final ExecutionContext processExecutionContext;
    private final ExecutionContextExecutor executionContext;
    private Option<Cancellable> scheduleJob;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public static String completionComment() {
        return StuckGateDetectorActor$.MODULE$.completionComment();
    }

    public static String scheduleName() {
        return StuckGateDetectorActor$.MODULE$.scheduleName();
    }

    public static String name() {
        return StuckGateDetectorActor$.MODULE$.name();
    }

    public static Props props(ReleaseService releaseService, TaskService taskService, ReleaseActorService releaseActorService, FiniteDuration finiteDuration, Option<FiniteDuration> option, ExecutionContext executionContext) {
        return StuckGateDetectorActor$.MODULE$.props(releaseService, taskService, releaseActorService, finiteDuration, option, executionContext);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    private ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    private Option<Cancellable> scheduleJob() {
        return this.scheduleJob;
    }

    private void scheduleJob_$eq(Option<Cancellable> x$1) {
        this.scheduleJob = x$1;
    }

    public void preStart() {
        Actor.preStart$((Actor)this);
        this.scheduleJob_$eq((Option<Cancellable>)this.unstuckInterval.map((Function1 & Serializable & scala.Serializable)duration -> {
            this.log().info(new StringBuilder(35).append("Scheduling StuckGateDetector every ").append(duration.toString()).toString());
            return this.context().system().scheduler().schedule(duration, duration, this.self(), (Object)StuckGateDetectorActor$Tick$.MODULE$, (ExecutionContext)this.executionContext(), this.self());
        }));
    }

    public void postStop() {
        this.scheduleJob().foreach((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)StuckGateDetectorActor.$anonfun$postStop$1(this, job)));
        Actor.postStop$((Actor)this);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((scala.collection.immutable.Map<String, DateTime>)Predef$.MODULE$.Map().empty(), false);
    }

    public PartialFunction<Object, BoxedUnit> com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage(scala.collection.immutable.Map<String, DateTime> gates, boolean processing) {
        return new scala.Serializable(this, gates, processing){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StuckGateDetectorActor $outer;
            private final scala.collection.immutable.Map gates$1;
            private final boolean processing$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (StuckGateDetectorActor$GetWatchedGates$.MODULE$.equals(A1)) {
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)new WatchedGates((scala.collection.immutable.Map<String, DateTime>)this.gates$1), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof StartWatching) {
                    StartWatching startWatching = (StartWatching)A1;
                    String gateId = startWatching.gateId();
                    DateTime startTime = startWatching.startTime();
                    this.$outer.log().debug("Start watching GateTask: {}", (Object)gateId);
                    this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((scala.collection.immutable.Map<String, DateTime>)this.gates$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)gateId), (Object)startTime)), this.processing$1));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof StopWatching) {
                    StopWatching stopWatching = (StopWatching)A1;
                    String gateId = stopWatching.gateId();
                    this.$outer.log().debug("Stop watching GateTask: {}", (Object)gateId);
                    this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((scala.collection.immutable.Map<String, DateTime>)((scala.collection.immutable.Map)this.gates$1.$minus((Object)gateId)), this.processing$1));
                    object = BoxedUnit.UNIT;
                } else if (StuckGateDetectorActor$Tick$.MODULE$.equals(A1) && !this.processing$1) {
                    BoxedUnit boxedUnit;
                    this.$outer.log().debug("Processing {} potentially stuck GateTasks", (Object)BoxesRunTime.boxToInteger((int)this.gates$1.size()));
                    if (this.gates$1.nonEmpty()) {
                        this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((scala.collection.immutable.Map<String, DateTime>)this.gates$1, true));
                        this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$process((scala.collection.immutable.Map<String, DateTime>)this.gates$1);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (StuckGateDetectorActor$JobDone$.MODULE$.equals(A1) && this.processing$1) {
                    this.$outer.log().debug("Done processing stuck GateTasks. Now watching {} gates", (Object)BoxesRunTime.boxToInteger((int)this.gates$1.size()));
                    this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((scala.collection.immutable.Map<String, DateTime>)this.gates$1, false));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = StuckGateDetectorActor$GetWatchedGates$.MODULE$.equals(object) ? true : (object instanceof StartWatching ? true : (object instanceof StopWatching ? true : (StuckGateDetectorActor$Tick$.MODULE$.equals(object) && !this.processing$1 ? true : StuckGateDetectorActor$JobDone$.MODULE$.equals(object) && this.processing$1)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.gates$1 = gates$1;
                this.processing$1 = processing$1;
            }
        };
    }

    public Future<BoxedUnit> com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$process(scala.collection.immutable.Map<String, DateTime> gates) {
        ExecutionContext ec = this.processExecutionContext;
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.unstuckGates(gates), (ExecutionContext)this.executionContext()).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StuckGateDetectorActor $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.log().error(A12, "Exception while completing stuck GateTasks: {}", (Object)A12.getMessage());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.executionContext()).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            StuckGateDetectorActor.$anonfun$process$2(this, x$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.executionContext());
    }

    @Timed
    private void unstuckGates(scala.collection.immutable.Map<String, DateTime> gates) {
        this.log().debug("Monitoring {} gate tasks", (Object)BoxesRunTime.boxToInteger((int)gates.size()));
        DateTime graceTime = DateTime.now().minus(this.graceDuration.toMillis());
        ResolveOptions resolveOptions = new ResolveOptionsBuilder().withEverything().withoutDecorators().build();
        scala.collection.immutable.Iterable gatesToCheck = (scala.collection.immutable.Iterable)((TraversableLike)gates.map((Function1 & Serializable & scala.Serializable)gateAndTime -> {
            Tuple2 tuple2 = gateAndTime;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String gateId = (String)tuple2._1();
            DateTime timestamp = (DateTime)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)gateId, (Object)timestamp);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$2 = (Tuple2)tuple32._1();
            String string = (String)tuple32._2();
            DateTime dateTime = (DateTime)tuple32._3();
            return new Tuple2(gateAndTime, (Object)x$2);
        }, Map$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StuckGateDetectorActor.$anonfun$unstuckGates$2(graceTime, x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            String gateId;
            Tuple2 tuple2;
            Tuple2 tuple22 = x$5;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            String string = gateId = (String)tuple2._1();
            return string;
        }, Iterable$.MODULE$.canBuildFrom());
        this.log().debug("{} gate tasks are selected after checking grace period", (Object)BoxesRunTime.boxToInteger((int)gatesToCheck.size()));
        scala.collection.immutable.Map gateAndStatus = (scala.collection.immutable.Map)gatesToCheck.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> Ids.releaseIdFrom((String)x$1)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String releaseId = (String)tuple2._1();
            scala.collection.immutable.Iterable gates = (scala.collection.immutable.Iterable)tuple2._2();
            Map<String, TaskStatus> taskStatuses = $this.taskService.getTaskStatuses(releaseId);
            scala.collection.immutable.Iterable iterable = (scala.collection.immutable.Iterable)gates.map((Function1 & Serializable & scala.Serializable)gateId -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(gateId), taskStatuses.get(Ids.getFolderlessId((String)gateId))), Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, Map$.MODULE$.canBuildFrom());
        Tuple2 gateGroups = gateAndStatus.partition((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)StuckGateDetectorActor.$anonfun$unstuckGates$7(x0$2)));
        scala.collection.immutable.Map gatesToProcess = (scala.collection.immutable.Map)gateGroups._1();
        scala.collection.immutable.Map gatesToStopWatching = (scala.collection.immutable.Map)gateGroups._2();
        gatesToStopWatching.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            StuckGateDetectorActor.$anonfun$unstuckGates$8(this, x0$3);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map gatesByRelease = gatesToProcess.keys().groupBy((Function1 & Serializable & scala.Serializable)gateId -> Ids.releaseIdFrom((String)gateId));
        this.log().debug("Processing {} releases with gate tasks", (Object)BoxesRunTime.boxToInteger((int)gatesByRelease.size()));
        gatesByRelease.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            StuckGateDetectorActor.$anonfun$unstuckGates$10(this, resolveOptions, x0$4);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$postStop$1(StuckGateDetectorActor $this, Cancellable job) {
        $this.log().info("Stopping StuckGateDetector job");
        return job.cancel();
    }

    public static final /* synthetic */ void $anonfun$process$2(StuckGateDetectorActor $this, BoxedUnit x$1) {
        package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)StuckGateDetectorActor$JobDone$.MODULE$, $this.self());
    }

    public static final /* synthetic */ boolean $anonfun$unstuckGates$2(DateTime graceTime$1, Tuple2 x$4) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x$4;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        DateTime timestamp = (DateTime)tuple2._2();
        boolean bl = timestamp.isBefore((ReadableInstant)graceTime$1);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$unstuckGates$7(Tuple2 x0$2) {
        TaskStatus taskStatus;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TaskStatus taskStatus2 = taskStatus = (TaskStatus)tuple2._2();
        TaskStatus taskStatus3 = TaskStatus.IN_PROGRESS;
        boolean bl = !(taskStatus2 != null ? !taskStatus2.equals(taskStatus3) : taskStatus3 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$unstuckGates$8(StuckGateDetectorActor $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String gateId = (String)tuple2._1();
        TaskStatus status = (TaskStatus)tuple2._2();
        $this.log().debug("Stop watching {} (status: {})", (Object)gateId, (Object)status);
        package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new StopWatching(gateId), $this.self());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$unstuckGates$11(StuckGateDetectorActor $this, Release release$1, String gateId) {
        GateTask gateTask = (GateTask)release$1.getTask(gateId);
        $this.log().debug(new StringBuilder(15).append("       status: ").append(gateTask.getStatus()).toString());
        $this.log().debug(new StringBuilder(15).append("   conditions: ").append(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getConditions()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isChecked()))).toString());
        $this.log().debug(new StringBuilder(15).append(" dependencies: ").append(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getDependencies()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDone()))).toString());
        if ((((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getConditions()).asScala()).nonEmpty() || ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getDependencies()).asScala()).nonEmpty()) && ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getConditions()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isChecked())) && ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getDependencies()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isDone()))) {
            $this.log().info("Completing stuck gate {}", (Object)gateId);
            $this.releaseActorService.markTaskAsDoneAsync(TaskStatus.COMPLETED, gateId, StuckGateDetectorActor$.MODULE$.completionComment(), User.SYSTEM);
            package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new StopWatching(gateId), $this.self());
        } else {
            $this.log().debug("Conditions not met for {} (in progress)", (Object)gateId);
        }
    }

    public static final /* synthetic */ void $anonfun$unstuckGates$10(StuckGateDetectorActor $this, ResolveOptions resolveOptions$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String releaseId = (String)tuple2._1();
        Iterable gateTaskIds = (Iterable)tuple2._2();
        $this.log().debug("Loading {}", (Object)releaseId);
        Release release = $this.releaseService.findById(releaseId, resolveOptions$1);
        gateTaskIds.foreach((Function1 & Serializable & scala.Serializable)gateId -> {
            StuckGateDetectorActor.$anonfun$unstuckGates$11($this, release, gateId);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public StuckGateDetectorActor(ReleaseService releaseService, TaskService taskService, ReleaseActorService releaseActorService, FiniteDuration graceDuration, Option<FiniteDuration> unstuckInterval, ExecutionContext processExecutionContext) {
        this.releaseService = releaseService;
        this.taskService = taskService;
        this.releaseActorService = releaseActorService;
        this.graceDuration = graceDuration;
        this.unstuckInterval = unstuckInterval;
        this.processExecutionContext = processExecutionContext;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.executionContext = this.context().system().dispatcher();
        this.scheduleJob = None$.MODULE$;
    }

    public static class StartWatching
    implements StuckGateDetectorExternal,
    Product,
    scala.Serializable {
        private final String gateId;
        private final DateTime startTime;

        public String gateId() {
            return this.gateId;
        }

        public DateTime startTime() {
            return this.startTime;
        }

        public StartWatching copy(String gateId, DateTime startTime) {
            return new StartWatching(gateId, startTime);
        }

        public String copy$default$1() {
            return this.gateId();
        }

        public DateTime copy$default$2() {
            return this.startTime();
        }

        public String productPrefix() {
            return "StartWatching";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = this.gateId();
                    break;
                }
                case 1: {
                    string = this.startTime();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StartWatching;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StartWatching)) return false;
            boolean bl = true;
            if (!bl) return false;
            StartWatching startWatching = (StartWatching)x$1;
            String string = this.gateId();
            String string2 = startWatching.gateId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            DateTime dateTime = this.startTime();
            DateTime dateTime2 = startWatching.startTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            if (!startWatching.canEqual(this)) return false;
            return true;
        }

        public StartWatching(String gateId, DateTime startTime) {
            this.gateId = gateId;
            this.startTime = startTime;
            Product.$init$((Product)this);
        }
    }

    public static class StopWatching
    implements StuckGateDetectorExternal,
    Product,
    scala.Serializable {
        private final String gateId;

        public String gateId() {
            return this.gateId;
        }

        public StopWatching copy(String gateId) {
            return new StopWatching(gateId);
        }

        public String copy$default$1() {
            return this.gateId();
        }

        public String productPrefix() {
            return "StopWatching";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.gateId();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StopWatching;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StopWatching)) return false;
            boolean bl = true;
            if (!bl) return false;
            StopWatching stopWatching = (StopWatching)x$1;
            String string = this.gateId();
            String string2 = stopWatching.gateId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!stopWatching.canEqual(this)) return false;
            return true;
        }

        public StopWatching(String gateId) {
            this.gateId = gateId;
            Product.$init$((Product)this);
        }
    }

    public static interface StuckGateDetectorExternal
    extends StuckGateDetectorMessage {
    }

    public static interface StuckGateDetectorInternal
    extends StuckGateDetectorMessage {
    }

    public static interface StuckGateDetectorMessage {
    }

    public static class WatchedGates
    implements StuckGateDetectorExternal,
    Product,
    scala.Serializable {
        private final scala.collection.immutable.Map<String, DateTime> gates;

        public scala.collection.immutable.Map<String, DateTime> gates() {
            return this.gates;
        }

        public WatchedGates copy(scala.collection.immutable.Map<String, DateTime> gates) {
            return new WatchedGates(gates);
        }

        public scala.collection.immutable.Map<String, DateTime> copy$default$1() {
            return this.gates();
        }

        public String productPrefix() {
            return "WatchedGates";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.gates();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof WatchedGates;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof WatchedGates)) return false;
            boolean bl = true;
            if (!bl) return false;
            WatchedGates watchedGates = (WatchedGates)x$1;
            scala.collection.immutable.Map<String, DateTime> map = this.gates();
            scala.collection.immutable.Map<String, DateTime> map2 = watchedGates.gates();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!watchedGates.canEqual(this)) return false;
            return true;
        }

        public WatchedGates(scala.collection.immutable.Map<String, DateTime> gates) {
            this.gates = gates;
            Product.$init$((Product)this);
        }
    }
}

