/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.ExportHook;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.SharedConfigurationService;
import com.xebialabs.xlrelease.service.SharedConfigurationStatusService;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;
import com.xebialabs.xlrelease.views.ConfigurationView;
import com.xebialabs.xlrelease.views.SharedConfigurationStatusResponse;
import com.xebialabs.xlrelease.views.converters.ConfigurationItemViewConverter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/configurations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class SharedConfigurationResource {
    private SharedConfigurationService sharedConfigurationService;
    private PermissionChecker permissions;
    private ConfigurationItemViewConverter configurationViewConverter;
    private SharedConfigurationStatusService sharedConfigurationStatusService;

    @Autowired
    public SharedConfigurationResource(SharedConfigurationService sharedConfigurationService, PermissionChecker permissions, ConfigurationItemViewConverter configurationViewConverter, SharedConfigurationStatusService sharedConfigurationStatusService) {
        this.sharedConfigurationService = sharedConfigurationService;
        this.permissions = permissions;
        this.sharedConfigurationStatusService = sharedConfigurationStatusService;
        this.configurationViewConverter = configurationViewConverter;
    }

    @GET
    @Timed
    @Path(value="descriptors")
    public List<Descriptor> getDescriptors() {
        return this.sharedConfigurationService.findAllConfigurationDescriptors();
    }

    @GET
    public List<ConfigurationView> getInstances(@QueryParam(value="anonymized") boolean anonymized) {
        if (anonymized) {
            return this.sharedConfigurationService.findAll().stream().map(this.configurationViewConverter::toAnonymizedView).collect(Collectors.toList());
        }
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.sharedConfigurationService.findAll().stream().map(this.configurationViewConverter::toView).collect(Collectors.toList());
    }

    @POST
    public ConfigurationView addInstance(ConfigurationView configurationView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.sharedConfigurationService.create(this.configurationViewConverter.fromView(configurationView));
        return this.configurationViewConverter.toView(configuration);
    }

    @GET
    @Timed
    @Path(value="{configurationInstanceId:((?!descriptors).)*}")
    public ConfigurationView getInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.sharedConfigurationService.findById(configurationInstanceId);
        return this.configurationViewConverter.toView(configuration);
    }

    @PUT
    @Timed
    @Path(value="{configurationInstanceId:((?!descriptors).)*}")
    public ConfigurationView updateInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId, ConfigurationView configurationView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.sharedConfigurationService.update(configurationInstanceId, this.configurationViewConverter.fromView(configurationView));
        return this.configurationViewConverter.toView(configuration);
    }

    @DELETE
    @Timed
    @Path(value="{configurationInstanceId}")
    public void deleteInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.sharedConfigurationService.delete(configurationInstanceId);
    }

    @Timed
    @Path(value="status")
    @POST
    public SharedConfigurationStatusResponse checkConnection(ConfigurationView configurationView) {
        Configuration configuration = this.configurationViewConverter.fromView(configurationView);
        String id = configuration.getId();
        Optional<ConfigurationItem> original = id == null ? Optional.empty() : Optional.of(this.sharedConfigurationService.findById(id));
        PasswordVerificationUtils.replacePasswordPropertiesInCiIfNeededJava(original, (ConfigurationItem)configuration);
        SharedConfigurationStatusResponse response = this.sharedConfigurationStatusService.checkStatus(configuration);
        this.fixRestEasyProviders();
        return response;
    }

    @Timed
    @Path(value="hasScript")
    @POST
    public Boolean hasScript(ConfigurationView configurationView) {
        Configuration configuration = this.configurationViewConverter.fromView(configurationView);
        return !(configuration instanceof ExportHook) && this.sharedConfigurationStatusService.hasScript(configuration);
    }

    private void fixRestEasyProviders() {
        if (ResteasyProviderFactory.getContextDataMap().isEmpty()) {
            ResteasyProviderFactory.getContextDataMap().put(Providers.class, new ResteasyProviderFactory());
        }
    }
}

