/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.customscript;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.BaseScriptTaskExecutor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.script.CustomScriptTaskResult;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.script.SuccessCustomScriptTaskResult;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomScriptTaskExecutor
extends BaseScriptTaskExecutor<CustomScriptTask> {
    public static final Logger logger = LoggerFactory.getLogger(CustomScriptTaskExecutor.class);
    private Scheduler scheduler;
    private XlrConfig xlrConfig;
    private final TaskRepository taskRepository;

    @Autowired
    public CustomScriptTaskExecutor(TaskRepository taskRepository, ReleaseActorService releaseActorService, Collection<? extends ScriptService> scriptServices, Scheduler scheduler, XlrConfig xlrConfig) {
        super(releaseActorService, scriptServices);
        this.scheduler = scheduler;
        this.taskRepository = taskRepository;
        this.xlrConfig = xlrConfig;
    }

    @Override
    public Class<CustomScriptTask> getTaskClass() {
        return CustomScriptTask.class;
    }

    @Override
    public void execute(CustomScriptTask task, SensitiveValueScrubber scrubber) {
        this.execute(task, null, scrubber);
    }

    @VisibleForTesting
    void execute(CustomScriptTask task, String lastExecutionId, SensitiveValueScrubber scrubber) {
        if (!task.isInProgress() && !task.isAbortScriptInProgress()) {
            logger.info("Not executing script of task {} as it is {}", (Object)task, (Object)task.getStatus());
            return;
        }
        if (lastExecutionId != null && !task.isStillExecutingScript(lastExecutionId)) {
            logger.info("Not executing script of task {} as the execution ID has changed from the last polling from {} to {}. Probably the task was aborted and immediately retried.", new Object[]{task, lastExecutionId, task.getExecutionId()});
            return;
        }
        this.fixVariableMapping(task);
        this.scriptServiceFor((BaseScriptTask)task).executeCustomScriptTask(task, scrubber).thenAccept(r -> this.scheduleOrSave(task, scrubber, (CustomScriptTaskResult)r));
    }

    @VisibleForTesting
    void scheduleOrSave(CustomScriptTask task, SensitiveValueScrubber scrubber, CustomScriptTaskResult r) {
        if (r instanceof SuccessCustomScriptTaskResult) {
            DefaultScriptService.CustomScriptTaskResults results = ((SuccessCustomScriptTaskResult)r).results();
            String nextScriptPath = results.getNextScriptPath();
            if (nextScriptPath != null) {
                logger.trace("Scheduling next script path: {}", (Object)nextScriptPath);
                this.releaseActorService.saveCustomScriptResults(r.taskId(), results);
                this.scheduler.scheduleOnce(() -> {
                    CustomScriptTask currentTask = (CustomScriptTask)this.taskRepository.findById(task.getId());
                    this.execute(currentTask, currentTask.getExecutionId(), scrubber);
                }, task.getInterval() != null ? (long)(task.getInterval() * 1000) : this.xlrConfig.durations_customScriptTaskScheduleInterval().toMillis(), TimeUnit.MILLISECONDS);
            } else {
                r.save(this.releaseActorService);
            }
        } else {
            r.save(this.releaseActorService);
        }
    }

    private void fixVariableMapping(CustomScriptTask task) {
        Collection outputProperties = task.getPythonScript().getOutputProperties();
        boolean updated = false;
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            String fqPropertyName = "pythonScript." + propertyName;
            Object propertyValue = task.getPythonScript().getProperty(propertyName);
            if (!(propertyValue instanceof String) || !VariableHelper.containsOnlyVariable((String)((String)propertyValue)) || task.getVariableMapping().containsKey(fqPropertyName)) continue;
            logger.debug("adding variable pre 5.0 [{}] with value [{}]", (Object)fqPropertyName, propertyValue);
            task.getVariableMapping().put(fqPropertyName, (String)propertyValue);
            updated = true;
        }
        if (updated) {
            this.taskRepository.update((Task)task);
        }
    }
}

