/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.ScriptValueProviderConfiguration;
import com.xebialabs.xlrelease.script.CustomScriptTaskResult;
import com.xebialabs.xlrelease.script.FacetCheckResult;
import com.xebialabs.xlrelease.script.FailureCustomScriptTaskResult;
import com.xebialabs.xlrelease.script.FailureFacetCheckResult;
import com.xebialabs.xlrelease.script.FailureScriptTaskResult;
import com.xebialabs.xlrelease.script.InvalidPreconditionResult;
import com.xebialabs.xlrelease.script.PreconditionResult;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.script.ScriptTaskResult;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import scala.Option;

@Component
public class UnsupportedScriptService
implements ScriptService {
    private static final Logger logger = LoggerFactory.getLogger(UnsupportedScriptService.class);
    public static final String UNSUPPORTED_ENGINE = "unsupported_engine";

    @Override
    public Object executeScript(XlrScriptContext scriptContext) {
        throw new UnsupportedOperationException("Script execution is not implemented");
    }

    @Override
    public CompletableFuture<ScriptTaskResult> executeScriptTask(ResolvableScriptTask task, SensitiveValueScrubber scrubber) {
        return CompletableFuture.completedFuture(new FailureScriptTaskResult(task.getId(), task.getExecutionId(), this.onException(task.getId()), (Option<String>)Option.empty(), null, null));
    }

    @Override
    public CompletableFuture<CustomScriptTaskResult> executeCustomScriptTask(CustomScriptTask task, SensitiveValueScrubber scrubber) {
        return CompletableFuture.completedFuture(new FailureCustomScriptTaskResult(task.getId(), task.getExecutionId(), this.onException(task.getId()), (Option<String>)Option.empty(), null));
    }

    @Override
    public CompletableFuture<PreconditionResult> executePrecondition(Task task) {
        return CompletableFuture.completedFuture(new InvalidPreconditionResult(task.getId(), task.getExecutionId(), this.onException(task.getId()), (Option<String>)Option.empty(), null));
    }

    @Override
    public CompletableFuture<FacetCheckResult> executeFacetCheck(Task task) {
        return CompletableFuture.completedFuture(new FailureFacetCheckResult(task.getId(), task.getExecutionId(), this.onException(task.getId()), (Option<String>)Option.empty(), null));
    }

    @Override
    public CompletableFuture<Object> executeFailureHandler(Task task, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("executeFailureHandler is not implemented");
    }

    @Override
    public Collection<Object> executeScriptValueProvider(ScriptValueProviderConfiguration valueProviderConfiguration) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String engine() {
        return UNSUPPORTED_ENGINE;
    }

    @Override
    public boolean accepts(String filename) {
        return false;
    }

    private String onException(String taskId) {
        String errorMsg = String.format("Unable to execute '%s', unsupported script engine", taskId);
        logger.warn(errorMsg);
        return errorMsg;
    }
}

