/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PasswordVerificationUtils$ {
    public static PasswordVerificationUtils$ MODULE$;
    private final boolean acceptEncryptedSecrets;
    private final PasswordEncrypter passwordEncrypter;
    private final Pattern maskPattern;
    private final String PASSWORD_MASK;

    static {
        new PasswordVerificationUtils$();
    }

    private boolean acceptEncryptedSecrets() {
        return this.acceptEncryptedSecrets;
    }

    private PasswordEncrypter passwordEncrypter() {
        return this.passwordEncrypter;
    }

    private Pattern maskPattern() {
        return this.maskPattern;
    }

    public String PASSWORD_MASK() {
        return this.PASSWORD_MASK;
    }

    public boolean isValueEncrypted(String value) {
        return !Strings.isNullOrEmpty((String)value) && this.passwordEncrypter().isEncodedAndDecryptable(value);
    }

    public boolean isMaskedPassword(String value) {
        return !Strings.isNullOrEmpty((String)value) && this.maskPattern().matcher(value).matches();
    }

    public String replacePasswordIfNeeded(String original, String updated) {
        if (!this.acceptEncryptedSecrets()) {
            String string = original;
            String string2 = updated;
            if ((string == null ? string2 != null : !string.equals(string2)) && this.isValueEncrypted(updated)) {
                throw new IllegalArgumentException("Could not accept encrypted password");
            }
        }
        return this.isMaskedPassword(updated) ? original : updated;
    }

    public String replacePasswordIfNeeded(Object original, Object updated) {
        String originalValue = original == null ? null : (String)original;
        String updatedValue = updated == null ? null : (String)updated;
        return this.replacePasswordIfNeeded(originalValue, updatedValue);
    }

    public void replacePasswordPropertiesInCiIfNeededJava(Optional<ConfigurationItem> original, ConfigurationItem updated) {
        None$ ci = original.isPresent() ? new Some((Object)original.get()) : None$.MODULE$;
        this.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)ci, updated);
    }

    public void replacePasswordPropertiesInCiIfNeeded(Option<ConfigurationItem> original, ConfigurationItem updated) {
        block4: {
            None$ none$;
            if (updated == null) break block4;
            List externalReferences = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)updated)).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Set$.MODULE$.canBuildFrom())).toList();
            Option<ConfigurationItem> option = original;
            if (option instanceof Some) {
                Some some = (Some)option;
                ConfigurationItem ci = (ConfigurationItem)some.value();
                none$ = new Some(JavaConverters$.MODULE$.asScalaBufferConverter(CiHelper.getNestedCis((ConfigurationItem)ci)).asScala());
            } else if (None$.MODULE$.equals(option)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            None$ originalNestedCis = none$;
            Buffer updatedNestedCis = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(CiHelper.getNestedCis((ConfigurationItem)updated)).asScala();
            ((IterableLike)updatedNestedCis.filterNot((Function1 & Serializable & scala.Serializable)nestedCi -> BoxesRunTime.boxToBoolean((boolean)PasswordVerificationUtils$.$anonfun$replacePasswordPropertiesInCiIfNeeded$2(externalReferences, nestedCi)))).foreach(arg_0 -> PasswordVerificationUtils$.$anonfun$replacePasswordPropertiesInCiIfNeeded$3$adapted((Option)originalNestedCis, externalReferences, arg_0));
            this.replacePasswordInDirectCiRefs(original, updated, (List<String>)externalReferences);
        }
    }

    private void replacePasswordInDirectCiRefs(Option<ConfigurationItem> original, ConfigurationItem updated, List<String> externalReferences) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(updated.getType().getDescriptor().getPropertyDescriptors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PasswordVerificationUtils$.$anonfun$replacePasswordInDirectCiRefs$1(original, updated, externalReferences, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void replacePasswordPropertiesIfNeeded(List<ConfigurationItem> updated, List<String> externalReferences) {
        updated.foreach((Function1 & Serializable & scala.Serializable)ci -> {
            PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesIfNeeded((Option<ConfigurationItem>)None$.MODULE$, ci, (List<String>)externalReferences);
            return BoxedUnit.UNIT;
        });
    }

    private void replacePasswordPropertiesIfNeeded(Option<Map<String, ConfigurationItem>> original, Map<String, ConfigurationItem> updated, List<String> externalReferences) {
        updated.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PasswordVerificationUtils$.$anonfun$replacePasswordPropertiesIfNeeded$2(original, externalReferences, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void replacePasswordPropertiesIfNeeded(Option<ConfigurationItem> original, ConfigurationItem updated, List<String> externalReferences) {
        block0: {
            if (updated == null || updated.getId() != null && externalReferences.contains((Object)updated.getId())) break block0;
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(updated.getType().getDescriptor().getPropertyDescriptors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)pd -> {
                PasswordVerificationUtils$.$anonfun$replacePasswordPropertiesIfNeeded$3(updated, original, pd);
                return BoxedUnit.UNIT;
            });
        }
    }

    private PasswordVerificationUtils.ConfigurationItemExtension ConfigurationItemExtension(Collection<ConfigurationItem> cis) {
        return new PasswordVerificationUtils.ConfigurationItemExtension(cis);
    }

    public static final /* synthetic */ boolean $anonfun$replacePasswordPropertiesInCiIfNeeded$2(List externalReferences$1, ConfigurationItem nestedCi) {
        return nestedCi.getId() != null && externalReferences$1.contains((Object)nestedCi.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replacePasswordPropertiesInCiIfNeeded$4(ConfigurationItem nestedCi$1, ConfigurationItem t) {
        Type type = t.getType();
        Type type2 = nestedCi$1.getType();
        if (type == null) {
            if (type2 != null) {
                return false;
            }
        } else if (!type.equals(type2)) return false;
        String string = t.getId();
        String string2 = nestedCi$1.getId();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ void $anonfun$replacePasswordPropertiesInCiIfNeeded$3(Option originalNestedCis$1, List externalReferences$1, ConfigurationItem nestedCi) {
        None$ none$;
        Option option = originalNestedCis$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            Buffer cis = (Buffer)some.value();
            none$ = Strings.isNullOrEmpty((String)nestedCi.getId()) ? None$.MODULE$ : cis.find((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)PasswordVerificationUtils$.$anonfun$replacePasswordPropertiesInCiIfNeeded$4(nestedCi, t)));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        MODULE$.replacePasswordPropertiesIfNeeded((Option<ConfigurationItem>)none$, nestedCi, (List<String>)externalReferences$1);
    }

    public static final /* synthetic */ void $anonfun$replacePasswordInDirectCiRefs$1(Option original$1, ConfigurationItem updated$1, List externalReferences$2, PropertyDescriptor x0$1) {
        PropertyDescriptor propertyDescriptor = x0$1;
        PropertyKind propertyKind = propertyDescriptor.getKind();
        PropertyKind propertyKind2 = PropertyKind.CI;
        if (!(propertyKind != null ? !propertyKind.equals(propertyKind2) : propertyKind2 != null)) {
            None$ none$;
            Option option = original$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                ConfigurationItem configurationItem = (ConfigurationItem)some.value();
                none$ = new Some((Object)((ConfigurationItem)configurationItem.getProperty(propertyDescriptor.getName())));
            } else if (None$.MODULE$.equals(option)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            MODULE$.replacePasswordPropertiesIfNeeded((Option<ConfigurationItem>)none$, (ConfigurationItem)updated$1.getProperty(propertyDescriptor.getName()), (List<String>)externalReferences$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            PropertyKind propertyKind3 = propertyDescriptor.getKind();
            PropertyKind propertyKind4 = PropertyKind.SET_OF_CI;
            if (!(propertyKind3 != null ? !propertyKind3.equals(propertyKind4) : propertyKind4 != null)) {
                None$ none$;
                Set updatedCis = (Set)updated$1.getProperty(propertyDescriptor.getName());
                Option option = original$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ConfigurationItem configurationItem = (ConfigurationItem)some.value();
                    none$ = new Some(MODULE$.ConfigurationItemExtension((Set)configurationItem.getProperty(propertyDescriptor.getName())).asScalaMap());
                } else if (None$.MODULE$.equals(option)) {
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError((Object)option);
                }
                MODULE$.replacePasswordPropertiesIfNeeded((Option<Map<String, ConfigurationItem>>)none$, MODULE$.ConfigurationItemExtension(updatedCis).asScalaMap(), (List<String>)externalReferences$2);
                MODULE$.replacePasswordPropertiesIfNeeded(MODULE$.ConfigurationItemExtension(updatedCis).getNewCiList(), (List<String>)externalReferences$2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                PropertyKind propertyKind5 = propertyDescriptor.getKind();
                PropertyKind propertyKind6 = PropertyKind.LIST_OF_CI;
                if (!(propertyKind5 != null ? !propertyKind5.equals(propertyKind6) : propertyKind6 != null)) {
                    None$ none$;
                    java.util.List updatedCis = (java.util.List)updated$1.getProperty(propertyDescriptor.getName());
                    Option option = original$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        ConfigurationItem configurationItem = (ConfigurationItem)some.value();
                        none$ = new Some(MODULE$.ConfigurationItemExtension((java.util.List)configurationItem.getProperty(propertyDescriptor.getName())).asScalaMap());
                    } else if (None$.MODULE$.equals(option)) {
                        none$ = None$.MODULE$;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    MODULE$.replacePasswordPropertiesIfNeeded((Option<Map<String, ConfigurationItem>>)none$, MODULE$.ConfigurationItemExtension(updatedCis).asScalaMap(), (List<String>)externalReferences$2);
                    MODULE$.replacePasswordPropertiesIfNeeded(MODULE$.ConfigurationItemExtension(updatedCis).getNewCiList(), (List<String>)externalReferences$2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$replacePasswordPropertiesIfNeeded$2(Option original$2, List externalReferences$4, Tuple2 x0$1) {
        None$ none$;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String name = (String)tuple2._1();
        ConfigurationItem ci = (ConfigurationItem)tuple2._2();
        Option option = original$2;
        if (option instanceof Some) {
            Some some = (Some)option;
            Map configurationItem = (Map)some.value();
            none$ = configurationItem.get((Object)name);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            none$ = None$.MODULE$;
        }
        MODULE$.replacePasswordPropertiesIfNeeded((Option<ConfigurationItem>)none$, ci, (List<String>)externalReferences$4);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isStringPassword$1(PropertyDescriptor pd) {
        if (!pd.isPassword()) return false;
        PropertyKind propertyKind = pd.getKind();
        PropertyKind propertyKind2 = PropertyKind.STRING;
        if (propertyKind != null) {
            if (!propertyKind.equals(propertyKind2)) return false;
            return true;
        }
        if (propertyKind2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$replacePasswordPropertiesIfNeeded$3(ConfigurationItem updated$2, Option original$3, PropertyDescriptor pd) {
        block4: {
            String string;
            if (!PasswordVerificationUtils$.isStringPassword$1(pd)) break block4;
            String string2 = pd.getName();
            Option option = original$3;
            if (option instanceof Some) {
                Some some = (Some)option;
                ConfigurationItem ci = (ConfigurationItem)some.value();
                PropertyDescriptor originalPd = ci.getType().getDescriptor().getPropertyDescriptor(pd.getName());
                string = originalPd != null && PasswordVerificationUtils$.isStringPassword$1(originalPd) ? (String)ci.getProperty(pd.getName()) : null;
            } else if (None$.MODULE$.equals(option)) {
                string = null;
            } else {
                throw new MatchError((Object)option);
            }
            updated$2.setProperty(string2, (Object)MODULE$.replacePasswordIfNeeded(string, (String)updated$2.getProperty(pd.getName())));
        }
    }

    private PasswordVerificationUtils$() {
        MODULE$ = this;
        this.acceptEncryptedSecrets = XlrConfig$.MODULE$.getInstance().security().acceptEncryptedSecrets().enabled();
        this.passwordEncrypter = PasswordEncrypter.getInstance();
        this.maskPattern = Pattern.compile("^[*]+$");
        this.PASSWORD_MASK = "********";
    }

    public static final /* synthetic */ Object $anonfun$replacePasswordPropertiesInCiIfNeeded$3$adapted(Option originalNestedCis$1, List externalReferences$1, ConfigurationItem nestedCi) {
        PasswordVerificationUtils$.$anonfun$replacePasswordPropertiesInCiIfNeeded$3(originalNestedCis$1, externalReferences$1, nestedCi);
        return BoxedUnit.UNIT;
    }
}

