/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.views.VariableOrDependencyView;

public class DependencyView {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private VariableOrDependencyView variableOrTarget;
    private boolean resolved;
    private boolean archived;

    public DependencyView() {
    }

    public DependencyView(Dependency dependency) {
        this.id = dependency.getId();
        this.variableOrTarget = new VariableOrDependencyView(dependency);
        this.resolved = dependency.isDone();
        this.archived = dependency.isArchived();
    }

    public String getId() {
        return this.id;
    }

    public String toTargetIdOrVariable() {
        return this.hasFixedTarget() ? this.toTargetId() : this.variableOrTarget.getVariable();
    }

    public String toTargetId() {
        return this.variableOrTarget.getValue().toNodeId();
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public VariableOrDependencyView getVariableOrTarget() {
        return this.variableOrTarget;
    }

    public void setVariableOrTarget(VariableOrDependencyView variableOrTarget) {
        this.variableOrTarget = variableOrTarget;
    }

    public boolean hasFixedTarget() {
        return this.getVariableOrTarget().getValue() != null;
    }
}

