/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import java.util.Date;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class DateVariable
extends Variable.VariableWithValue<Date> {
    @PublicApiMember
    @Property(required=false, description="Value of the release variable or default value of the template variable")
    protected Date value;

    @Override
    @PublicApiMember
    public Date getValue() {
        return this.value;
    }

    @Override
    public Date getEmptyValue() {
        return null;
    }

    @Override
    @PublicApiMember
    public void setValue(Date value) {
        this.value = value;
    }

    @Override
    public void setUntypedValue(Object newValue) throws IllegalArgumentException {
        if (newValue instanceof Date) {
            this.setValue((Date)newValue);
        } else if (newValue instanceof Long || newValue instanceof Integer) {
            try {
                this.setValue(new Date(((Number)newValue).longValue()));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("Cannot set instance of %s into date variable value: %s", newValue.getClass().getSimpleName(), newValue));
            }
        } else if (newValue instanceof String) {
            this.setValue(DateVariableUtils.parseDate((String)newValue));
        } else if (newValue == null) {
            this.setValue(this.getEmptyValue());
        } else {
            throw new IllegalArgumentException(String.format("Cannot set instance of %s into date variable value: %s", newValue.getClass().getSimpleName(), newValue));
        }
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    @Override
    public String getValueAsString() {
        return this.isValueEmpty() ? this.getEmptyValueAsString() : DateVariableUtils.printDate(this.value);
    }

    @Override
    public String getEmptyValueAsString() {
        return "";
    }

    @Override
    public boolean isValueAssignableFrom(Object value) {
        return value instanceof Date;
    }
}

