/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.activity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.activity.ActivityOps;
import com.xebialabs.xlrelease.delivery.events.DeliveryEvent;
import com.xebialabs.xlrelease.domain.ActivityCategory;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public enum DeliveryActivity implements ActivityOps
{
    PATTERN_CREATED("Created pattern '%s'", ActivityCategory.LIFECYCLE),
    PATTERN_UPDATED("Updated pattern '%s'", ActivityCategory.DELIVERY_EDIT),
    PATTERN_DELETED("Deleted pattern '%s'", ActivityCategory.LIFECYCLE),
    DELIVERY_CREATED("Created delivery '%s'", ActivityCategory.LIFECYCLE),
    DELIVERY_UPDATED("Updated delivery '%s'", ActivityCategory.DELIVERY_EDIT),
    DELIVERY_DELETED("Deleted delivery '%s'", ActivityCategory.LIFECYCLE),
    DELIVERY_COMPLETED("Completed delivery '%s'", ActivityCategory.LIFECYCLE),
    STAGE_CREATED("Created stage '%s'", ActivityCategory.DELIVERY_EDIT),
    STAGE_UPDATED("Updated stage '%s'", ActivityCategory.DELIVERY_EDIT),
    STAGE_REMOVED("Removed stage '%s'", ActivityCategory.DELIVERY_EDIT, ActivityCategory.IMPORTANT),
    STAGE_REOPENED("Reopened stage '%s'", ActivityCategory.LIFECYCLE),
    STAGE_STARTED("Started stage '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    STAGE_COMPLETED("Completed stage '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    ITEM_CREATED("Created tracked item '%s'", ActivityCategory.DELIVERY_EDIT),
    ITEM_RENAMED("Renamed tracked item '%s' to '%s'", ActivityCategory.DELIVERY_EDIT),
    ITEM_REMOVED("Removed tracked item '%s'", ActivityCategory.DELIVERY_EDIT, ActivityCategory.IMPORTANT),
    ITEM_DESCOPED("Descoped tracked item '%s'", ActivityCategory.DELIVERY_EDIT, ActivityCategory.IMPORTANT),
    ITEM_RESCOPED("Rescoped tracked item '%s'", ActivityCategory.DELIVERY_EDIT, ActivityCategory.IMPORTANT),
    ITEM_AVAILABLE("Added tracked item '%s' to stage '%s'", ActivityCategory.LIFECYCLE),
    ITEM_COMPLETED("Completed tracked item '%s' in stage '%s' from release '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    ITEM_COMPLETED_MANUALLY("Completed tracked item '%s' in stage '%s' manually", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    ITEM_SKIPPED("Skipped tracked item '%s' in stage '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    ITEM_TRANSITION_APPROVED("Approved transition '%s' of tracked item '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TRANSITION_CREATED("Created transition '%s'", ActivityCategory.DELIVERY_EDIT),
    TRANSITION_UPDATED("Updated transition '%s'", ActivityCategory.DELIVERY_EDIT),
    TRANSITION_REMOVED("Removed transition '%s'", ActivityCategory.DELIVERY_EDIT),
    TRANSITION_EXECUTED_MANUALLY("Executed transition '%s' manually", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TRANSITION_EXECUTED_AUTOMATICALLY("Executed transition '%s' automatically due to condition completion", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    CONDITION_SATISFIED("Satisfied %s '%s' on transition '%s'", ActivityCategory.LIFECYCLE),
    CONDITION_UPDATED("Updated condition '%s' on transition '%s'", ActivityCategory.DELIVERY_EDIT),
    OTHER("", ActivityCategory.OTHER);

    private String message;
    private Set<ActivityCategory> categories;
    private static final Map<String, DeliveryActivity> BY_NAME;

    private DeliveryActivity(String message, ActivityCategory ... categories) {
        this.message = message;
        LinkedHashSet myCategories = Sets.newLinkedHashSet();
        if (categories != null) {
            Collections.addAll(myCategories, categories);
        }
        this.categories = Collections.unmodifiableSet(myCategories);
    }

    public ActivityLogEntry create(Date eventTime, String username, Type targetType, String targetId, Object ... parameters) {
        return this.create(eventTime, this.name(), username, targetType, targetId, this.message, parameters);
    }

    public ActivityLogEntry create(DeliveryEvent ev, BaseConfigurationItem target, Object ... parameters) {
        return this.create(ev.timestamp(), ev.username(), target.getType(), target.getId(), parameters);
    }

    public Set<ActivityCategory> getCategories() {
        return this.categories;
    }

    public static DeliveryActivity safeValueOf(String name) {
        DeliveryActivity activity = BY_NAME.get(name);
        return activity == null ? OTHER : activity;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeliveryActivity value : DeliveryActivity.values()) {
            builder.put((Object)value.name(), (Object)value);
        }
        BY_NAME = builder.build();
    }
}

