/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.delivery.events.DeliveryCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryEvent;
import com.xebialabs.xlrelease.delivery.events.ItemAvailableEvent;
import com.xebialabs.xlrelease.delivery.events.ItemCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemDescopedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemRescopedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemSkippedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemTransitionApprovedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.StageReopenedEvent;
import com.xebialabs.xlrelease.delivery.events.StageStartedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionExecutedEvent;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.transition.TransitionEvaluator$;
import com.xebialabs.xlrelease.delivery.transition.TransitionParams;
import com.xebialabs.xlrelease.delivery.transition.TransitionResult;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.StageTrackedItem;
import com.xebialabs.xlrelease.domain.delivery.Subscriber;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionStatus;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Date;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tus!B\u0016-\u0011\u00039d!B\u001d-\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011\u0005\"B\"\u0002\t\u0003!e\u0001B\u001d-\u0001\u0019C\u0001b\f\u0003\u0003\u0006\u0004%\ta\u0012\u0005\t\u001f\u0012\u0011\t\u0011)A\u0005\u0011\"A\u0001\u000b\u0002B\u0001B\u0003%\u0011\u000bC\u0003B\t\u0011\u0005q\u000bC\u0004[\t\t\u0007I\u0011B.\t\r%$\u0001\u0015!\u0003]\u0011\u001dQGA1A\u0005\n-Da\u0001\u001f\u0003!\u0002\u0013a\u0007\"B=\u0005\t\u0003Q\bbBA\u0005\t\u0011\u0005\u00111\u0002\u0005\b\u0003\u001f!A\u0011AA\t\u0011\u001d\ti\u0002\u0002C\u0001\u0003?Aq!a\t\u0005\t\u0003\t)\u0003C\u0004\u00022\u0011!\t!a\r\t\u000f\u0005mB\u0001\"\u0001\u0002>!9\u0011q\n\u0003\u0005\u0002\u0005E\u0003bBA*\t\u0011\u0005\u0011Q\u000b\u0005\n\u0003\u0007#\u0011\u0013!C\u0001\u0003\u000bC\u0011\"a'\u0005#\u0003%\t!!(\t\u000f\u0005\u0005F\u0001\"\u0001\u0002$\"9\u0011Q\u0016\u0003\u0005\u0002\u0005=\u0006\"CA\\\tE\u0005I\u0011AAO\u0011\u001d\tI\f\u0002C\u0001\u0003wCq!a0\u0005\t\u0003\t\t\rC\u0004\u0002F\u0012!\t!a2\t\u000f\u0005-G\u0001\"\u0001\u0002N\"9\u0011\u0011\u001b\u0003\u0005\u0002\u0005M\u0007bBAm\t\u0011\u0005\u00111\u001c\u0005\b\u0003K$A\u0011AAt\u0011\u001d\t)\u000f\u0002C\u0005\u0005\u0003AqA!\u0005\u0005\t\u0013\u0011\u0019\u0002C\u0005\u0003\u001c\u0011\t\n\u0011\"\u0003\u0003\u001e!9!\u0011\u0005\u0003\u0005\n\t\r\u0002b\u0002B\u001a\t\u0011%!Q\u0007\u0005\b\u0005o!A\u0011\u0002B\u001d\u0011\u001d\u0011i\u0004\u0002C\u0005\u0005\u007fAqAa\u0011\u0005\t\u0013\u0011)\u0005C\u0004\u0003H\u0011!IA!\u0013\u0002)\u0011+G.\u001b<fef\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0015\tic&A\u0004tKJ4\u0018nY3\u000b\u0005=\u0002\u0014\u0001\u00033fY&4XM]=\u000b\u0005E\u0012\u0014!\u0003=me\u0016dW-Y:f\u0015\t\u0019D'A\u0005yK\nL\u0017\r\\1cg*\tQ'A\u0002d_6\u001c\u0001\u0001\u0005\u00029\u00035\tAF\u0001\u000bEK2Lg/\u001a:z'R\fG/Z'b]\u0006<WM]\n\u0003\u0003m\u0002\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00018\u0003\u0015\t\u0007\u000f\u001d7z)\u0015)%Q\nB(!\tADa\u0005\u0002\u0005wU\t\u0001\n\u0005\u0002J\u001b6\t!J\u0003\u00020\u0017*\u0011A\nM\u0001\u0007I>l\u0017-\u001b8\n\u00059S%\u0001\u0003#fY&4XM]=\u0002\u0013\u0011,G.\u001b<fef\u0004\u0013a\u00024bGR|'/\u001f\t\u0003%Vk\u0011a\u0015\u0006\u0003):\nA!\u001e;jY&\u0011ak\u0015\u0002\u0016\t\u0016d\u0017N^3ss>\u0013'.Z2u\r\u0006\u001cGo\u001c:z)\r)\u0005,\u0017\u0005\u0006_!\u0001\r\u0001\u0013\u0005\u0006!\"\u0001\r!U\u0001\u0007KZ,g\u000e^:\u0016\u0003q\u00032!\u00182e\u001b\u0005q&BA0a\u0003\u001diW\u000f^1cY\u0016T!!Y\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002d=\n1!)\u001e4gKJ\u0004\"!Z4\u000e\u0003\u0019T!A\u0017\u0018\n\u0005!4'!\u0004#fY&4XM]=Fm\u0016tG/A\u0004fm\u0016tGo\u001d\u0011\u0002\u00115,7o]1hKN,\u0012\u0001\u001c\t\u0004;\nl\u0007C\u00018v\u001d\ty7\u000f\u0005\u0002q{5\t\u0011O\u0003\u0002sm\u00051AH]8pizJ!\u0001^\u001f\u0002\rA\u0013X\rZ3g\u0013\t1xO\u0001\u0004TiJLgn\u001a\u0006\u0003iv\n\u0011\"\\3tg\u0006<Wm\u001d\u0011\u0002\u0013\u001d,G/\u0012<f]R\u001cX#A>\u0011\tq\f\u0019\u0001\u001a\b\u0003{~t!\u0001\u001d@\n\u0003yJ1!!\u0001>\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0002\u0002\b\t!A*[:u\u0015\r\t\t!P\u0001\fO\u0016$X*Z:tC\u001e,7/\u0006\u0002\u0002\u000eA!A0a\u0001n\u00039\tG\r\u001a+sC\u000e\\W\rZ%uK6$B!a\u0005\u0002\u001aA\u0019\u0011*!\u0006\n\u0007\u0005]!JA\u0006Ue\u0006\u001c7.\u001a3Ji\u0016l\u0007bBA\u000e\u001f\u0001\u0007\u00111C\u0001\u0005SR,W.A\tva\u0012\fG/\u001a+sC\u000e\\W\rZ%uK6$B!a\u0005\u0002\"!9\u00111\u0004\tA\u0002\u0005M\u0011!\u00053fY\u0016$X\r\u0016:bG.,G-\u0013;f[R!\u0011qEA\u0017!\ra\u0014\u0011F\u0005\u0004\u0003Wi$\u0001B+oSRDa!a\f\u0012\u0001\u0004i\u0017AB5uK6LE-\u0001\tbI\u0012\u0014V\r\\3bg\u0016$v.\u0013;f[R1\u0011qEA\u001b\u0003oAq!a\u0007\u0013\u0001\u0004\t\u0019\u0002\u0003\u0004\u0002:I\u0001\r!\\\u0001\ne\u0016dW-Y:f\u0013\u0012\f!C]3hSN$XM]*vEN\u001c'/\u001b2feR!\u0011qHA#!\rI\u0015\u0011I\u0005\u0004\u0003\u0007R%AE*vEN\u001c'/\u001b9uS>t'+Z:vYRDq!a\u0012\u0014\u0001\u0004\tI%\u0001\u0006tk\n\u001c8M]5cKJ\u00042!SA&\u0013\r\tiE\u0013\u0002\u000b'V\u00147o\u0019:jE\u0016\u0014\u0018!B:uCJ$H#\u0001%\u0002/5\f'o\u001b+sC\u000e\\W\rZ%uK6\u001c\u0018J\\*uC\u001e,G\u0003DA,\u0003;\n\t'a\u001b\u0002v\u0005}\u0004#\u0002?\u0002Z\u0005M\u0011\u0002BA.\u0003\u000f\u00111aU3r\u0011\u001d\ty&\u0006a\u0001\u0003/\nQ!\u001b;f[NDq!a\u0019\u0016\u0001\u0004\t)'A\u0003ti\u0006<W\rE\u0002J\u0003OJ1!!\u001bK\u0005\u0015\u0019F/Y4f\u0011\u001d\ti'\u0006a\u0001\u0003_\naa\u001d;biV\u001c\bcA%\u0002r%\u0019\u00111\u000f&\u0003#Q\u0013\u0018mY6fI&#X-\\*uCR,8\u000fC\u0005\u0002xU\u0001\n\u00111\u0001\u0002z\u0005y\u0001O]3dK\u0012LgnZ*uC\u001e,7\u000fE\u0002=\u0003wJ1!! >\u0005\u001d\u0011un\u001c7fC:D\u0001\"!!\u0016!\u0003\u0005\r!\\\u0001\u000eMJ|WNU3mK\u0006\u001cX-\u00133\u0002C5\f'o\u001b+sC\u000e\\W\rZ%uK6\u001c\u0018J\\*uC\u001e,G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u001d%\u0006BA=\u0003\u0013[#!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+k\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011TAH\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\"[\u0006\u00148\u000e\u0016:bG.,G-\u0013;f[NLen\u0015;bO\u0016$C-\u001a4bk2$H%N\u000b\u0003\u0003?S3!\\AE\u0003Yi\u0017M]6Ue\u0006\u001c7.\u001a3Ji\u0016l\u0017J\\*uC\u001e,GCCA\u0014\u0003K\u000b9+!+\u0002,\"9\u00111\u0004\rA\u0002\u0005M\u0001bBA21\u0001\u0007\u0011Q\r\u0005\b\u0003[B\u0002\u0019AA8\u0011\u0019\t\t\t\u0007a\u0001[\u0006Q2m\\7qY\u0016$X\r\u0016:bG.,G-\u0013;f[&s7\u000b^1hKR9\u0001*!-\u00024\u0006U\u0006bBA\u000e3\u0001\u0007\u00111\u0003\u0005\b\u0003GJ\u0002\u0019AA3\u0011!\t\t)\u0007I\u0001\u0002\u0004i\u0017\u0001J2p[BdW\r^3Ue\u0006\u001c7.\u001a3Ji\u0016l\u0017J\\*uC\u001e,G\u0005Z3gCVdG\u000fJ\u001a\u0002\u001b\r|W\u000e\u001d7fi\u0016\u001cF/Y4f)\u0011\t9#!0\t\u000f\u0005\r4\u00041\u0001\u0002f\u0005Y!/Z8qK:\u001cF/Y4f)\u0011\t9#a1\t\u000f\u0005\rD\u00041\u0001\u0002f\u0005aA-Z:d_B,\u0017\n^3ngR!\u0011qEAe\u0011\u001d\ty&\ba\u0001\u0003/\nAB]3tG>\u0004X-\u0013;f[N$B!a\n\u0002P\"9\u0011q\f\u0010A\u0002\u0005]\u0013AF:lSB$&/Y2lK\u0012LE/Z7J]N#\u0018mZ3\u0015\u000b!\u000b).a6\t\u000f\u0005mq\u00041\u0001\u0002\u0014!9\u00111M\u0010A\u0002\u0005\u0015\u0014aD:uCJ$8\u000b^1hK\u001e\u0013x.\u001e9\u0015\r\u0005\u001d\u0012Q\\Ar\u0011\u001d\ty\u000e\ta\u0001\u0003C\faa\u001d;bO\u0016\u001c\b#\u0002?\u0002Z\u0005\u0015\u0004bBA0A\u0001\u0007\u0011qK\u0001\u0011Q\u0006tG\r\\3Ue\u0006t7/\u001b;j_:$b!a\n\u0002j\u0006M\bbBAvC\u0001\u0007\u0011Q^\u0001\u000biJ\fgn]5uS>t\u0007cA%\u0002p&\u0019\u0011\u0011\u001f&\u0003\u0015Q\u0013\u0018M\\:ji&|g\u000eC\u0004\u0002v\u0006\u0002\r!a>\u0002\rA\f'/Y7t!\u0011\tI0!@\u000e\u0005\u0005m(bAAv]%!\u0011q`A~\u0005A!&/\u00198tSRLwN\u001c)be\u0006l7\u000f\u0006\u0005\u0002(\t\r!Q\u0001B\u0004\u0011\u001d\tYO\ta\u0001\u0003[Dq!!>#\u0001\u0004\t9\u0010C\u0004\u0003\n\t\u0002\rAa\u0003\u0002!Q\u0014\u0018M\\:ji&|gNU3tk2$\b\u0003BA}\u0005\u001bIAAa\u0004\u0002|\n\u0001BK]1og&$\u0018n\u001c8SKN,H\u000e^\u0001\u001cM>\u00148-Z\"m_N,7\u000b^1hKNLeMT8u\u00072|7/\u001a3\u0015\r\u0005\u001d\"Q\u0003B\f\u0011\u001d\tyn\ta\u0001\u0003CD\u0011B!\u0007$!\u0003\u0005\r!a\u0016\u0002\u001d%$X-\\:U_\u0012+7oY8qK\u0006)cm\u001c:dK\u000ecwn]3Ti\u0006<Wm]%g\u001d>$8\t\\8tK\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0005?QC!a\u0016\u0002\n\u0006)cm\u001c:dKN[\u0017\u000e\u001d+sC\u000e\\W\rZ%uK6Len\u0015;bO\u0016LeMT8u%\u0016\fG-\u001f\u000b\t\u0003O\u0011)Ca\n\u0003*!9\u00111D\u0013A\u0002\u0005M\u0001bBA2K\u0001\u0007\u0011Q\r\u0005\b\u0005W)\u0003\u0019\u0001B\u0017\u0003A\u0019H/Y4f)J\f7m[3e\u0013R,W\u000eE\u0002J\u0005_I1A!\rK\u0005A\u0019F/Y4f)J\f7m[3e\u0013R,W.A\u0005iCN\u001cF/Y4fgV\u0011\u0011\u0011P\u0001\u0016SN\fE\u000e\\8xK\u0012$vn\u00117pg\u0016\u001cF/Y4f)\u0011\tIHa\u000f\t\u000f\u0005\rt\u00051\u0001\u0002f\u00051\u0012n]!mY><X\r\u001a+p%\u0016|\u0007/\u001a8Ti\u0006<W\r\u0006\u0003\u0002z\t\u0005\u0003bBA2Q\u0001\u0007\u0011QM\u0001\u0016G\",7m\u001b#fY&4XM]=Jg\u0006\u001bG/\u001b<f)\t\t9#A\u0007bI\u0012\u001cVOY:de&\u0014WM\u001d\u000b\u0005\u0003\u007f\u0011Y\u0005C\u0004\u0002H)\u0002\r!!\u0013\t\u000b=\u001a\u0001\u0019\u0001%\t\u000f\tE3\u00011\u0001\u0003T\u0005Y1-[%e'\u0016\u0014h/[2f!\u0011\u0011)F!\u0017\u000e\u0005\t]#BA\u00171\u0013\u0011\u0011YFa\u0016\u0003\u0017\rK\u0017\nZ*feZL7-\u001a")
public class DeliveryStateManager {
    private final Delivery delivery;
    private final DeliveryObjectFactory factory;
    private final Buffer<DeliveryEvent> events;
    private final Buffer<String> messages;

    public static DeliveryStateManager apply(Delivery delivery, CiIdService ciIdService) {
        return DeliveryStateManager$.MODULE$.apply(delivery, ciIdService);
    }

    public Delivery delivery() {
        return this.delivery;
    }

    private Buffer<DeliveryEvent> events() {
        return this.events;
    }

    private Buffer<String> messages() {
        return this.messages;
    }

    public List<DeliveryEvent> getEvents() {
        return this.events().toList();
    }

    public List<String> getMessages() {
        return this.messages().toList();
    }

    public TrackedItem addTrackedItem(TrackedItem item) {
        block0: {
            this.checkDeliveryIsActive();
            String itemId = this.factory.trackedItemId(this.delivery().getId());
            item.setId(itemId);
            item.setModifiedDate(new Date());
            this.delivery().addTrackedItem(item);
            this.delivery().addReleaseIds(item.getReleaseIds());
            this.events().$plus$eq((Object)new ItemCreatedEvent(item, this.delivery()));
            if (this.delivery().isTemplate()) break block0;
            this.delivery().getStagesBeforeFirstOpenTransition().forEach(stage -> {
                block0: {
                    StageTrackedItem stageTrackedItem = $this.factory.createStageTrackedItem(stage.getId(), itemId);
                    stage.getItems().add(stageTrackedItem);
                    this.events().$plus$eq((Object)new ItemAvailableEvent(item, (Stage)((Object)stage), this.delivery()));
                    if (!stage.isClosed()) break block0;
                    stageTrackedItem.setStatus(TrackedItemStatus.SKIPPED);
                    this.events().$plus$eq((Object)new ItemSkippedEvent(item, (Stage)((Object)stage), this.delivery()));
                }
            });
        }
        return item;
    }

    /*
     * WARNING - void declaration
     */
    public TrackedItem updateTrackedItem(TrackedItem item) {
        void var2_2;
        this.checkDeliveryIsActive();
        TrackedItem updatedItem = this.delivery().getItemByIdOrTitle(item.getId());
        TrackedItem originalItem = (TrackedItem)CiCloneHelper.cloneCi((ConfigurationItem)updatedItem);
        updatedItem.setTitle(item.getTitle());
        updatedItem.setModifiedDate(new Date());
        this.events().$plus$eq((Object)new ItemUpdatedEvent(updatedItem, this.delivery(), originalItem));
        return var2_2;
    }

    public void deleteTrackedItem(String itemId) {
        this.checkDeliveryIsActive();
        TrackedItem item = this.delivery().getItemByIdOrTitle(itemId);
        this.delivery().removeTrackedItem(itemId);
        if (!this.delivery().isTemplate()) {
            this.delivery().getStages().forEach(x$1 -> x$1.removeTrackedItem(itemId));
        }
        this.events().$plus$eq((Object)new ItemRemovedEvent(item, this.delivery()));
    }

    public void addReleaseToItem(TrackedItem item, String releaseId) {
        this.checkDeliveryIsActive();
        item.addReleaseId(releaseId);
        this.delivery().addReleaseId(releaseId);
    }

    public SubscriptionResult registerSubscriber(Subscriber subscriber) {
        this.checkDeliveryIsActive();
        return this.addSubscriber(subscriber);
    }

    public Delivery start() {
        block0: {
            this.delivery().setStatus(DeliveryStatus.IN_PROGRESS);
            if (!this.hasStages()) break block0;
            Buffer firstStageGroup = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStagesBeforeFirstOpenTransition()).asScala();
            this.startStageGroup((Seq<Stage>)firstStageGroup, (Seq<TrackedItem>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getTrackedItems()).asScala()));
        }
        return this.delivery();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Seq<TrackedItem> markTrackedItemsInStage(Seq<TrackedItem> items, Stage stage, TrackedItemStatus status, boolean precedingStages, String fromReleaseId) {
        v0 = this.delivery().getStatus();
        var8_6 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((boolean)(!(v0 != null ? v0.equals((Object)var8_6) == false : var8_6 != null)), (String)"Only in-progress release deliveries may complete or skip items", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Stage must be open in order to update items in it", (Object[])new Object[0]);
        v1 = status;
        var9_7 = TrackedItemStatus.READY;
        if (!(v1 == null ? var9_7 != null : v1.equals((Object)var9_7) == false)) ** GOTO lbl-1000
        v2 = status;
        var10_8 = TrackedItemStatus.SKIPPED;
        if (!(v2 != null ? v2.equals((Object)var10_8) == false : var10_8 != null)) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        Checks.checkTrue((boolean)v3, (String)new StringBuilder(29).append("Not allowed to mark items as ").append((Object)status).toString(), (Object[])new Object[0]);
        descopedItems = (Seq)items.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$1$adapted(com.xebialabs.xlrelease.domain.delivery.TrackedItem ), (Lcom/xebialabs/xlrelease/domain/delivery/TrackedItem;)Ljava/lang/Object;)());
        Checks.checkTrue((boolean)descopedItems.isEmpty(), (String)new StringBuilder(72).append("Unable to complete task, the following tracked items are de-scoped:\n * ").append(((TraversableOnce)descopedItems.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$2(com.xebialabs.xlrelease.domain.delivery.TrackedItem ), (Lcom/xebialabs/xlrelease/domain/delivery/TrackedItem;)Ljava/lang/String;)(), Seq$.MODULE$.canBuildFrom())).mkString("\n * ")).append("\n").toString(), (Object[])new Object[0]);
        if (precedingStages) {
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStagesBefore(stage)).asScala()).dropWhile((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$3$adapted(com.xebialabs.xlrelease.domain.delivery.Stage ), (Lcom/xebialabs/xlrelease/domain/delivery/Stage;)Ljava/lang/Object;)())).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$4(com.xebialabs.xlrelease.delivery.service.DeliveryStateManager scala.collection.Seq com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus java.lang.String com.xebialabs.xlrelease.domain.delivery.Stage ), (Lcom/xebialabs/xlrelease/domain/delivery/Stage;)Lscala/collection/Seq;)((DeliveryStateManager)this, items, (TrackedItemStatus)status, (String)fromReleaseId));
        }
        var7_11 = TrackedItemStatus.READY.equals((Object)(var13_10 = status)) != false ? (Seq)new .colon.colon((Object)TrackedItemStatus.READY, (List)Nil$.MODULE$) : (TrackedItemStatus.SKIPPED.equals((Object)var13_10) != false ? (Seq)new .colon.colon((Object)TrackedItemStatus.READY, (List)new .colon.colon((Object)TrackedItemStatus.SKIPPED, (List)Nil$.MODULE$)) : (Seq)Nil$.MODULE$);
        doneStatuses = var7_11;
        doneItems = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stage.getItems()).asScala()).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$6$adapted(scala.collection.Seq com.xebialabs.xlrelease.domain.delivery.StageTrackedItem ), (Lcom/xebialabs/xlrelease/domain/delivery/StageTrackedItem;)Ljava/lang/Object;)((Seq)doneStatuses))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$7(com.xebialabs.xlrelease.domain.delivery.StageTrackedItem ), (Lcom/xebialabs/xlrelease/domain/delivery/StageTrackedItem;)Ljava/lang/String;)(), Buffer$.MODULE$.canBuildFrom())).toSet();
        var16_14 = items.partition((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$8$adapted(scala.collection.immutable.Set com.xebialabs.xlrelease.domain.delivery.TrackedItem ), (Lcom/xebialabs/xlrelease/domain/delivery/TrackedItem;)Ljava/lang/Object;)((Set)doneItems));
        if (var16_14 == null) {
            throw new MatchError((Object)var16_14);
        }
        done = (Seq)var16_14._1();
        notDone = (Seq)var16_14._2();
        var6_17 = new Tuple2((Object)done, (Object)notDone);
        var15_18 = var6_17;
        done = (Seq)var15_18._1();
        notDone = (Seq)var15_18._2();
        v4 /* !! */  = done.nonEmpty() != false ? this.messages().$plus$eq((Object)new StringBuilder(57).append("Tracked items [").append(((TraversableOnce)done.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$9(com.xebialabs.xlrelease.domain.delivery.TrackedItem ), (Lcom/xebialabs/xlrelease/domain/delivery/TrackedItem;)Ljava/lang/String;)(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("] already completed or skipped on stage '").append(stage.getId()).append("'").toString()) : BoxedUnit.UNIT;
        notDone.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$10$adapted(com.xebialabs.xlrelease.delivery.service.DeliveryStateManager com.xebialabs.xlrelease.domain.delivery.Stage com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus java.lang.String com.xebialabs.xlrelease.domain.delivery.TrackedItem ), (Lcom/xebialabs/xlrelease/domain/delivery/TrackedItem;)Ljava/lang/Object;)((DeliveryStateManager)this, (Stage)stage, (TrackedItemStatus)status, (String)fromReleaseId));
        return notDone;
    }

    public boolean markTrackedItemsInStage$default$4() {
        return false;
    }

    public String markTrackedItemsInStage$default$5() {
        return null;
    }

    public void markTrackedItemInStage(TrackedItem item, Stage stage, TrackedItemStatus status, String fromReleaseId) {
        TrackedItemStatus trackedItemStatus = status;
        if (((Object)((Object)TrackedItemStatus.READY)).equals((Object)trackedItemStatus)) {
            this.completeTrackedItemInStage(item, stage, fromReleaseId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)TrackedItemStatus.SKIPPED)).equals((Object)trackedItemStatus)) {
            this.skipTrackedItemInStage(item, stage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Delivery completeTrackedItemInStage(TrackedItem item, Stage stage, String fromReleaseId) {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may complete items", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Stage must be open in order to complete items in it", (Object[])new Object[0]);
        Checks.checkTrue((!item.isDescoped() ? 1 : 0) != 0, (String)"Cannot complete de-scoped item", (Object[])new Object[0]);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.READY;
        Checks.checkTrue(((trackedItemStatus == null ? trackedItemStatus2 != null : !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2)) ? 1 : 0) != 0, (String)"Only not completed tracked items can be completed", (Object[])new Object[0]);
        stageItem.setStatus(TrackedItemStatus.READY);
        this.events().$plus$eq((Object)new ItemCompletedEvent(item, stage, this.delivery(), fromReleaseId));
        return this.delivery();
    }

    public String completeTrackedItemInStage$default$3() {
        return null;
    }

    public void completeStage(Stage stage) {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may complete stages", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Only open stages may be completed", (Object[])new Object[0]);
        Checks.checkTrue((boolean)this.isAllowedToCloseStage(stage), (String)"Stages cannot be completed if their preceding stages are not closed", (Object[])new Object[0]);
        Buffer toDescopeAndSkip = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stage.getItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$completeStage$1(x$9)))).map((Function1 & Serializable & scala.Serializable)stageItem -> this.delivery().getItemByIdOrTitle(stageItem.getTrackedItemId()), Buffer$.MODULE$.canBuildFrom());
        this.forceCloseStagesIfNotClosed((Seq<Stage>)((Seq)new .colon.colon((Object)stage, (List)Nil$.MODULE$)), (Seq<TrackedItem>)toDescopeAndSkip);
    }

    public void reopenStage(Stage stage) {
        block0: {
            DeliveryStatus deliveryStatus = this.delivery().getStatus();
            DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
            Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may reopen stages", (Object[])new Object[0]);
            Checks.checkTrue((boolean)stage.isClosed(), (String)"Only closed stages may be reopened", (Object[])new Object[0]);
            Checks.checkTrue((boolean)this.isAllowedToReopenStage(stage), (String)"Stages cannot be reopened if their subsequent stages are closed", (Object[])new Object[0]);
            if (!stage.isClosed()) break block0;
            stage.setStatus(StageStatus.OPEN);
            this.events().$plus$eq((Object)new StageReopenedEvent(stage, this.delivery()));
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                DeliveryStateManager.$anonfun$reopenStage$1(x$10);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void descopeItems(Seq<TrackedItem> items) {
        Map itemsNotYetDescoped = ((TraversableOnce)items.view().filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isDescoped())).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.getId()), (Object)item), SeqView$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        itemsNotYetDescoped.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)item -> {
            item.setDescoped(true);
            return this.events().$plus$eq((Object)new ItemDescopedEvent((TrackedItem)((Object)item), this.delivery()));
        });
    }

    public void rescopeItems(Seq<TrackedItem> items) {
        Map descopedItems = ((TraversableOnce)items.view().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isDescoped())).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.getId()), (Object)item), SeqView$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        descopedItems.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)item -> {
            item.setDescoped(false);
            return this.events().$plus$eq((Object)new ItemRescopedEvent((TrackedItem)((Object)item), this.delivery()));
        });
    }

    public Delivery skipTrackedItemInStage(TrackedItem item, Stage stage) {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may skip items", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Items can only be skipped in OPEN stages", (Object[])new Object[0]);
        Checks.checkTrue((!item.isDescoped() ? 1 : 0) != 0, (String)"Cannot skip a descoped item", (Object[])new Object[0]);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
        Checks.checkTrue((!(trackedItemStatus != null ? !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2) : trackedItemStatus2 != null) ? 1 : 0) != 0, (String)"Only NOT_READY items can be skipped", (Object[])new Object[0]);
        this.forceSkipTrackedItemInStageIfNotReady(item, stage, stageItem);
        return this.delivery();
    }

    public void startStageGroup(Seq<Stage> stages, Seq<TrackedItem> items) {
        stages.foreach((Function1 & Serializable & scala.Serializable)stage -> {
            DeliveryStateManager.$anonfun$startStageGroup$1(this, items, stage);
            return BoxedUnit.UNIT;
        });
    }

    public void handleTransition(Transition transition, TransitionParams params) {
        TransitionEvaluator$.MODULE$.evaluate(params).foreach((Function1 & Serializable & scala.Serializable)result -> {
            this.handleTransition(transition, params, result);
            return BoxedUnit.UNIT;
        });
    }

    private void handleTransition(Transition transition, TransitionParams params, TransitionResult transitionResult) {
        this.events().$plus$eq((Object)new TransitionExecutedEvent(transition, this.delivery(), params));
        Stage stage2 = this.delivery().getStageByTransition(transition);
        transitionResult.toTransition().toList().foreach((Function1 & Serializable & scala.Serializable)item -> this.events().$plus$eq((Object)new ItemTransitionApprovedEvent((TrackedItem)((Object)item), stage2.findItemById(item.getId()).get(), transition, stage2, this.delivery())));
        if (transitionResult.closeStages()) {
            Buffer stagesToClose = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStagesBefore(params.transitionStage())).asScala()).filter((Function1 & Serializable & scala.Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)stage.isOpen()))).$colon$plus((Object)params.transitionStage(), Buffer$.MODULE$.canBuildFrom());
            this.forceCloseStagesIfNotClosed((Seq<Stage>)stagesToClose, (Seq<TrackedItem>)transitionResult.toDescope().toList());
        }
        Buffer nextStageGroup = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStageGroupAfterTransition(transition)).asScala();
        this.startStageGroup((Seq<Stage>)nextStageGroup, (Seq<TrackedItem>)transitionResult.toTransition().toList());
    }

    private void forceCloseStagesIfNotClosed(Seq<Stage> stages, Seq<TrackedItem> itemsToDescope) {
        stages.foreach((Function1 & Serializable & scala.Serializable)stage -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            itemsToDescope.foreach((Function1 & Serializable & scala.Serializable)item -> {
                DeliveryStateManager.$anonfun$forceCloseStagesIfNotClosed$2(this, stage, item);
                return BoxedUnit.UNIT;
            });
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
                x$17.setAutomated(false);
                return BoxedUnit.UNIT;
            });
            if (stage.isOpen()) {
                stage.setStatus(StageStatus.CLOSED);
                boxedUnit2 = this.events().$plus$eq((Object)new StageCompletedEvent((Stage)((Object)stage), this.delivery()));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.delivery().isLastStage((Stage)((Object)stage))) {
                this.delivery().setStatus(DeliveryStatus.COMPLETED);
                boxedUnit = this.events().$plus$eq((Object)new DeliveryCompletedEvent(this.delivery()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        this.descopeItems(itemsToDescope);
    }

    private Seq<TrackedItem> forceCloseStagesIfNotClosed$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    private void forceSkipTrackedItemInStageIfNotReady(TrackedItem item, Stage stage, StageTrackedItem stageTrackedItem) {
        block0: {
            TrackedItemStatus trackedItemStatus = stageTrackedItem.getStatus();
            TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
            if (trackedItemStatus != null ? !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2) : trackedItemStatus2 != null) break block0;
            stageTrackedItem.setStatus(TrackedItemStatus.SKIPPED);
            this.events().$plus$eq((Object)new ItemSkippedEvent(item, stage, this.delivery()));
        }
    }

    private boolean hasStages() {
        return this.delivery().getStages() != null && !this.delivery().getStages().isEmpty();
    }

    private boolean isAllowedToCloseStage(Stage stage) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.delivery().findPreviousStage(stage))).forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$isAllowedToCloseStage$1(x$18)));
    }

    private boolean isAllowedToReopenStage(Stage stage) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.delivery().findNextStage(stage))).forall((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$isAllowedToReopenStage$1(x$19)));
    }

    private void checkDeliveryIsActive() {
        Checks.checkTrue((!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeliveryStatus.INACTIVE_STATUSES)).contains((Object)this.delivery().getStatus()) ? 1 : 0) != 0, (String)"Can't modify ABORTED or COMPLETED release delivery", (Object[])new Object[0]);
    }

    private SubscriptionResult addSubscriber(Subscriber subscriber) {
        Subscriber subscriber2;
        SubscriptionStatus subscriptionStatus;
        subscriber.validate(this.delivery());
        SubscriptionResult result = subscriber.evaluate(this.delivery());
        int subscriberIndex = ((GenSeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getSubscribers()).asScala()).indexWhere((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)x$20.isEqual(subscriber)));
        SubscriptionResult subscriptionResult = result;
        if (subscriptionResult != null && ((Object)((Object)SubscriptionStatus.COMPLETED)).equals((Object)(subscriptionStatus = subscriptionResult.status())) && subscriberIndex != -1) {
            subscriber2 = this.delivery().getSubscribers().remove(subscriberIndex);
        } else {
            SubscriptionStatus subscriptionStatus2;
            SubscriptionStatus subscriptionStatus3;
            boolean bl = subscriptionResult != null && ((Object)((Object)SubscriptionStatus.FAILED)).equals((Object)(subscriptionStatus3 = subscriptionResult.status())) ? true : subscriptionResult != null && ((Object)((Object)SubscriptionStatus.IN_PROGRESS)).equals((Object)(subscriptionStatus2 = subscriptionResult.status()));
            if (bl && subscriberIndex != -1) {
                subscriber2 = this.delivery().getSubscribers().set(subscriberIndex, subscriber);
            } else {
                SubscriptionStatus subscriptionStatus4;
                SubscriptionStatus subscriptionStatus5;
                boolean bl2 = subscriptionResult != null && ((Object)((Object)SubscriptionStatus.FAILED)).equals((Object)(subscriptionStatus5 = subscriptionResult.status())) ? true : subscriptionResult != null && ((Object)((Object)SubscriptionStatus.IN_PROGRESS)).equals((Object)(subscriptionStatus4 = subscriptionResult.status()));
                if (bl2) {
                    this.delivery().addSubscriber(subscriber);
                    subscriber2 = BoxedUnit.UNIT;
                } else {
                    subscriber2 = BoxedUnit.UNIT;
                }
            }
        }
        return result;
    }

    public static final /* synthetic */ String $anonfun$markTrackedItemsInStage$2(TrackedItem x$3) {
        return x$3.getTitle();
    }

    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$5(Stage stage$1, TrackedItem item) {
        return stage$1.findItemById(item.getId()).isPresent();
    }

    public static final /* synthetic */ Seq $anonfun$markTrackedItemsInStage$4(DeliveryStateManager $this, Seq items$1, TrackedItemStatus status$1, String fromReleaseId$1, Stage stage) {
        Seq itemsInStage = (Seq)items$1.filter((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$markTrackedItemsInStage$5(stage, item)));
        return $this.markTrackedItemsInStage((Seq<TrackedItem>)itemsInStage, stage, status$1, false, fromReleaseId$1);
    }

    public static final /* synthetic */ String $anonfun$markTrackedItemsInStage$7(StageTrackedItem x$5) {
        return x$5.getTrackedItemId();
    }

    public static final /* synthetic */ String $anonfun$markTrackedItemsInStage$9(TrackedItem x$7) {
        return x$7.getId();
    }

    public static final /* synthetic */ boolean $anonfun$completeStage$1(StageTrackedItem x$9) {
        TrackedItemStatus trackedItemStatus = x$9.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
        return !(trackedItemStatus != null ? !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2) : trackedItemStatus2 != null);
    }

    public static final /* synthetic */ void $anonfun$reopenStage$1(Transition x$10) {
        x$10.getAllConditions().forEach(x$11 -> x$11.reset());
    }

    public static final /* synthetic */ void $anonfun$startStageGroup$1(DeliveryStateManager $this, Seq items$2, Stage stage) {
        block0: {
            Set existingItems = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stage.getItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.getTrackedItemId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Seq newItems = (Seq)items$2.filterNot((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)existingItems.apply((Object)item.getId())));
            java.util.List stageItems = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)newItems.map((Function1 & Serializable & scala.Serializable)item -> $this.factory.createStageTrackedItem(stage.getId(), item.getId()), Seq$.MODULE$.canBuildFrom())).asJava();
            stage.addTrackedItems(stageItems);
            Object object = existingItems.isEmpty() ? $this.events().$plus$eq((Object)new StageStartedEvent(stage, $this.delivery())) : BoxedUnit.UNIT;
            newItems.foreach((Function1 & Serializable & scala.Serializable)x$15 -> $this.events().$plus$eq((Object)new ItemAvailableEvent((TrackedItem)((Object)x$15), stage, $this.delivery())));
            if (!stage.isClosed()) break block0;
            stageItems.forEach(stageItem -> stageItem.setStatus(TrackedItemStatus.SKIPPED));
            newItems.foreach((Function1 & Serializable & scala.Serializable)x$16 -> $this.events().$plus$eq((Object)new ItemSkippedEvent((TrackedItem)((Object)x$16), stage, $this.delivery())));
        }
    }

    public static final /* synthetic */ void $anonfun$forceCloseStagesIfNotClosed$2(DeliveryStateManager $this, Stage stage$5, TrackedItem item) {
        stage$5.findItemById(item.getId()).ifPresent(stageItem -> $this.forceSkipTrackedItemInStageIfNotReady(item, stage$5, (StageTrackedItem)((Object)stageItem)));
    }

    public static final /* synthetic */ boolean $anonfun$isAllowedToCloseStage$1(Stage x$18) {
        StageStatus stageStatus = x$18.getStatus();
        StageStatus stageStatus2 = StageStatus.CLOSED;
        return !(stageStatus != null ? !((Object)((Object)stageStatus)).equals((Object)stageStatus2) : stageStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isAllowedToReopenStage$1(Stage x$19) {
        StageStatus stageStatus = x$19.getStatus();
        StageStatus stageStatus2 = StageStatus.CLOSED;
        return stageStatus == null ? stageStatus2 != null : !((Object)((Object)stageStatus)).equals((Object)stageStatus2);
    }

    public DeliveryStateManager(Delivery delivery, DeliveryObjectFactory factory) {
        this.delivery = delivery;
        this.factory = factory;
        this.events = (Buffer)Buffer$.MODULE$.empty();
        this.messages = (Buffer)Buffer$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$1$adapted(TrackedItem x$2) {
        return BoxesRunTime.boxToBoolean((boolean)x$2.isDescoped());
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$3$adapted(Stage x$4) {
        return BoxesRunTime.boxToBoolean((boolean)x$4.isClosed());
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$6$adapted(Seq doneStatuses$1, StageTrackedItem stageItem) {
        return BoxesRunTime.boxToBoolean((boolean)doneStatuses$1.contains((Object)stageItem.getStatus()));
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$8$adapted(Set doneItems$1, TrackedItem item) {
        return BoxesRunTime.boxToBoolean((boolean)doneItems$1.contains((Object)item.getId()));
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$10$adapted(DeliveryStateManager $this, Stage stage$2, TrackedItemStatus status$1, String fromReleaseId$1, TrackedItem x$8) {
        $this.markTrackedItemInStage(x$8, stage$2, status$1, fromReleaseId$1);
        return BoxedUnit.UNIT;
    }
}

