/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.transition.condition;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.delivery.events.ConditionSatisfiedEvent;
import com.xebialabs.xlrelease.delivery.events.ConditionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryDeletedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryEvent;
import com.xebialabs.xlrelease.delivery.events.StageCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.transition.condition.ConditionChange;
import com.xebialabs.xlrelease.delivery.transition.condition.DeliveryConditionReaction;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0007\u000f\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006+\u0002!\tB\u0016\u0005\u00067\u0002!\t\u0002\u0018\u0005\be\u0002\t\n\u0011\"\u0005t\u0011\u001di\b!%A\u0005\u0012MDqA \u0001\u0012\u0002\u0013E1\u000f\u0003\u0004\u0000\u0001\u0011E\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001A\u0011CA\b\u0011\u001d\ti\u0001\u0001C\t\u0003CAq!!\u0004\u0001\t#\tyCA\rEK2Lg/\u001a:z\u0007>tG-\u001b;j_:D\u0015M\u001c3mKJ\u001c(BA\b\u0011\u0003%\u0019wN\u001c3ji&|gN\u0003\u0002\u0012%\u0005QAO]1og&$\u0018n\u001c8\u000b\u0005M!\u0012\u0001\u00033fY&4XM]=\u000b\u0005U1\u0012!\u0003=me\u0016dW-Y:f\u0015\t9\u0002$A\u0005yK\nL\u0017\r\\1cg*\t\u0011$A\u0002d_6\u001c\u0001a\u0005\u0002\u00019A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\f!cY8oI&$\u0018n\u001c8SK\u0006\u001cG/[8ogB\u0019A%K\u0016\u000e\u0003\u0015R!AJ\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0003MSN$\bC\u0001\u0017.\u001b\u0005q\u0011B\u0001\u0018\u000f\u0005e!U\r\\5wKJL8i\u001c8eSRLwN\u001c*fC\u000e$\u0018n\u001c8\u0002\rqJg.\u001b;?)\t\t$\u0007\u0005\u0002-\u0001!)!E\u0001a\u0001G!\u0012!\u0001\u000e\t\u0003k\u0001k\u0011A\u000e\u0006\u0003oa\n!\"\u00198o_R\fG/[8o\u0015\tI$(A\u0004gC\u000e$xN]=\u000b\u0005mb\u0014!\u00022fC:\u001c(BA\u001f?\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A \u0002\u0007=\u0014x-\u0003\u0002Bm\tI\u0011)\u001e;po&\u0014X\rZ\u0001\u0010_:$U\r\\5wKJLXI^3oiR\u0011Ai\u0012\t\u0003;\u0015K!A\u0012\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0011\u000e\u0001\r!S\u0001\u0006KZ,g\u000e\u001e\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019J\ta!\u001a<f]R\u001c\u0018B\u0001(L\u00055!U\r\\5wKJLXI^3oi\"\u00121\u0001\u0015\t\u0003#Nk\u0011A\u0015\u0006\u0003\u0019RI!\u0001\u0016*\u0003\u0013M+(m]2sS\n,\u0017!D:i_VdG\r\u0015:pG\u0016\u001c8\u000f\u0006\u0002X5B\u0011Q\u0004W\u0005\u00033z\u0011qAQ8pY\u0016\fg\u000eC\u0003I\t\u0001\u0007\u0011*A\u0004qe>\u001cWm]:\u0015\t\u0011kf\u000e\u001d\u0005\b=\u0016\u0001\n\u00111\u0001`\u0003\u001d\u0019'/Z1uK\u0012\u00042\u0001\u00195l\u001d\t\tgM\u0004\u0002cK6\t1M\u0003\u0002e5\u00051AH]8pizJ\u0011aH\u0005\u0003Oz\tq\u0001]1dW\u0006<W-\u0003\u0002jU\n\u00191+Z9\u000b\u0005\u001dt\u0002C\u0001\u0017m\u0013\tigBA\bD_:$\u0017\u000e^5p]\u000eC\u0017M\\4f\u0011\u001dyW\u0001%AA\u0002}\u000bq!\u001e9eCR,G\rC\u0004r\u000bA\u0005\t\u0019A0\u0002\u000f\u0011,G.\u001a;fI\u0006\t\u0002O]8dKN\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003QT#aX;,\u0003Y\u0004\"a^>\u000e\u0003aT!!\u001f>\u0002\u0013Ut7\r[3dW\u0016$'BA\u001c\u001f\u0013\ta\bPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011\u0003\u001d:pG\u0016\u001c8\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003E\u0001(o\\2fgN$C-\u001a4bk2$HeM\u0001\fO\u0016$(+Z1di&|g\u000e\u0006\u0003\u0002\u0004\u0005%\u0001\u0003B\u000f\u0002\u0006-J1!a\u0002\u001f\u0005\u0019y\u0005\u000f^5p]\"1\u00111B\u0005A\u0002-\f\u0001cY8oI&$\u0018n\u001c8D_:$X\r\u001f;\u0002#\r|G\u000e\\3di\u000e{g\u000eZ5uS>t7\u000fF\u0002`\u0003#Aaa\u0005\u0006A\u0002\u0005M\u0001\u0003BA\u000b\u0003;i!!a\u0006\u000b\u0007M\tIBC\u0002\u0002\u001cQ\ta\u0001Z8nC&t\u0017\u0002BA\u0010\u0003/\u0011\u0001\u0002R3mSZ,'/\u001f\u000b\u0006?\u0006\r\u0012Q\u0005\u0005\u0007'-\u0001\r!a\u0005\t\u000f\u0005\u001d2\u00021\u0001\u0002*\u0005)1\u000f^1hKB!\u0011QCA\u0016\u0013\u0011\ti#a\u0006\u0003\u000bM#\u0018mZ3\u0015\u0013}\u000b\t$a\r\u00026\u0005u\u0002BB\n\r\u0001\u0004\t\u0019\u0002C\u0004\u0002(1\u0001\r!!\u000b\t\rEa\u0001\u0019AA\u001c!\u0011\t)\"!\u000f\n\t\u0005m\u0012q\u0003\u0002\u000b)J\fgn]5uS>t\u0007BB\b\r\u0001\u0004\ty\u0004\u0005\u0003\u0002\u0016\u0005\u0005\u0013\u0002BA\"\u0003/\u0011\u0011bQ8oI&$\u0018n\u001c8)\u0007\u0001\t9\u0005E\u0002R\u0003\u0013J1!a\u0013S\u00055)e/\u001a8u\u0019&\u001cH/\u001a8fe\"\u001a\u0001!a\u0014\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016=\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u00033\n\u0019FA\u0005D_6\u0004xN\\3oi\u0002")
public class DeliveryConditionHandlers {
    private final java.util.List<DeliveryConditionReaction> conditionReactions;

    /*
     * Enabled aggressive block sorting
     */
    @Subscribe
    public void onDeliveryEvent(DeliveryEvent event) {
        if (!this.shouldProcess(event)) return;
        DeliveryEvent deliveryEvent = event;
        if (deliveryEvent instanceof DeliveryCreatedEvent) {
            DeliveryCreatedEvent deliveryCreatedEvent = (DeliveryCreatedEvent)deliveryEvent;
            Delivery delivery = deliveryCreatedEvent.delivery();
            this.process(this.collectConditions(delivery), this.process$default$2(), this.process$default$3());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (deliveryEvent instanceof DeliveryDeletedEvent) {
            DeliveryDeletedEvent deliveryDeletedEvent = (DeliveryDeletedEvent)deliveryEvent;
            Delivery delivery = deliveryDeletedEvent.delivery();
            Seq<ConditionChange> x$1 = this.collectConditions(delivery);
            Seq<ConditionChange> x$2 = this.process$default$1();
            Seq<ConditionChange> x$3 = this.process$default$2();
            this.process(x$2, x$3, x$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (deliveryEvent instanceof StageCompletedEvent) {
            StageCompletedEvent stageCompletedEvent = (StageCompletedEvent)deliveryEvent;
            Stage stage = stageCompletedEvent.stage();
            Delivery delivery = stageCompletedEvent.delivery();
            Seq<ConditionChange> x$4 = this.collectConditions(delivery, stage);
            Seq<ConditionChange> x$5 = this.process$default$1();
            Seq<ConditionChange> x$6 = this.process$default$2();
            this.process(x$5, x$6, x$4);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (deliveryEvent instanceof TransitionUpdatedEvent) {
            TransitionUpdatedEvent transitionUpdatedEvent = (TransitionUpdatedEvent)deliveryEvent;
            Transition original = transitionUpdatedEvent.transition();
            Transition updated = transitionUpdatedEvent.updated();
            Delivery delivery = transitionUpdatedEvent.delivery();
            if (original.isAutomated() != updated.isAutomated()) {
                Seq<ConditionChange> x$7 = this.collectConditions(delivery, delivery.getStageByTransition(updated));
                Seq<ConditionChange> x$8 = this.process$default$1();
                Seq<ConditionChange> x$9 = this.process$default$3();
                this.process(x$8, x$7, x$9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (deliveryEvent instanceof ConditionSatisfiedEvent) {
            ConditionSatisfiedEvent conditionSatisfiedEvent = (ConditionSatisfiedEvent)deliveryEvent;
            Condition condition = conditionSatisfiedEvent.condition();
            Transition transition = conditionSatisfiedEvent.transition();
            Delivery delivery = conditionSatisfiedEvent.delivery();
            if (condition.isLeaf()) {
                Seq x$10 = (Seq)new .colon.colon((Object)new ConditionChange(delivery, transition.getStage(), transition, condition), (List)Nil$.MODULE$);
                Seq<ConditionChange> x$11 = this.process$default$1();
                Seq<ConditionChange> x$12 = this.process$default$2();
                this.process(x$11, x$12, (Seq<ConditionChange>)x$10);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (deliveryEvent instanceof ConditionUpdatedEvent) {
            ConditionUpdatedEvent conditionUpdatedEvent = (ConditionUpdatedEvent)deliveryEvent;
            Condition condition = conditionUpdatedEvent.condition();
            Transition transition = conditionUpdatedEvent.transition();
            Delivery delivery = conditionUpdatedEvent.delivery();
            Seq<ConditionChange> x$13 = this.collectConditions(delivery, transition.getStage(), transition, condition);
            Seq<ConditionChange> x$14 = this.process$default$1();
            Seq<ConditionChange> x$15 = this.process$default$3();
            this.process(x$14, x$13, x$15);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public boolean shouldProcess(DeliveryEvent event) {
        return !event.delivery().isTemplate();
    }

    public void process(Seq<ConditionChange> created, Seq<ConditionChange> updated, Seq<ConditionChange> deleted) {
        created.foreach((Function1 & Serializable & scala.Serializable)condition -> {
            DeliveryConditionHandlers.$anonfun$process$1(this, condition);
            return BoxedUnit.UNIT;
        });
        updated.foreach((Function1 & Serializable & scala.Serializable)condition -> {
            DeliveryConditionHandlers.$anonfun$process$3(this, condition);
            return BoxedUnit.UNIT;
        });
        deleted.foreach((Function1 & Serializable & scala.Serializable)condition -> {
            DeliveryConditionHandlers.$anonfun$process$5(this, condition);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<ConditionChange> process$default$1() {
        return (Seq)Nil$.MODULE$;
    }

    public Seq<ConditionChange> process$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    public Seq<ConditionChange> process$default$3() {
        return (Seq)Nil$.MODULE$;
    }

    public Option<DeliveryConditionReaction> getReaction(ConditionChange conditionContext) {
        Type conditionType;
        Buffer allReactions = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.conditionReactions).asScala();
        Type type = conditionType = conditionContext.condition().getType();
        Buffer allConditionTypes = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(conditionType.getDescriptor().getSuperClasses()).asScala()).$plus$colon((Object)type, Buffer$.MODULE$.canBuildFrom());
        Option reaction = ((IterableLike)allConditionTypes.map((Function1 & Serializable & scala.Serializable)typ -> allReactions.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeliveryConditionHandlers.$anonfun$getReaction$2(typ, x$5))), Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDefined())).flatten(Predef$.MODULE$.$conforms());
        return reaction;
    }

    public Seq<ConditionChange> collectConditions(Delivery delivery) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getStages()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)stage -> this.collectConditions(delivery, (Stage)((Object)stage)), Buffer$.MODULE$.canBuildFrom());
    }

    public Seq<ConditionChange> collectConditions(Delivery delivery, Stage stage) {
        return (Seq)Option$.MODULE$.apply((Object)stage.getTransition()).map((Function1 & Serializable & scala.Serializable)transition -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(transition.getConditions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> this.collectConditions(delivery, stage, (Transition)((Object)transition), (Condition)((Object)((Object)x$7))), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public Seq<ConditionChange> collectConditions(Delivery delivery, Stage stage, Transition transition, Condition condition) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(condition.getLeafConditions()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> new ConditionChange(delivery, stage, transition, (Condition)((Object)x$8)), Buffer$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$process$1(DeliveryConditionHandlers $this, ConditionChange condition) {
        $this.getReaction(condition).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.onCreate(condition);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$process$3(DeliveryConditionHandlers $this, ConditionChange condition) {
        $this.getReaction(condition).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.onUpdate(condition);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$process$5(DeliveryConditionHandlers $this, ConditionChange condition) {
        $this.getReaction(condition).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.onDelete(condition);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getReaction$2(Type typ$1, DeliveryConditionReaction x$5) {
        Type type = x$5.forType();
        Type type2 = typ$1;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    @Autowired
    public DeliveryConditionHandlers(java.util.List<DeliveryConditionReaction> conditionReactions) {
        this.conditionReactions = conditionReactions;
    }
}

