/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.pubsub;

import akka.actor.ActorSystem;
import akka.cluster.pubsub.DistributedPubSubSettings;
import akka.routing.BroadcastRoutingLogic$;
import akka.routing.RandomRoutingLogic;
import akka.routing.RandomRoutingLogic$;
import akka.routing.RoundRobinRoutingLogic$;
import akka.routing.RoutingLogic;
import com.typesafe.config.Config;
import java.util.concurrent.TimeUnit;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public final class DistributedPubSubSettings$ {
    public static DistributedPubSubSettings$ MODULE$;

    static {
        new DistributedPubSubSettings$();
    }

    public DistributedPubSubSettings apply(ActorSystem system) {
        return this.apply(system.settings().config().getConfig("akka.cluster.pub-sub"));
    }

    public DistributedPubSubSettings apply(Config config) {
        RandomRoutingLogic randomRoutingLogic;
        Option<String> option = this.roleOption(config.getString("role"));
        String string = config.getString("routing-logic");
        if ("random".equals(string)) {
            randomRoutingLogic = RandomRoutingLogic$.MODULE$.apply();
        } else if ("round-robin".equals(string)) {
            randomRoutingLogic = RoundRobinRoutingLogic$.MODULE$.apply();
        } else {
            if ("consistent-hashing".equals(string)) {
                throw new IllegalArgumentException("'consistent-hashing' routing logic can't be used by the pub-sub mediator");
            }
            if ("broadcast".equals(string)) {
                randomRoutingLogic = BroadcastRoutingLogic$.MODULE$.apply();
            } else {
                throw new IllegalArgumentException(new StringBuilder(27).append("Unknown 'routing-logic': [").append(string).append("]").toString());
            }
        }
        return new DistributedPubSubSettings(option, (RoutingLogic)randomRoutingLogic, new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("gossip-interval", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("removed-time-to-live", TimeUnit.MILLISECONDS))).millis(), config.getInt("max-delta-elements"), config.getBoolean("send-to-dead-letters-when-no-subscribers"));
    }

    public DistributedPubSubSettings create(ActorSystem system) {
        return this.apply(system);
    }

    public DistributedPubSubSettings create(Config config) {
        return this.apply(config);
    }

    public Option<String> roleOption(String role) {
        String string = role;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : Option$.MODULE$.apply((Object)role);
    }

    private DistributedPubSubSettings$() {
        MODULE$ = this;
    }
}

