/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentStageFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentStageForm;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentStageView;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.environments.service.EnvironmentSecurity;
import com.xebialabs.xlrelease.environments.service.EnvironmentStageService;
import com.xebialabs.xlrelease.rest.AllCILevels;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/environments/stages")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class EnvironmentStageApi
implements ApiService {
    private EnvironmentStageService environmentStageService;
    private EnvironmentSecurity environmentSecurity;

    public String serviceName() {
        return "environmentStageApi";
    }

    @Autowired
    public EnvironmentStageApi(EnvironmentStageService environmentStageService, EnvironmentSecurity environmentSecurity) {
        this.environmentStageService = environmentStageService;
        this.environmentSecurity = environmentSecurity;
    }

    @POST
    @Timed
    public EnvironmentStageView createStage(EnvironmentStageForm stageForm) {
        this.environmentSecurity.checkCreate();
        return EnvironmentStageView.fromEnvironmentStage(this.environmentStageService.createStage(stageForm.toStage()));
    }

    @GET
    @Timed
    @Path(value="/{environmentStageId:.*/EnvironmentStage[^/]*}")
    public EnvironmentStageView getStageById(@PathParam(value="environmentStageId") String environmentStageId) {
        this.environmentSecurity.checkView();
        return EnvironmentStageView.fromEnvironmentStage(this.environmentStageService.findStageById(environmentStageId));
    }

    @PUT
    @Timed
    @Path(value="/{environmentStageId:.*/EnvironmentStage[^/]*}")
    public EnvironmentStageView updateStage(@PathParam(value="environmentStageId") String environmentStageId, EnvironmentStageForm stageForm) {
        this.environmentSecurity.checkEdit();
        EnvironmentStage stage = stageForm.toStage();
        stage.setId(environmentStageId);
        return EnvironmentStageView.fromEnvironmentStage(this.environmentStageService.updateStage(stage));
    }

    @POST
    @Timed
    @Path(value="/search")
    public List<EnvironmentStageView> searchStages(EnvironmentStageFilters filters) {
        this.environmentSecurity.checkView();
        return this.environmentStageService.searchStages(filters).stream().map(EnvironmentStageView::fromEnvironmentStage).collect(Collectors.toList());
    }

    @DELETE
    @PublicApiMember
    @Timed
    @Path(value="/{environmentStageId:.*/EnvironmentStage[^/]*}")
    public void delete(@PathParam(value="environmentStageId") String environmentStageId) {
        this.environmentSecurity.checkEdit();
        this.environmentStageService.deleteStage(environmentStageId);
    }

    @PublicApiMember
    @Timed
    public EnvironmentStage create(EnvironmentStage environmentStage) {
        this.environmentSecurity.checkCreate();
        return this.environmentStageService.createStage(environmentStage);
    }

    @PublicApiMember
    @Timed
    public EnvironmentStage getById(String environmentStageId) {
        this.environmentSecurity.checkView();
        return this.environmentStageService.findStageById(environmentStageId);
    }

    @PublicApiMember
    @Timed
    public EnvironmentStage update(EnvironmentStage environmentCategory) {
        this.environmentSecurity.checkEdit();
        return this.environmentStageService.updateStage(environmentCategory);
    }

    @PublicApiMember
    @Timed
    public List<EnvironmentStage> search(EnvironmentStageFilters filters) {
        this.environmentSecurity.checkView();
        return this.environmentStageService.searchStages(filters);
    }
}

