/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.util.JdbcUtils;

public class CockroachDatabase
extends PostgresDatabase {
    public CockroachDatabase() {
        super.setCurrentDateTimeFunction("NOW()");
    }

    @Override
    public int getPriority() {
        return super.getPriority() + 5;
    }

    @Override
    public String getShortName() {
        return "cockroachdb";
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return "CockroachDB";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        try (Statement stmt = ((JdbcConnection)conn).createStatement();
             ResultSet rs = stmt.executeQuery("select version()");){
            if (!rs.next()) return false;
            boolean bl2 = ((String)JdbcUtils.getResultSetValue(rs, 1)).startsWith("CockroachDB");
            return bl2;
        }
        catch (SQLException throwables) {
            return false;
        }
    }

    @Override
    public Integer getDefaultPort() {
        return 26257;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public boolean supportsDDLInTransaction() {
        return false;
    }
}

