/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.xlrelease.activity.ActivityOps;
import com.xebialabs.xlrelease.api.internal.BaseActivityLogsResource;
import com.xebialabs.xlrelease.delivery.activity.DeliveryActivity;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissionChecker;
import com.xebialabs.xlrelease.delivery.service.DeliveryActivityLogsService;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.service.BaseActivityLogsService;
import com.xebialabs.xlrelease.views.ActivityLogEntryView;
import com.xebialabs.xlrelease.views.LogsFilters;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/activity")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class DeliveryActivityLogsResource
extends BaseActivityLogsResource {
    private DeliveryPermissionChecker permissions;
    private final ActivityLogRepository activityLogRepository;

    @Autowired
    public DeliveryActivityLogsResource(DeliveryActivityLogsService deliveryActivityLogsService, UserViewConverter userViewConverter, DeliveryPermissionChecker permissions, ActivityLogRepository activityLogRepository) {
        super((BaseActivityLogsService)deliveryActivityLogsService, userViewConverter);
        this.permissions = permissions;
        this.activityLogRepository = activityLogRepository;
    }

    @POST
    @Path(value="/{deliveryId:.*Delivery[^/-]*}/logs/search")
    public List<ActivityLogEntryView> searchDeliveryLogs(@PathParam(value="deliveryId") String deliveryId, LogsFilters filters) {
        this.permissions.checkView(deliveryId);
        return this.searchLogs(deliveryId, filters);
    }

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/-]*}/approvals")
    public List<ActivityLogEntryView> searchTrackedItemApprovals(@PathParam(value="deliveryId") String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.activityLogRepository.findAllLogsOf(deliveryId, (ActivityOps)DeliveryActivity.ITEM_TRANSITION_APPROVED).stream().map(x$0 -> super.toActivityLogEntryView(x$0)).collect(Collectors.toList());
    }
}

