/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.security;

import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.service.DeliveryService;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\f\u0019\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005g!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015Y\u0007\u0001\"\u0001o\u0011\u00159\b\u0001\"\u0001y\u0011\u0015Q\b\u0001\"\u0001|\u0011\u00159\b\u0001\"\u0001\u007f\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\b\u0001!\t!a\u0004\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011Q\u0003\u0001\u0005\u0002\u0005m\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u00028\u0001!I!!\u000f\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@\tIB)\u001a7jm\u0016\u0014\u0018\u0010U3s[&\u001c8/[8o\u0007\",7m[3s\u0015\tI\"$\u0001\u0005tK\u000e,(/\u001b;z\u0015\tYB$\u0001\u0005eK2Lg/\u001a:z\u0015\tib$A\u0005yYJ,G.Z1tK*\u0011q\u0004I\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!I\u0001\u0004G>l7\u0001A\n\u0003\u0001\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017!F1vi\",g\u000e^5dCRLwN\\*feZL7-\u001a\t\u0003YAj\u0011!\f\u0006\u0003]=\na\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002\u001a9%\u0011\u0011'\f\u0002\u0016\u0003V$\b.\u001a8uS\u000e\fG/[8o'\u0016\u0014h/[2f\u0003Y!W\r\\5wKJL\b+\u0019;uKJt7+\u001a:wS\u000e,\u0007C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u001b\u0003\u001d\u0019XM\u001d<jG\u0016L!\u0001O\u001b\u0003-\u0011+G.\u001b<fef\u0004\u0016\r\u001e;fe:\u001cVM\u001d<jG\u0016\fq\u0002Z3mSZ,'/_*feZL7-\u001a\t\u0003imJ!\u0001P\u001b\u0003\u001f\u0011+G.\u001b<fef\u001cVM\u001d<jG\u0016\f1\u0002]3s[&\u001c8/[8ogB\u0011q\bQ\u0007\u0002_%\u0011\u0011i\f\u0002\u0012!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003E\r\u001eC\u0015\n\u0005\u0002F\u00015\t\u0001\u0004C\u0003+\u000b\u0001\u00071\u0006C\u00033\u000b\u0001\u00071\u0007C\u0003:\u000b\u0001\u0007!\bC\u0003>\u000b\u0001\u0007a\b\u000b\u0002\u0006\u0017B\u0011AjV\u0007\u0002\u001b*\u0011ajT\u0001\u000bC:tw\u000e^1uS>t'B\u0001)R\u0003\u001d1\u0017m\u0019;pefT!AU*\u0002\u000b\t,\u0017M\\:\u000b\u0005Q+\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003Y\u000b1a\u001c:h\u0013\tAVJA\u0005BkR|w/\u001b:fI\u0006I1\r[3dWZKWm\u001e\u000b\u00037z\u0003\"!\n/\n\u0005u3#\u0001B+oSRDQa\u0018\u0004A\u0002\u0001\f!\u0002Z3mSZ,'/_%e!\t\t\u0007N\u0004\u0002cMB\u00111MJ\u0007\u0002I*\u0011QMI\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d4\u0013A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!a\u001a\u0014\u0002#\rDWmY6WS\u0016<H)\u001a7jm\u0016\u0014\u0018\u0010\u0006\u0002\\[\")ql\u0002a\u0001AR\u00111l\u001c\u0005\u00067!\u0001\r\u0001\u001d\t\u0003cVl\u0011A\u001d\u0006\u00037MT!\u0001\u001e\u000f\u0002\r\u0011|W.Y5o\u0013\t1(O\u0001\u0005EK2Lg/\u001a:z\u0003E\u0019\u0007.Z2l\u000b\u0012LG\u000fR3mSZ,'/\u001f\u000b\u00037fDQaX\u0005A\u0002\u0001\f\u0011d\u00195fG.,E-\u001b;EK2Lg/\u001a:z\u001f:\u001c%/Z1uKR\u00111\f \u0005\u0006{*\u0001\r\u0001Y\u0001\tM>dG-\u001a:JIR\u00111l \u0005\u00067-\u0001\r\u0001]\u0001\u001fG\",7m[#eSR$&/Y2lK\u0012LE/Z7P]\u0012+G.\u001b<fef$2aWA\u0003\u0011\u0015yF\u00021\u0001a\u0003a\u0019\u0007.Z2l-&,w\u000fR3mSZ,'/\u001f)biR,'O\u001c\u000b\u00047\u0006-\u0001BBA\u0007\u001b\u0001\u0007\u0001-A\u0005qCR$XM\u001d8JIR\u00191,!\u0005\t\r\u0005Ma\u00021\u0001q\u0003\u001d\u0001\u0018\r\u001e;fe:\f\u0001d\u00195fG.,E-\u001b;EK2Lg/\u001a:z!\u0006$H/\u001a:o)\rY\u0016\u0011\u0004\u0005\u0007\u0003\u001by\u0001\u0019\u00011\u0015\u0007m\u000bi\u0002\u0003\u0004\u0002\u0014A\u0001\r\u0001]\u0001\u001aG\",7m\u001b,jK^$U\r\\5wKJLxJ\u001c$pY\u0012,'\u000fF\u0002\\\u0003GAQ!`\tA\u0002\u0001\f\u0011d\u00195fG.,E-\u001b;EK2Lg/\u001a:z\u001f:4u\u000e\u001c3feR\u00191,!\u000b\t\u000bu\u0014\u0002\u0019\u00011\u00029\rDWmY6FI&$HK]1dW\u0016$\u0017\n^3n\u001f:4u\u000e\u001c3feR\u00191,a\f\t\u000bu\u001c\u0002\u0019\u00011\u0002A\rDWmY6WS\u0016<H)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014hn\u00148G_2$WM\u001d\u000b\u00047\u0006U\u0002\"B?\u0015\u0001\u0004\u0001\u0017\u0001I2iK\u000e\\W\tZ5u\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]>sgi\u001c7eKJ$2aWA\u001e\u0011\u0015iX\u00031\u0001a\u0003]\u0019\u0007.Z2l!\u0016\u0014X.[:tS>twJ\u001c$pY\u0012,'\u000fF\u0003\\\u0003\u0003\n\u0019\u0005C\u0003~-\u0001\u0007\u0001\rC\u0004\u0002FY\u0001\r!a\u0012\u0002'A,'/\\5tg&|gn\u001d+p-\u0016\u0014\u0018NZ=\u0011\u000b\u0015\nI%!\u0014\n\u0007\u0005-cE\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002B!a\u0014\u0002\\5\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n)&\u0001\u0006qKJl\u0017n]:j_:T1!GA,\u0015\r\tIFH\u0001\tI\u0016\u0004Hn\\=ji&!\u0011QLA)\u0005)\u0001VM]7jgNLwN\u001c\u0015\u0004\u0001\u0005\u0005\u0004\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001d4+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u001b\u0002f\tI1i\\7q_:,g\u000e\u001e")
public class DeliveryPermissionChecker {
    private final DeliveryPatternService deliveryPatternService;
    private final DeliveryService deliveryService;
    private final PermissionChecker permissions;

    public void checkView(String deliveryId) {
        Delivery delivery = this.deliveryService.getDeliveryOrPattern(deliveryId);
        if (delivery.isTemplate()) {
            this.checkViewDeliveryPattern(delivery);
        } else {
            this.checkViewDelivery(delivery);
        }
    }

    public void checkViewDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkViewDeliveryOnFolder(folderId);
    }

    public void checkViewDelivery(Delivery delivery) {
        String folderId = delivery.getFolderId();
        this.checkViewDeliveryOnFolder(folderId);
    }

    public void checkEditDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkEditDeliveryOnFolder(folderId);
    }

    public void checkEditDeliveryOnCreate(String folderId) {
        this.checkEditDeliveryOnFolder(folderId);
    }

    public void checkEditDelivery(Delivery delivery) {
        this.checkEditDeliveryOnFolder(delivery.getFolderId());
    }

    public void checkEditTrackedItemOnDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkEditTrackedItemOnFolder(folderId);
    }

    public void checkViewDeliveryPattern(String patternId) {
        String folderId = this.deliveryPatternService.getFolderId(patternId);
        this.checkViewDeliveryPatternOnFolder(folderId);
    }

    public void checkViewDeliveryPattern(Delivery pattern) {
        String folderId = pattern.getFolderId();
        this.checkViewDeliveryPatternOnFolder(folderId);
    }

    public void checkEditDeliveryPattern(String patternId) {
        String folderId = this.deliveryPatternService.getFolderId(patternId);
        this.checkEditDeliveryPatternOnFolder(folderId);
    }

    public void checkEditDeliveryPattern(Delivery pattern) {
        String folderId = pattern.getFolderId();
        this.checkEditDeliveryPatternOnFolder(folderId);
    }

    private void checkViewDeliveryOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PERMISSION_SET());
    }

    private void checkEditDeliveryOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_PERMISSION_SET());
    }

    private void checkEditTrackedItemOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_TRACKED_ITEM_PERMISSION_SET());
    }

    private void checkViewDeliveryPatternOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET());
    }

    private void checkEditDeliveryPatternOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_PATTERN_PERMISSION_SET());
    }

    private void checkPermissionOnFolder(String folderId, Seq<Permission> permissionsToVerify) {
        this.permissions.checkAny(folderId, permissionsToVerify);
    }

    @Autowired
    public DeliveryPermissionChecker(AuthenticationService authenticationService, DeliveryPatternService deliveryPatternService, DeliveryService deliveryService, PermissionChecker permissions) {
        this.deliveryPatternService = deliveryPatternService;
        this.deliveryService = deliveryService;
        this.permissions = permissions;
    }
}

