/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xebialabs.deployit.Sanitizer;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import java.util.Date;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Provider
@Component
public class JsonProcessingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    public Response toResponse(JsonProcessingException exception) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain");
        builder.header("X-Exception-Type", (Object)((Object)((Object)exception)).getClass().getName());
        builder.header("X-Path", PathInterceptor.PATH.get());
        builder.header("Date", (Object)new Date());
        builder.entity((Object)Sanitizer.sanitize((String)exception.getOriginalMessage()));
        return builder.build();
    }
}

