/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.createrelease;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.deployit.plumbing.scheduler.FutureTaskAdapter;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.CreatedFromCreateReleaseTask;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedFromCreateReleaseTaskEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.EncryptionHelper;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.UsernamePassword;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import scala.Option;

@Component
public class CreateReleaseTaskExecutor
implements TaskExecutor<CreateReleaseTask> {
    private static final Logger logger = LoggerFactory.getLogger(CreateReleaseTaskExecutor.class);
    private Scheduler scheduler;
    private ReleaseActorService releaseActorService;
    private ReleaseService releaseService;
    private CiIdService ciIdService;
    private PermissionChecker permissionChecker;
    private AuthenticationService authenticationService;
    private XLReleaseEventBus eventBus;

    @Autowired
    public CreateReleaseTaskExecutor(Scheduler scheduler, ReleaseActorService releaseActorService, ReleaseService releaseService, CiIdService ciIdService, PermissionChecker permissionChecker, AuthenticationService authenticationService, XLReleaseEventBus eventBus) {
        this.scheduler = scheduler;
        this.releaseActorService = releaseActorService;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.permissionChecker = permissionChecker;
        this.authenticationService = authenticationService;
        this.eventBus = eventBus;
    }

    @Override
    public Class<CreateReleaseTask> getTaskClass() {
        return CreateReleaseTask.class;
    }

    @Override
    public void executeWithSoftReference(TaskSoftReference<CreateReleaseTask> taskRef, SensitiveValueScrubber scrubber) {
        this.scheduler.supplyAsync(FutureTaskAdapter.ofCreateReleaseTask(taskRef.getTaskId(), this.releaseActorService, taskRef.getExecutionId(), () -> this.startTask(taskRef)));
    }

    protected Void startTask(TaskSoftReference<CreateReleaseTask> taskRef) {
        CreateReleaseTask task = (CreateReleaseTask)taskRef.get();
        try {
            this.validateRequiredProperties(task);
            UsernamePassword scriptUserPass = this.checkPermissions(task);
            this.validateCreateReleaseRecursion(task);
            Release subRelease = this.createRelease(task, scriptUserPass);
            this.saveCreatedReleaseIdIntoVariable(task, subRelease);
            if (task.getStartRelease()) {
                this.checkPermissions(task, subRelease.getId(), XLReleasePermissions.START_RELEASE);
                boolean hasBeenStarted = this.startRelease(task, subRelease);
                if (!hasBeenStarted) {
                    this.failTask(task, String.format("Release '%s' could not be started", subRelease.getTitle()));
                    return null;
                }
            }
            this.saveCreatedReleaseIdIntoTask(task, subRelease);
            this.completeTask(task);
        }
        catch (Exception ex) {
            logger.error(String.format("Exception occurred while creating a release. Reason: %s.", ex.getMessage()), (Throwable)ex);
            this.failTask(task, ex.getMessage());
        }
        return null;
    }

    private void validateCreateReleaseRecursion(CreateReleaseTask task) {
        if (!StringUtils.isEmpty((Object)task.getTemplateIdVariable()) && !StringUtils.isEmpty((Object)task.getRelease().getOriginTemplateId())) {
            Preconditions.checkArgument((!task.getRelease().getOriginTemplateId().equals(task.getTemplateId()) ? 1 : 0) != 0, (Object)"The template that will be used to create a new release must be different from the template used to create the current release.");
        }
    }

    private void validateRequiredProperties(CreateReleaseTask task) {
        Preconditions.checkArgument((!StringUtils.isEmpty((Object)task.getNewReleaseTitle()) ? 1 : 0) != 0, (Object)"Title of the release to be created cannot be empty.");
        Preconditions.checkArgument((!StringUtils.isEmpty((Object)task.getTemplateId()) ? 1 : 0) != 0, (Object)(!StringUtils.isEmpty((Object)task.getTemplateIdVariable()) ? "Template that will be used to create a release couldn't be derived from variable " + task.getTemplateIdVariable() : "Template that will be used to create a release must be specified."));
        Preconditions.checkArgument((boolean)this.releaseService.exists(task.getTemplateId()), (Object)("Template provided in variable " + task.getTemplateIdVariable() + " must be a valid template id."));
    }

    private UsernamePassword checkPermissions(CreateReleaseTask task) {
        return this.checkPermissions(task, task.getTemplateId(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UsernamePassword checkPermissions(CreateReleaseTask task, String releaseId, Permission requiredPermission) {
        UsernamePassword usernamePass;
        try {
            usernamePass = this.authenticationService.loginScriptUser((Task)task);
            if (Strings.isBlank((String)task.getFolderId())) {
                this.permissionChecker.checkIsAllowedToCreateReleaseFromTemplate(task.getTemplateId());
            } else {
                this.permissionChecker.checkIsAllowedToViewTemplate(task.getTemplateId());
                this.permissionChecker.checkIsAllowedToCreateReleaseInFolder(task.getFolderId());
            }
            if (requiredPermission != null) {
                this.permissionChecker.check(requiredPermission, releaseId);
            }
        }
        finally {
            this.authenticationService.logoutScriptUser();
        }
        return usernamePass;
    }

    private Release createRelease(CreateReleaseTask task, UsernamePassword scriptUsernamePass) {
        Release subReleaseTemplate = this.releaseService.findById(task.getTemplateId());
        Release releaseMetadata = this.getSubReleaseParamsFromTask(task, subReleaseTemplate);
        String rootReleaseId = Optional.ofNullable(task.getRelease().getRootReleaseId()).orElse(task.getRelease().getId());
        try {
            this.throwIfMaxConcurrencyReached(this.releaseService.findByIdIncludingArchived(rootReleaseId));
        }
        catch (NotFoundException ex) {
            logger.debug(String.format("Root release not found. Missing release max concurrency check. Reason: %s.", ex.getMessage()), (Throwable)ex);
        }
        releaseMetadata.setRootReleaseId(rootReleaseId);
        releaseMetadata.setOwner(scriptUsernamePass.username());
        releaseMetadata.setScriptUsername(scriptUsernamePass.username());
        releaseMetadata.setScriptUserPassword(scriptUsernamePass.password());
        EncryptionHelper.decrypt((ConfigurationItem)releaseMetadata);
        Release subRelease = this.releaseService.createFromTemplate(task.getTemplateId(), releaseMetadata, task.getFolderId());
        this.releaseActorService.addCommentToTask(task.getId(), String.format("Created release %s.", this.getReleaseLink(subRelease)));
        this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(subRelease, (ReleaseCreationSource)new CreatedFromCreateReleaseTask(task, subReleaseTemplate.getId())));
        return subRelease;
    }

    private boolean startRelease(CreateReleaseTask task, Release subRelease) {
        Release startedRelease = this.releaseActorService.startRelease(subRelease.getId(), User.SYSTEM);
        boolean hasBeenStarted = startedRelease.getStatus().hasBeenStarted();
        if (hasBeenStarted) {
            this.releaseActorService.addCommentToTask(task.getId(), String.format("Started release %s.", this.getReleaseLink(startedRelease)));
            this.eventBus.publish((XLReleaseEvent)new ReleaseStartedFromCreateReleaseTaskEvent(task, subRelease));
        }
        return hasBeenStarted;
    }

    private void throwIfMaxConcurrencyReached(Release rootRelease) {
        int maxConcurrency = rootRelease.getMaxConcurrentReleases();
        List<Release> spawnedReleases = this.releaseService.findSpawnedReleases(rootRelease.getId(), maxConcurrency);
        int currentlyRunning = spawnedReleases.size() + (rootRelease.isDefunct() ? 0 : 1);
        logger.debug("maxConcurrency: {}, currently running releases ({}): {}", new Object[]{maxConcurrency, currentlyRunning, spawnedReleases});
        if (currentlyRunning >= maxConcurrency) {
            throw new IllegalStateException(String.format("Exceeded maximum number of concurrent releases created from %s. Current maximum is %s. This value can be configured in deployit-defaults.properties: xlrelease.Release.maxConcurrentReleases", rootRelease.getTitle(), maxConcurrency));
        }
    }

    private Release getSubReleaseParamsFromTask(CreateReleaseTask task, Release subReleaseTemplate) {
        Map templateVariables = VariableHelper.indexByKey((List)subReleaseTemplate.getVariables());
        List variablesShownOnReleaseStart = task.getTemplateVariables().stream().filter(variable -> templateVariables.containsKey(variable.getKey()) && ((Variable)templateVariables.get(variable.getKey())).getShowOnReleaseStart()).collect(Collectors.toList());
        List variables = VariableHelper.fillVariableValues((List)subReleaseTemplate.getVariables(), variablesShownOnReleaseStart);
        Release release = ReleaseBuilder.newRelease().withVariables(variables).withOriginTemplateId(task.getTemplateId()).withTitle(task.getNewReleaseTitle()).withDisableNotifications(task.getRelease().isDisableNotifications()).withTags(new ArrayList(task.getReleaseTags())).build();
        release.setProperty("riskProfile", task.getProperty("riskProfile"));
        this.releaseService.setDatesFromTemplate(release, subReleaseTemplate);
        release.setStartedFromTaskId(task.getId());
        release.setAbortOnFailure(subReleaseTemplate.isAbortOnFailure());
        release.setAllowPasswordsInAllFields(subReleaseTemplate.isAllowPasswordsInAllFields());
        VariablePersistenceHelper.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        return release;
    }

    private void saveCreatedReleaseIdIntoVariable(CreateReleaseTask task, Release subRelease) {
        String variableKey;
        String variableName = "";
        if (VariableHelper.containsOnlyVariable((String)task.getCreatedReleaseId())) {
            variableName = task.getCreatedReleaseId();
        }
        if (task.getVariableMapping().containsKey("createdReleaseId")) {
            variableName = (String)task.getVariableMapping().get("createdReleaseId");
        }
        String createdReleaseId = subRelease.getId();
        Map variablesByKeys = task.getRelease().getVariablesByKeys();
        if (variablesByKeys.containsKey(variableKey = VariableHelper.withoutVariableSyntax((String)variableName))) {
            Variable variable = (Variable)variablesByKeys.get(variableKey);
            variable.setUntypedValue((Object)createdReleaseId);
            this.releaseActorService.updateVariable(variable.getId(), variable);
        }
    }

    private void saveCreatedReleaseIdIntoTask(CreateReleaseTask task, Release subRelease) {
        if (task.getVariableMapping().containsKey("createdReleaseId")) {
            task.getVariableMapping().remove("createdReleaseId");
        }
        task.setCreatedReleaseId(subRelease.getId());
        this.releaseActorService.updateTask(task.getId(), (Task)task, Collections.singleton(TaskUpdateDirective.UPDATE_RELEASE_TASK), true);
    }

    private String getReleaseLink(Release release) {
        return String.format("[%s](#/releases/%s)", release.getTitle(), IdType.DOMAIN.convertToViewId(release.getId()));
    }

    private void failTask(CreateReleaseTask task, String message) {
        this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.CREATE_RELEASE_TASK_FAILED.format(new Object[]{message}), User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option.empty());
    }

    private void completeTask(CreateReleaseTask task) {
        this.releaseActorService.markTaskAsDoneAsync(TaskStatus.COMPLETED, task.getId(), null, User.SYSTEM);
    }
}

