/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.configuration.CustomLogoSettings;
import com.xebialabs.xlrelease.configuration.PollingSettings;
import com.xebialabs.xlrelease.configuration.ReportsSettings;
import com.xebialabs.xlrelease.configuration.ThemeColor;
import com.xebialabs.xlrelease.configuration.ThemeColors$;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0006\r\u0001UA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!)\u0001\b\u0001C\u0001s!)\u0001\b\u0001C\u00015\")\u0011\r\u0001C\u0001E\")A\r\u0001C\u0001K\")\u0001\u000e\u0001C\u0001S\")\u0001\u000f\u0001C\u0005c\")A\u000f\u0001C\u0001k\n!2i\u001c8gS\u001e,(/\u0019;j_:\u001cVM\u001d<jG\u0016T!!\u0004\b\u0002\u000fM,'O^5dK*\u0011q\u0002E\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0005\n\u0002\u0013a,'-[1mC\n\u001c(\"A\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nQa\u001d7gi)T\u0011!I\u0001\tOJL'P\u001f7fI&\u00111E\b\u0002\b\u0019><w-\u001b8h\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002'S5\tqE\u0003\u0002)\u001d\u0005Q!/\u001a9pg&$xN]=\n\u0005):#aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003!)g/\u001a8u\u0005V\u001c\bCA\u00171\u001b\u0005q#BA\u0018\u000f\u0003\u0019)g/\u001a8ug&\u0011\u0011G\f\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018A\u0002\u001fj]&$h\bF\u00025m]\u0002\"!\u000e\u0001\u000e\u00031AQ\u0001J\u0002A\u0002\u0015BQaK\u0002A\u00021\nab\u0019:fCR,wJ]+qI\u0006$X\rF\u0002;\u00016\u0003\"a\u000f \u000e\u0003qR!!\u0010\b\u0002\r\u0011|W.Y5o\u0013\tyDHA\tCCN,7i\u001c8gS\u001e,(/\u0019;j_:DQ!\u0011\u0003A\u0002\t\u000b!!\u001b3\u0011\u0005\rSeB\u0001#I!\t)\u0005$D\u0001G\u0015\t9E#\u0001\u0004=e>|GOP\u0005\u0003\u0013b\ta\u0001\u0015:fI\u00164\u0017BA&M\u0005\u0019\u0019FO]5oO*\u0011\u0011\n\u0007\u0005\u0006\u001d\u0012\u0001\rAO\u0001\u0012G>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007F\u0001\u0003Q!\t\t\u0006,D\u0001S\u0015\t\u0019F+\u0001\u0006b]:|G/\u0019;j_:T!!\u0016,\u0002\u000f5,GO]5dg*\u0011qKE\u0001\tG>$\u0017\r[1mK&\u0011\u0011L\u0015\u0002\u0006)&lW\r\u001a\u000b\u00037z\u0003\"a\u0006/\n\u0005uC\"\u0001B+oSRDQaX\u0003A\u0002i\nQbY8oM&<WO]1uS>t\u0007FA\u0003Q\u0003\u0011\u0011X-\u00193\u0015\u0005i\u001a\u0007\"B!\u0007\u0001\u0004\u0011\u0015A\u00023fY\u0016$X\r\u0006\u0002\\M\")\u0011i\u0002a\u0001\u0005\"\u0012q\u0001U\u0001\u0011O\u0016$H\u000b[3nKN+G\u000f^5oON,\u0012A\u001b\t\u0003W6l\u0011\u0001\u001c\u0006\u0003?:I!A\u001c7\u0003\u001bQCW-\\3TKR$\u0018N\\4tQ\tA\u0001+\u0001\fd_:4XM\u001d;D_2|'OT1nKR{7i\u001c3f)\tQ'\u000fC\u0003t\u0013\u0001\u0007!.A\u0007uQ\u0016lWmU3ui&twm]\u0001\u000fg\u00064XmQ;ti>lGj\\4p)\t1\u0018\u0010\u0005\u0002lo&\u0011\u0001\u0010\u001c\u0002\u0013\u0007V\u001cHo\\7M_\u001e|7+\u001a;uS:<7\u000fC\u0003{\u0015\u0001\u0007a/\u0001\ndkN$x.\u001c'pO>\u001cV\r\u001e;j]\u001e\u001c\bF\u0001\u0006QQ\t\u0001Q\u0010E\u0002\u007f\u0003\u0017i\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!!\u0002\u0002\b\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\n\u0005\u0019qN]4\n\u0007\u00055qPA\u0004TKJ4\u0018nY3")
public class ConfigurationService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ConfigurationService configurationService = this;
        synchronized (configurationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public BaseConfiguration createOrUpdate(String id, BaseConfiguration configurationItem) {
        BaseConfiguration baseConfiguration = configurationItem;
        if (baseConfiguration instanceof ReportsSettings) {
            ReportsSettings reportsSettings = (ReportsSettings)baseConfiguration;
            reportsSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof ArchivingSettings) {
            ArchivingSettings archivingSettings = (ArchivingSettings)baseConfiguration;
            archivingSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof PollingSettings) {
            PollingSettings pollingSettings = (PollingSettings)baseConfiguration;
            pollingSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof ThemeSettings) {
            ThemeSettings themeSettings = (ThemeSettings)baseConfiguration;
            themeSettings.setHeaderAccentColor(((Enum)ThemeColors$.MODULE$.themeColorFromCode().apply((Object)themeSettings.getHeaderAccentColor().toUpperCase())).name());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof AuditReportSettings) {
            AuditReportSettings auditReportSettings = (AuditReportSettings)baseConfiguration;
            auditReportSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        configurationItem.setId(id);
        this.createOrUpdate(configurationItem);
        return this.read(id);
    }

    @Timed
    public void createOrUpdate(BaseConfiguration configuration) {
        if (!Ids.isNullId((String)configuration.getId()) && this.configurationRepository.exists(configuration.getId())) {
            Object original = this.configurationRepository.read(configuration.getId());
            PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)new Some(original), (ConfigurationItem)configuration);
            this.configurationRepository.update(configuration);
            this.eventBus.publish((XLReleaseEvent)new ConfigurationUpdatedEvent(configuration));
        } else {
            this.configurationRepository.create(configuration);
            this.eventBus.publish((XLReleaseEvent)new ConfigurationCreatedEvent(configuration));
        }
    }

    public BaseConfiguration read(String id) {
        Object object;
        Object baseConfiguration = this.configurationRepository.read(id);
        Object t = baseConfiguration;
        if (t instanceof ThemeSettings) {
            ThemeSettings themeSettings = (ThemeSettings)((Object)t);
            object = this.convertColorNameToCode(themeSettings);
        } else {
            object = t;
        }
        return object;
    }

    @Timed
    public void delete(String id) {
        Object conf = this.configurationRepository.read(id);
        this.configurationRepository.delete(id);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationDeletedEvent(conf));
    }

    @Timed
    public ThemeSettings getThemeSettings() {
        ThemeSettings themeSettings = this.configurationRepository.getThemeSettings();
        return this.convertColorNameToCode(themeSettings);
    }

    private ThemeSettings convertColorNameToCode(ThemeSettings themeSettings) {
        themeSettings.setHeaderAccentColor(ThemeColors$.MODULE$.colorCode(ThemeColor.valueOf((String)themeSettings.getHeaderAccentColor().toUpperCase())));
        return themeSettings;
    }

    @Timed
    public CustomLogoSettings saveCustomLogo(CustomLogoSettings customLogoSettings) {
        customLogoSettings.validateContentType();
        return (CustomLogoSettings)this.createOrUpdate("Configuration/settings/CustomLogoSettings", customLogoSettings);
    }

    public ConfigurationService(ConfigurationRepository configurationRepository, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

